---
UID: NS:ddraw._DDCAPS_DX7
title: DDCAPS_DX7 (ddraw.h)
description: The DDCAPS structure represents the capabilities of the hardware exposed through the DirectDraw object.
old-location: directdraw\ddcaps.htm
tech.root: directdraw
ms.assetid: 4ddda0a7-c0db-47cf-a908-959aabb530c6
ms.date: 12/05/2018
ms.keywords: '*LPDDCAPS, *LPDDCAPS_DX7, DDCAPS, DDCAPS structure [DirectDraw], DDCAPS2_AUTOFLIPOVERLAY, DDCAPS2_CANBOBHARDWARE, DDCAPS2_CANBOBINTERLEAVED, DDCAPS2_CANBOBNONINTERLEAVED, DDCAPS2_CANCALIBRATEGAMMA, DDCAPS2_CANDROPZ16BIT, DDCAPS2_CANFLIPODDEVEN, DDCAPS2_CANMANAGETEXTURE, DDCAPS2_CANRENDERWINDOWED, DDCAPS2_CERTIFIED, DDCAPS2_COLORCONTROLOVERLAY, DDCAPS2_COLORCONTROLPRIMARY, DDCAPS2_COPYFOURCC, DDCAPS2_FLIPINTERVAL, DDCAPS2_FLIPNOVSYNC, DDCAPS2_NO2DDURING3DSCENE, DDCAPS2_NONLOCALVIDMEM, DDCAPS2_NONLOCALVIDMEMCAPS, DDCAPS2_NOPAGELOCKREQUIRED, DDCAPS2_PRIMARYGAMMA, DDCAPS2_STEREO, DDCAPS2_TEXMANINNONLOCALVIDMEM, DDCAPS2_VIDEOPORT, DDCAPS2_WIDESURFACES, DDCAPS_3D, DDCAPS_ALIGNBOUNDARYDEST, DDCAPS_ALIGNBOUNDARYSRC, DDCAPS_ALIGNSIZEDEST, DDCAPS_ALIGNSIZESRC, DDCAPS_ALIGNSTRIDE, DDCAPS_ALPHA, DDCAPS_BANKSWITCHED, DDCAPS_BLT, DDCAPS_BLTCOLORFILL, DDCAPS_BLTDEPTHFILL, DDCAPS_BLTFOURCC, DDCAPS_BLTQUEUE, DDCAPS_BLTSTRETCH, DDCAPS_CANBLTSYSMEM, DDCAPS_CANCLIP, DDCAPS_CANCLIPSTRETCHED, DDCAPS_COLORKEY, DDCAPS_COLORKEYHWASSIST, DDCAPS_DX7, DDCAPS_GDI, DDCAPS_NOHARDWARE, DDCAPS_OVERLAY, DDCAPS_OVERLAYCANTCLIP, DDCAPS_OVERLAYFOURCC, DDCAPS_OVERLAYSTRETCH, DDCAPS_PALETTE, DDCAPS_PALETTEVSYNC, DDCAPS_READSCANLINE, DDCAPS_VBI, DDCAPS_ZBLTS, DDCAPS_ZOVERLAYS, DDCKEYCAPS_DESTBLT, DDCKEYCAPS_DESTBLTCLRSPACE, DDCKEYCAPS_DESTBLTCLRSPACEYUV, DDCKEYCAPS_DESTBLTYUV, DDCKEYCAPS_DESTOVERLAY, DDCKEYCAPS_DESTOVERLAYCLRSPACE, DDCKEYCAPS_DESTOVERLAYCLRSPACEYUV, DDCKEYCAPS_DESTOVERLAYONEACTIVE, DDCKEYCAPS_DESTOVERLAYYUV, DDCKEYCAPS_NOCOSTOVERLAY, DDCKEYCAPS_SRCBLT, DDCKEYCAPS_SRCBLTCLRSPACE, DDCKEYCAPS_SRCBLTCLRSPACEYUV, DDCKEYCAPS_SRCBLTYUV, DDCKEYCAPS_SRCOVERLAY, DDCKEYCAPS_SRCOVERLAYCLRSPACE, DDCKEYCAPS_SRCOVERLAYCLRSPACEYUV, DDCKEYCAPS_SRCOVERLAYONEACTIVE, DDCKEYCAPS_SRCOVERLAYYUV, DDFXALPHACAPS_BLTALPHAEDGEBLEND, DDFXALPHACAPS_BLTALPHAPIXELS, DDFXALPHACAPS_BLTALPHAPIXELSNEG, DDFXALPHACAPS_BLTALPHASURFACES, DDFXALPHACAPS_BLTALPHASURFACESNEG, DDFXALPHACAPS_OVERLAYALPHAEDGEBLEND, DDFXALPHACAPS_OVERLAYALPHAPIXELS, DDFXALPHACAPS_OVERLAYALPHAPIXELSNEG, DDFXALPHACAPS_OVERLAYALPHASURFACES, DDFXALPHACAPS_OVERLAYALPHASURFACESNEG, DDFXCAPS_BLTALPHA, DDFXCAPS_BLTARITHSTRETCHY, DDFXCAPS_BLTARITHSTRETCHYN, DDFXCAPS_BLTFILTER, DDFXCAPS_BLTMIRRORLEFTRIGHT, DDFXCAPS_BLTMIRRORUPDOWN, DDFXCAPS_BLTROTATION, DDFXCAPS_BLTROTATION90, DDFXCAPS_BLTSHRINKX, DDFXCAPS_BLTSHRINKXN, DDFXCAPS_BLTSHRINKY, DDFXCAPS_BLTSHRINKYN, DDFXCAPS_BLTSTRETCHX, DDFXCAPS_BLTSTRETCHXN, DDFXCAPS_BLTSTRETCHY, DDFXCAPS_BLTSTRETCHYN, DDFXCAPS_BLTTRANSFORM, DDFXCAPS_OVERLAYALPHA, DDFXCAPS_OVERLAYARITHSTRETCHY, DDFXCAPS_OVERLAYARITHSTRETCHYN, DDFXCAPS_OVERLAYFILTER, DDFXCAPS_OVERLAYMIRRORLEFTRIGHT, DDFXCAPS_OVERLAYMIRRORUPDOWN, DDFXCAPS_OVERLAYSHRINKX, DDFXCAPS_OVERLAYSHRINKXN, DDFXCAPS_OVERLAYSHRINKY, DDFXCAPS_OVERLAYSHRINKYN, DDFXCAPS_OVERLAYSTRETCHX, DDFXCAPS_OVERLAYSTRETCHXN, DDFXCAPS_OVERLAYSTRETCHY, DDFXCAPS_OVERLAYSTRETCHYN, DDFXCAPS_OVERLAYTRANSFORM, DDPCAPS_1BIT, DDPCAPS_2BIT, DDPCAPS_4BIT, DDPCAPS_8BIT, DDPCAPS_8BITENTRIES, DDPCAPS_ALLOW256, DDPCAPS_ALPHA, DDPCAPS_PRIMARYSURFACE, DDPCAPS_PRIMARYSURFACELEFT, DDPCAPS_VSYNC, DDSVCAPS_RESERVED1,DDSVCAPS_RESERVED2,DDSVCAPS_RESERVED3,DDSVCAPS_RESERVED4, DDSVCAPS_STEREOSEQUENTIAL, LPDDCAPS, LPDDCAPS structure pointer [DirectDraw], ddraw/DDCAPS, ddraw/LPDDCAPS, directdraw.ddcaps'
f1_keywords:
- ddraw/DDCAPS
dev_langs:
- c++
req.header: ddraw.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Ddraw.h
api_name:
- DDCAPS
targetos: Windows
req.typenames: DDCAPS_DX7
req.redist: 
ms.custom: 19H1
---

# DDCAPS_DX7 structure


## -description


The DDCAPS structure represents the capabilities of the hardware exposed through the DirectDraw object. This structure contains a <a href="https://docs.microsoft.com/previous-versions/windows/hardware/drivers/ff550292(v=vs.85)">DDSCAPS2</a> structure used in this context to describe what kinds of DirectDrawSurface objects can be created. It might not be possible to create all the surfaces described by these capabilities simultaneously. This structure is used with the <a href="https://docs.microsoft.com/windows/desktop/api/ddraw/nf-ddraw-idirectdraw7-getcaps">IDirectDraw7::GetCaps</a> method.



The Ddraw.h header file contains multiple versions of this structure (for example, DDCAPS_DX7). For more information about how to determine which version to use, see Remarks.


## -struct-fields




### -field dwSize

Size of the structure, in bytes. This member must be initialized before the structure is used.


### -field dwCaps

This value consists of one or more of the following flags that specify hardware and driver capabilities:





#### DDCAPS_3D

The display hardware has 3-D acceleration.



#### DDCAPS_ALIGNBOUNDARYDEST

DirectDraw supports only those overlay destination rectangles with the x-axis aligned to the <b>dwAlignBoundaryDest</b> boundaries of the surface.



#### DDCAPS_ALIGNBOUNDARYSRC

DirectDraw supports only those overlay source rectangles with the x-axis aligned to the <b>dwAlignBoundarySrc</b> boundaries of the surface.



#### DDCAPS_ALIGNSIZEDEST

DirectDraw supports only those overlay destination rectangles whose x-axis sizes, in pixels, are <b>dwAlignSizeDest</b> multiples.



#### DDCAPS_ALIGNSIZESRC

DirectDraw supports only those overlay source rectangles whose x-axis sizes, in pixels, are <b>dwAlignSizeSrc</b> multiples.



#### DDCAPS_ALIGNSTRIDE

DirectDraw creates display memory surfaces that have a stride alignment equal to the <b>dwAlignStrideAlign</b> value.



#### DDCAPS_ALPHA

The display hardware supports alpha-only surfaces.



#### DDCAPS_BANKSWITCHED

The display hardware is bank-switched and is potentially very slow at random access to display memory.



#### DDCAPS_BLT

Display hardware is capable of bit block transfer (bitblt) operations.



#### DDCAPS_BLTCOLORFILL

Display hardware is capable of color filling with a blitter.



#### DDCAPS_BLTDEPTHFILL

Display hardware is capable of depth filling z-buffers with a blitter.



#### DDCAPS_BLTFOURCC

Display hardware is capable of color-space conversions during bitblt operations.



#### DDCAPS_BLTQUEUE

Display hardware is capable of asynchronous bitblt operations.



#### DDCAPS_BLTSTRETCH

Display hardware is capable of stretching during bitblt operations.



#### DDCAPS_CANBLTSYSMEM

Display hardware is capable of blitting to or from system memory.



#### DDCAPS_CANCLIP

Display hardware is capable of clipping with blitting.



#### DDCAPS_CANCLIPSTRETCHED

Display hardware is capable of clipping while stretch blitting.



#### DDCAPS_COLORKEY

Supports some form of color key in either overlay or bitblt operations. More specific color-key capability information can be found in the <b>dwCKeyCaps</b> member.



#### DDCAPS_COLORKEYHWASSIST

The color key is partially hardware-assisted. This means that other resources (CPU or video memory) might be used. If this bit is not set, full hardware support is in place.



#### DDCAPS_GDI

Display hardware is shared with GDI.



#### DDCAPS_NOHARDWARE

There is no hardware support.



#### DDCAPS_OVERLAY

Display hardware supports overlays.



#### DDCAPS_OVERLAYCANTCLIP

Display hardware supports overlays but cannot clip them.



#### DDCAPS_OVERLAYFOURCC

Overlay hardware is capable of color-space conversions during overlay operations.



#### DDCAPS_OVERLAYSTRETCH

Overlay hardware is capable of stretching. The <b>dwMinOverlayStretch</b> and <b>dwMaxOverlayStretch</b> members contain valid data.



#### DDCAPS_PALETTE

DirectDraw is capable of creating and supporting DirectDrawPalette objects for surfaces other than the primary surface.



#### DDCAPS_PALETTEVSYNC

DirectDraw is capable of updating a palette synchronized with the vertical refresh.



#### DDCAPS_READSCANLINE

Display hardware is capable of returning the current scan line.



#### DDCAPS_VBI

Display hardware is capable of generating a vertical-blank interrupt.



#### DDCAPS_ZBLTS

Supports the use of z-buffers with bitblt operations.



#### DDCAPS_ZOVERLAYS

Supports the use of the <a href="https://docs.microsoft.com/windows/desktop/api/ddraw/nf-ddraw-idirectdrawsurface7-updateoverlayzorder">IDirectDrawSurface7::UpdateOverlayZOrder</a> method as a z-value for overlays to control their layering.


### -field dwCaps2

This value consists of one or more of the following flags that specify more hardware and driver capabilities:



#### DDCAPS2_AUTOFLIPOVERLAY

The overlay can be automatically flipped to the next surface in the flipping chain each time that a video port VSYNC occurs, allowing the video port and the overlay to double-buffer the video without CPU overhead. This option is only valid when the surface is receiving data from a video port. If the video port data is noninterlaced or noninterleaved, it flips on every VSYNC. If the data is being interleaved in memory, it flips on every other VSYNC.



#### DDCAPS2_CANBOBHARDWARE

The overlay hardware can display each field of an interlaced video stream individually.



#### DDCAPS2_CANBOBINTERLEAVED

The overlay hardware can display each field of an interlaced video stream individually while it is interleaved in memory without causing any artifacts that might normally occur without special hardware support. This option is only valid when the surface is receiving data from a video port and the video is zoomed at least twice in the vertical direction.



#### DDCAPS2_CANBOBNONINTERLEAVED

The overlay hardware can display each field of an interlaced video stream individually while it is not interleaved in memory without causing any artifacts that might normally occur without special hardware support. This option is only valid when the surface is receiving data from a video port and the video is zoomed at least twice in the vertical direction.



#### DDCAPS2_CANCALIBRATEGAMMA

The system has a calibrator installed that can automatically adjust the gamma ramp so that the result is identical on all systems that have a calibrator. To invoke the calibrator when setting new gamma levels, use the DDSGR_CALIBRATE flag when calling the <a href="https://docs.microsoft.com/windows/desktop/api/ddraw/nf-ddraw-idirectdrawgammacontrol-setgammaramp">IDirectDrawGammaControl::SetGammaRamp</a> method. Calibrating gamma ramps incurs some processing overhead and should not be used frequently.



#### DDCAPS2_CANDROPZ16BIT

Sixteen-bit RGBZ values can be converted into 16-bit RGB values. (The system does not support 8-bit conversions.)



#### DDCAPS2_CANFLIPODDEVEN

The driver is capable of performing odd and even flip operations, as specified by the DDFLIP_ODD and DDFLIP_EVEN flags that are used with the <a href="https://docs.microsoft.com/windows/desktop/api/ddraw/nf-ddraw-idirectdrawsurface7-flip">IDirectDrawSurface7::Flip</a> method.



#### DDCAPS2_CANMANAGETEXTURE

The Direct3D texture manager uses this capability to decide whether to put managed surfaces in nonlocal video memory. If the capability is set, the texture manager puts managed surfaces in nonlocal video memory. Drivers that cannot texture from local video memory should not set this capability.



#### DDCAPS2_CANRENDERWINDOWED

The driver is capable of rendering in windowed mode.



#### DDCAPS2_CERTIFIED

Display hardware is certified.



#### DDCAPS2_COLORCONTROLPRIMARY

The primary surface contains color controls (for instance, gamma).



#### DDCAPS2_COLORCONTROLOVERLAY

The overlay surface contains color controls (such as brightness and sharpness).



#### DDCAPS2_COPYFOURCC

The driver supports blitting any FOURCC surface to another surface of the same FOURCC.



#### DDCAPS2_FLIPINTERVAL

The driver responds to the DDFLIP_INTERVAL* flags. (For more information about these flags, see <a href="https://docs.microsoft.com/windows/desktop/api/ddraw/nf-ddraw-idirectdrawsurface7-flip">IDirectDrawSurface7::Flip</a>). 




#### DDCAPS2_FLIPNOVSYNC

The driver responds to the DDFLIP_NOVSYNC flag (For more information about this flag, see <a href="https://docs.microsoft.com/windows/desktop/api/ddraw/nf-ddraw-idirectdrawsurface7-flip">IDirectDrawSurface7::Flip</a>).



#### DDCAPS2_NO2DDURING3DSCENE

Two-dimensional operations such as <a href="https://docs.microsoft.com/windows/desktop/api/ddraw/nf-ddraw-idirectdrawsurface7-blt">IDirectDrawSurface7::Blt</a> and <a href="https://docs.microsoft.com/windows/desktop/api/ddraw/nf-ddraw-idirectdrawsurface7-lock">IDirectDrawSurface7::Lock</a> cannot be performed on any surfaces that Direct3D is using between calls to the <a href="https://docs.microsoft.com/windows/desktop/api/d3d9/nf-d3d9-idirect3ddevice9-beginscene">BeginScene</a> and <a href="https://docs.microsoft.com/windows/desktop/api/d3d9/nf-d3d9-idirect3ddevice9-endscene">EndScene</a> methods.



#### DDCAPS2_NONLOCALVIDMEM

The display driver supports surfaces in nonlocal video memory.



#### DDCAPS2_NONLOCALVIDMEMCAPS

Bitblt capabilities for nonlocal video-memory surfaces differ from local video-memory surfaces. If this flag is present, the DDCAPS2_NONLOCALVIDMEM flag is also present.



#### DDCAPS2_NOPAGELOCKREQUIRED

DMA bitblt operations are supported on system-memory surfaces that are not page-locked.



#### DDCAPS2_PRIMARYGAMMA

Supports dynamic gamma ramps for the primary surface.



#### DDCAPS2_STEREO

New for DirectX 7.0. Turns on the <b>dwSVCaps</b> bit to support stereo mode. The driver can do stereo in at least one mode other than the current mode. The application can use <a href="https://docs.microsoft.com/windows/desktop/api/ddraw/nf-ddraw-idirectdraw7-getdisplaymode">IDirectDraw7::GetDisplayMode</a> or <a href="https://docs.microsoft.com/windows/desktop/api/ddraw/nf-ddraw-idirectdraw7-enumdisplaymodes">IDirectDraw7::EnumDisplayModes</a> to get per-mode stereo information.



#### DDCAPS2_TEXMANINNONLOCALVIDMEM

New for DirectX 7.0. The Direct3D texture manager uses this capability to decide whether to put managed surfaces in nonlocal video memory. If the capability is set, the texture manager puts managed surfaces in nonlocal video memory. Drivers that cannot texture from local video memory should not set this capability.



#### DDCAPS2_VIDEOPORT

Display hardware supports live video.



#### DDCAPS2_WIDESURFACES

The display surface supports surfaces wider than the primary surface.


### -field dwCKeyCaps

This value consists of one or more of the following flags that specify color-key capabilities:



#### DDCKEYCAPS_DESTBLT

Supports transparent blitting with a color key that identifies the replaceable bits of the destination surface for RGB colors.



#### DDCKEYCAPS_DESTBLTCLRSPACE

Supports transparent blitting with a color space that identifies the replaceable bits of the destination surface for RGB colors.



#### DDCKEYCAPS_DESTBLTCLRSPACEYUV

Supports transparent blitting with a color space that identifies the replaceable bits of the destination surface for YUV colors.



#### DDCKEYCAPS_DESTBLTYUV

Supports transparent blitting with a color key that identifies the replaceable bits of the destination surface for YUV colors.



#### DDCKEYCAPS_DESTOVERLAY

Supports overlaying with color keying of the replaceable bits of the destination surface to be overlaid for RGB colors.



#### DDCKEYCAPS_DESTOVERLAYCLRSPACE

Supports a color space as the color key for the destination of RGB colors.



#### DDCKEYCAPS_DESTOVERLAYCLRSPACEYUV

Supports a color space as the color key for the destination of YUV colors.



#### DDCKEYCAPS_DESTOVERLAYONEACTIVE

Supports only one active destination color key value for visible overlay surfaces.



#### DDCKEYCAPS_DESTOVERLAYYUV

Supports overlaying, using color keying of the replaceable bits of the destination surface to be overlaid for YUV colors.



#### DDCKEYCAPS_NOCOSTOVERLAY

Indicates that there are no bandwidth trade-offs for using the color key with an overlay.



#### DDCKEYCAPS_SRCBLT

Supports transparent blitting, using the color key for the source with this surface for RGB colors.



#### DDCKEYCAPS_SRCBLTCLRSPACE

Supports transparent blitting, using a color space for the source with this surface for RGB colors.



#### DDCKEYCAPS_SRCBLTCLRSPACEYUV

Supports transparent blitting, using a color space for the source with this surface for YUV colors.



#### DDCKEYCAPS_SRCBLTYUV

Supports transparent blitting, using the color key for the source with this surface for YUV colors.



#### DDCKEYCAPS_SRCOVERLAY

Supports overlaying, using the color key for the source with this overlay surface for RGB colors.



#### DDCKEYCAPS_SRCOVERLAYCLRSPACE

Supports overlaying, using a color space as the source color key for the overlay surface for RGB colors.



#### DDCKEYCAPS_SRCOVERLAYCLRSPACEYUV

Supports overlaying, using a color space as the source color key for the overlay surface for YUV colors.



#### DDCKEYCAPS_SRCOVERLAYONEACTIVE

Supports only one active source color key value for visible overlay surfaces.



#### DDCKEYCAPS_SRCOVERLAYYUV

Supports overlaying, using the color key for the source with this overlay surface for YUV colors.


### -field dwFXCaps

This value consists of one or more of the following flags that specify driver stretching and effects capabilities:



#### DDFXCAPS_BLTALPHA

Supports alpha-blended bitblt operations.



#### DDFXCAPS_BLTARITHSTRETCHY

Uses arithmetic operations, rather than pixel-doubling techniques, to stretch and shrink surfaces during a bitblt operation. Occurs along the y-axis (vertically).



#### DDFXCAPS_BLTARITHSTRETCHYN

Uses arithmetic operations, rather than pixel-doubling techniques, to stretch and shrink surfaces during a bitblt operation. Occurs along the y-axis (vertically), and works only for integer stretching (×1, ×2, and so on).



#### DDFXCAPS_BLTFILTER

Driver can do surface-reconstruction filtering for warped bitblts.



#### DDFXCAPS_BLTMIRRORLEFTRIGHT

Supports mirroring left to right in a bitblt operation.



#### DDFXCAPS_BLTMIRRORUPDOWN

Supports mirroring top to bottom in a bitblt operation.



#### DDFXCAPS_BLTROTATION

Supports arbitrary rotation in a bitblt operation.



#### DDFXCAPS_BLTROTATION90

Supports 90-degree rotations in a bitblt operation.



#### DDFXCAPS_BLTSHRINKX

Supports arbitrary shrinking of a surface along the x-axis (horizontally). This flag is valid only for bitblt operations.



#### DDFXCAPS_BLTSHRINKXN

Supports integer shrinking (×1, ×2, and so on) of a surface along the x-axis (horizontally). This flag is valid only for bitblt operations.



#### DDFXCAPS_BLTSHRINKY

Supports arbitrary shrinking of a surface along the y-axis (vertically). This flag is valid only for bitblt operations.



#### DDFXCAPS_BLTSHRINKYN

Supports integer shrinking (×1, ×2, and so on) of a surface along the y-axis (vertically). This flag is valid only for bitblt operations.



#### DDFXCAPS_BLTSTRETCHX

Supports arbitrary stretching of a surface along the x-axis (horizontally). This flag is valid only for bitblt operations.



#### DDFXCAPS_BLTSTRETCHXN

Supports integer stretching (×1, ×2, and so on) of a surface along the x-axis (horizontally). This flag is valid only for bitblt operations.



#### DDFXCAPS_BLTSTRETCHY

Supports arbitrary stretching of a surface along the y-axis (vertically). This flag is valid only for bitblt operations.



#### DDFXCAPS_BLTSTRETCHYN

Supports integer stretching (×1, ×2, and so on) of a surface along the y-axis (vertically). This flag is valid only for bitblt operations.



#### DDFXCAPS_BLTTRANSFORM

Supports geometric transformations (or warps) for blitted sprites. Transformations are not currently supported for explicit bitblt operations.



#### DDFXCAPS_OVERLAYALPHA

Supports alpha blending for overlay surfaces.



#### DDFXCAPS_OVERLAYARITHSTRETCHY

Uses arithmetic operations, rather than pixel-doubling techniques, to stretch and shrink overlay surfaces. Occurs along the y-axis (vertically).



#### DDFXCAPS_OVERLAYARITHSTRETCHYN

Uses arithmetic operations, rather than pixel-doubling techniques, to stretch and shrink overlay surfaces. Occurs along the y-axis (vertically), and works only for integer stretching (×1, ×2, and so on).



#### DDFXCAPS_OVERLAYFILTER

Supports surface-reconstruction filtering for warped overlay sprites. Filtering is not currently supported for explicitly displayed overlay surfaces (those displayed with calls to <a href="https://docs.microsoft.com/windows/desktop/api/ddraw/nf-ddraw-idirectdrawsurface7-updateoverlay">IDirectDrawSurface7::UpdateOverlay</a>).



#### DDFXCAPS_OVERLAYMIRRORLEFTRIGHT

Supports mirroring of overlays across the vertical axis.



#### DDFXCAPS_OVERLAYMIRRORUPDOWN

Supports mirroring of overlays across the horizontal axis.



#### DDFXCAPS_OVERLAYSHRINKX

Supports arbitrary shrinking of a surface along the x-axis (horizontally). This flag is valid only for DDSCAPS_OVERLAY surfaces. This flag indicates only the capabilities of a surface; it does not indicate that shrinking is available.



#### DDFXCAPS_OVERLAYSHRINKXN

Supports integer shrinking (×1, ×2, and so on) of a surface along the x-axis (horizontally). This flag is valid only for DDSCAPS_OVERLAY surfaces. This flag indicates only the capabilities of a surface; it does not indicate that shrinking is available.



#### DDFXCAPS_OVERLAYSHRINKY

Supports arbitrary shrinking of a surface along the y-axis (vertically). This flag is valid only for DDSCAPS_OVERLAY surfaces. This flag indicates only the capabilities of a surface; it does not indicate that shrinking is available.



#### DDFXCAPS_OVERLAYSHRINKYN

Supports integer shrinking (×1, ×2, and so on) of a surface along the y-axis (vertically). This flag is valid only for DDSCAPS_OVERLAY surfaces. This flag indicates only the capabilities of a surface; it does not indicate that shrinking is available.



#### DDFXCAPS_OVERLAYSTRETCHX

Supports arbitrary stretching of a surface along the x-axis (horizontally). This flag is valid only for DDSCAPS_OVERLAY surfaces. This flag indicates only the capabilities of a surface; it does not indicate that stretching is available.



#### DDFXCAPS_OVERLAYSTRETCHXN

Supports integer stretching (×1, ×2, and so on) of a surface along the x-axis (horizontally). This flag is valid only for DDSCAPS_OVERLAY surfaces. This flag indicates only the capabilities of a surface; it does not indicate that stretching is available.



#### DDFXCAPS_OVERLAYSTRETCHY

Supports arbitrary stretching of a surface along the y-axis (vertically). This flag is valid only for DDSCAPS_OVERLAY surfaces. This flag indicates only the capabilities of a surface; it does not indicate that stretching is available.



#### DDFXCAPS_OVERLAYSTRETCHYN

Supports integer stretching (×1, ×2, and so on) of a surface along the y-axis (vertically). This flag is valid only for DDSCAPS_OVERLAY surfaces. This flag indicates only the capabilities of a surface; it does not indicate that stretching is available.



#### DDFXCAPS_OVERLAYTRANSFORM

Supports geometric transformations (or warps) for overlay sprites. Transformations are not currently supported for explicitly displayed overlay surfaces (those displayed with calls to <a href="https://docs.microsoft.com/windows/desktop/api/ddraw/nf-ddraw-idirectdrawsurface7-updateoverlay">IDirectDrawSurface7::UpdateOverlay</a>).


### -field dwFXAlphaCaps

This value consists of one or more of the following flags that specify driver alpha capabilities:



#### DDFXALPHACAPS_BLTALPHAEDGEBLEND

Supports alpha blending around the edge of a source color-keyed surface. Used for bitblt operations.



#### DDFXALPHACAPS_BLTALPHAPIXELS

Supports alpha information in pixel format. The bit depth of alpha information in the pixel format can be 1, 2, 4, or 8. The alpha value becomes more opaque as the alpha value increases. Regardless of the depth of the alpha information, 0 is always the fully transparent value. Used for bitblt operations.



#### DDFXALPHACAPS_BLTALPHAPIXELSNEG

Supports alpha information in pixel format. The bit depth of alpha information in the pixel format can be 1, 2, 4, or 8. The alpha value becomes more transparent as the alpha value increases. Regardless of the depth of the alpha information, 0 is always the fully opaque value. This flag can be used only if DDCAPS_ALPHA is set. Used for bitblt operations.



#### DDFXALPHACAPS_BLTALPHASURFACES

Supports alpha-only surfaces. The bit depth of an alpha-only surface can be 1, 2, 4, or 8. The alpha value becomes more opaque as the alpha value increases. Regardless of the depth of the alpha information, 0 is always the fully transparent value. Used for bitblt operations.



#### DDFXALPHACAPS_BLTALPHASURFACESNEG

Indicates that the alpha channel becomes more transparent as the alpha value increases. The depth of the alpha channel-data can be 1, 2, 4, or 8. Regardless of the depth of the alpha information, 0 is always the fully opaque value. This flag can be set only if DDCAPS_ALPHA has been set. Used for bitblt operations.



#### DDFXALPHACAPS_OVERLAYALPHAEDGEBLEND

Supports alpha blending around the edge of a source color-keyed surface. Used for overlays.



#### DDFXALPHACAPS_OVERLAYALPHAPIXELS

Supports alpha information in pixel format. The bit depth of alpha information in pixel format can be 1, 2, 4, or 8. The alpha value becomes more opaque as the alpha value increases. Regardless of the depth of the alpha information, 0 is always the fully transparent value. Used for overlays.



#### DDFXALPHACAPS_OVERLAYALPHAPIXELSNEG

Supports alpha information in pixel format. The bit depth of alpha information in pixel format can be 1, 2, 4, or 8. The alpha value becomes more transparent as the alpha value increases. Regardless of the depth of the alpha information, 0 is always the fully opaque value. This flag can be used only if DDCAPS_ALPHA has been set. Used for overlays.



#### DDFXALPHACAPS_OVERLAYALPHASURFACES

Supports alpha-only surfaces. The bit depth of an alpha-only surface can be 1, 2, 4, or 8. The alpha value becomes more opaque as the alpha value increases. Regardless of the depth of the alpha information, 0 is always the fully transparent value. Used for overlays.



#### DDFXALPHACAPS_OVERLAYALPHASURFACESNEG

Indicates that the alpha channel becomes more transparent as the alpha value increases. The depth of the alpha-channel data can be 1, 2, 4, or 8. Regardless of the depth of the alpha information, 0 is always the fully opaque value. This flag can be used only if DDCAPS_ALPHA has been set. Used for overlays.


### -field dwPalCaps

This value consists of one or more of the following flags that specify palette capabilities:



#### DDPCAPS_1BIT

Supports palettes that contain 1-bit color entries (two colors).



#### DDPCAPS_2BIT

Supports palettes that contain 2-bit color entries (four colors).



#### DDPCAPS_4BIT

Supports palettes that contain 4-bit color entries (16 colors).



#### DDPCAPS_8BIT

Supports palettes that contain 8-bit color entries (256 colors).



#### DDPCAPS_8BITENTRIES

Specifies an index to an 8-bit color index. This field is valid only when used with the DDPCAPS_1BIT, DDPCAPS_2BIT, or DDPCAPS_4BIT capability and when the target surface is 8 bits per pixel (bpp). Each color entry is 1 byte long and is an index to an 8-bpp palette on the destination surface.



#### DDPCAPS_ALPHA

Supports palettes that include an alpha component. For alpha-capable palettes, the <b>peFlags</b> member of each <a href="https://docs.microsoft.com/previous-versions/dd162769(v=vs.85)">PALETTEENTRY</a> structure that the palette contains is to be interpreted as a single 8-bit alpha value (in addition to the color data in the <b>peRed</b>, <b>peGreen</b>, and <b>peBlue</b> members). A palette created with this flag can be attached only to a texture surface.



#### DDPCAPS_ALLOW256

Supports palettes that can have all 256 entries defined.



#### DDPCAPS_PRIMARYSURFACE

The palette is attached to the primary surface. Changing the palette has an immediate effect on the display unless the DDPCAPS_VSYNC capability is specified and supported.



#### DDPCAPS_PRIMARYSURFACELEFT

The palette is attached to the primary surface on the left. Changing the palette has an immediate effect on the display unless the DDPCAPS_VSYNC capability is specified and supported.



#### DDPCAPS_VSYNC

The palette can be modified synchronously with the monitor's refresh rate.


### -field dwSVCaps

This value consists of one or more of the following flags that specify stereo-vision capabilities:



#### DDSVCAPS_RESERVED1, DDSVCAPS_RESERVED2, DDSVCAPS_RESERVED3, DDSVCAPS_RESERVED4

Reserved flags.



#### DDSVCAPS_STEREOSEQUENTIAL

New for DirectX 7.0. The driver can do stereo in at least one mode other than the current mode. The application can use <a href="https://docs.microsoft.com/windows/desktop/api/ddraw/nf-ddraw-idirectdraw7-getdisplaymode">IDirectDraw7::GetDisplayMode</a> or <a href="https://docs.microsoft.com/windows/desktop/api/ddraw/nf-ddraw-idirectdraw7-enumdisplaymodes">IDirectDraw7::EnumDisplayModes</a> to get per-mode stereo information.


### -field dwAlphaBltConstBitDepths

DDBD_2, DDBD_4, or DDBD_8. (Indicate 2, 4, or 8 bits per pixel.)


### -field dwAlphaBltPixelBitDepths

DDBD_1, DDBD_2, DDBD_4, or DDBD_8. (Indicate 1, 2, 4, or 8 bits per pixel.)


### -field dwAlphaBltSurfaceBitDepths

DDBD_1, DDBD_2, DDBD_4, or DDBD_8. (Indicate 1, 2, 4, or 8 bits per pixel.)


### -field dwAlphaOverlayConstBitDepths

DDBD_2, DDBD_4, or DDBD_8. (Indicate 2, 4, or 8 bits per pixel.)


### -field dwAlphaOverlayPixelBitDepths

DDBD_1, DDBD_2, DDBD_4, or DDBD_8. (Indicate 1, 2, 4, or 8 bits per pixel.)


### -field dwAlphaOverlaySurfaceBitDepths

DDBD_1, DDBD_2, DDBD_4, or DDBD_8. (Indicate 1, 2, 4, or 8 bits per pixel.)


### -field dwZBufferBitDepths

DDBD_8, DDBD_16, DDBD_24, or DDBD_32. (Indicate 8, 16, 24, or 32 bits per pixel.) This member is obsolete for DirectX 6.0 and later. Use the <b>IDirect3D7::EnumZBufferFormats</b> to retrieve information about supported depth buffer formats.


### -field dwVidMemTotal

Total amount of display memory on the device, in bytes, minus memory reserved for the primary surface and any private data structures reserved by the driver. (This value is the same as the total video memory reported by the <a href="https://docs.microsoft.com/windows/desktop/api/ddraw/nf-ddraw-idirectdraw7-getavailablevidmem">IDirectDraw7::GetAvailableVidMem</a> method.) 



### -field dwVidMemFree

Free display memory. This value equals the value in <b>dwVidMemTotal</b>, minus any memory currently allocated by the application for surfaces. Unlike the <a href="https://docs.microsoft.com/windows/desktop/api/ddraw/nf-ddraw-idirectdraw7-getavailablevidmem">IDirectDraw7::GetAvailableVidMem</a> method, which reports the memory available for a particular type of surface (such as a texture), this value reflects the memory available for any type of surface.


### -field dwMaxVisibleOverlays

Maximum number of visible overlays or overlay sprites.


### -field dwCurrVisibleOverlays

Current number of visible overlays or overlay sprites.


### -field dwNumFourCCCodes

Number of FourCC codes.


### -field dwAlignBoundarySrc

Source-rectangle alignment for an overlay surface, in pixels.


### -field dwAlignSizeSrc

Source-rectangle size alignment for an overlay surface, in pixels. Overlay source rectangles must have a pixel width that is a multiple of this value.


### -field dwAlignBoundaryDest

Destination-rectangle alignment for an overlay surface, in pixels.


### -field dwAlignSizeDest

Destination-rectangle size alignment for an overlay surface, in pixels. Overlay destination rectangles must have a pixel width that is a multiple of this value.


### -field dwAlignStrideAlign

Stride alignment.


### -field dwRops

Raster operations supported.


#### - ddsOldCaps

Obsolete. Prior to DirectX 6.0, this member contained general surface capabilities, which are now contained in the <b>ddsCaps</b> member (a <a href="https://docs.microsoft.com/previous-versions/windows/hardware/drivers/ff550292(v=vs.85)">DDSCAPS2</a> structure).


### -field dwMinOverlayStretch

Minimum overlay stretch factor, multiplied by 1000. For example, 1.3 = 1300.


### -field dwMaxOverlayStretch

Maximum overlay stretch factor, multiplied by 1000. For example, 1.3 = 1300.


### -field dwMinLiveVideoStretch

Obsolete; do not use.


### -field dwMaxLiveVideoStretch

Obsolete; do not use.


### -field dwMinHwCodecStretch

Obsolete; do not use.


### -field dwMaxHwCodecStretch

Obsolete; do not use.


### -field dwReserved1

Reserved


### -field dwReserved2

Reserved


### -field dwReserved3

Reserved


### -field dwSVBCaps

Driver-specific capabilities for bitblts from system memory to display memory. Valid flags are identical to the bitblt-related flags that are used with the <b>dwCaps</b> member.


### -field dwSVBCKeyCaps

Driver color-key capabilities for bitblts from system memory to display memory. Valid flags are identical to the bitblt-related flags that are used with the <b>dwCKeyCaps</b> member. 



### -field dwSVBFXCaps

Driver FX capabilities for bitblts from system memory to display memory. Valid flags are identical to the bitblt-related flags that are used with the <b>dwFXCaps</b> member.


### -field dwSVBRops

Raster operations supported for bitblts from system memory to display memory.


### -field dwVSBCaps

Driver-specific capabilities for bitblts from display memory to system memory. Valid flags are identical to the bitblt-related flags that are used with the <b>dwCaps</b> member.


### -field dwVSBCKeyCaps

Driver color-key capabilities for bitblts from display memory to system memory. Valid flags are identical to the bitblt-related flags that are used with the <b>dwCKeyCaps</b> member.


### -field dwVSBFXCaps

Driver FX capabilities for bitblts from display memory to system memory. Valid flags are identical to the bitblt-related flags used with the <b>dwFXCaps</b> member.


### -field dwVSBRops

Raster operations supported for bitblts from display memory to system memory.


### -field dwSSBCaps

Driver-specific capabilities for bitblts from system memory to system memory. Valid flags are identical to the bitblt-related flags used with the <b>dwCaps</b> member.


### -field dwSSBCKeyCaps

Driver color-key capabilities for bitblts from system memory to system memory. Valid flags are identical to the bitblt-related flags used with the <b>dwCKeyCaps</b> member.


### -field dwSSBFXCaps

Driver FX capabilities for bitblts from system memory to system memory. Valid flags are identical to the bitblt-related flags used with the <b>dwFXCaps</b> member.


### -field dwSSBRops

Raster operations supported for bitblts from system memory to system memory.


#### - dwMaxVideoPorts

Maximum number of live video ports.


#### - dwCurrVideoPorts

Current number of live video ports.


#### - dwSVBCaps2

More driver-specific capabilities for bitblts from system memory to video memory. Valid flags are identical to the bitblt-related flags used with the <b>dwCaps2</b> member.


#### - dwNLVBCaps

Driver-specific capabilities for bitblts from nonlocal to local video memory. Valid flags are identical to the bitblt-related flags used with the <b>dwCaps</b> member.


#### - dwNLVBCaps2

More driver-specific capabilities for bitblts from nonlocal to local video memory. Valid flags are identical to the bitblt-related flags used with the <b>dwCaps2</b> member.


#### - dwNLVBCKeyCaps

Driver color-key capabilities for bitblts form nonlocal to local video memory. Valid flags are identical to the bitblt-related flags used with the <b>dwCKeyCaps</b> member.


#### - dwNLVBFXCaps

Driver FX capabilities for bitblts from nonlocal to local video memory. Valid flags are identical to the bitblt-related flags used with the <b>dwFXCaps</b> member.


#### - dwNLVBRops

Raster operations supported for bitblts from nonlocal to local video memory.


### -field ddsCaps

A <a href="https://docs.microsoft.com/previous-versions/windows/hardware/drivers/ff550292(v=vs.85)">DDSCAPS2</a> structure that contains general surface capabilities.


##### - dwCKeyCaps.DDCKEYCAPS_DESTBLT

Supports transparent blitting with a color key that identifies the replaceable bits of the destination surface for RGB colors.


##### - dwCKeyCaps.DDCKEYCAPS_DESTBLTCLRSPACE

Supports transparent blitting with a color space that identifies the replaceable bits of the destination surface for RGB colors.


##### - dwCKeyCaps.DDCKEYCAPS_DESTBLTCLRSPACEYUV

Supports transparent blitting with a color space that identifies the replaceable bits of the destination surface for YUV colors.


##### - dwCKeyCaps.DDCKEYCAPS_DESTBLTYUV

Supports transparent blitting with a color key that identifies the replaceable bits of the destination surface for YUV colors.


##### - dwCKeyCaps.DDCKEYCAPS_DESTOVERLAY

Supports overlaying with color keying of the replaceable bits of the destination surface to be overlaid for RGB colors.


##### - dwCKeyCaps.DDCKEYCAPS_DESTOVERLAYCLRSPACE

Supports a color space as the color key for the destination of RGB colors.


##### - dwCKeyCaps.DDCKEYCAPS_DESTOVERLAYCLRSPACEYUV

Supports a color space as the color key for the destination of YUV colors.


##### - dwCKeyCaps.DDCKEYCAPS_DESTOVERLAYONEACTIVE

Supports only one active destination color key value for visible overlay surfaces.


##### - dwCKeyCaps.DDCKEYCAPS_DESTOVERLAYYUV

Supports overlaying, using color keying of the replaceable bits of the destination surface to be overlaid for YUV colors.


##### - dwCKeyCaps.DDCKEYCAPS_NOCOSTOVERLAY

Indicates that there are no bandwidth trade-offs for using the color key with an overlay.


##### - dwCKeyCaps.DDCKEYCAPS_SRCBLT

Supports transparent blitting, using the color key for the source with this surface for RGB colors.


##### - dwCKeyCaps.DDCKEYCAPS_SRCBLTCLRSPACE

Supports transparent blitting, using a color space for the source with this surface for RGB colors.


##### - dwCKeyCaps.DDCKEYCAPS_SRCBLTCLRSPACEYUV

Supports transparent blitting, using a color space for the source with this surface for YUV colors.


##### - dwCKeyCaps.DDCKEYCAPS_SRCBLTYUV

Supports transparent blitting, using the color key for the source with this surface for YUV colors.


##### - dwCKeyCaps.DDCKEYCAPS_SRCOVERLAY

Supports overlaying, using the color key for the source with this overlay surface for RGB colors.


##### - dwCKeyCaps.DDCKEYCAPS_SRCOVERLAYCLRSPACE

Supports overlaying, using a color space as the source color key for the overlay surface for RGB colors.


##### - dwCKeyCaps.DDCKEYCAPS_SRCOVERLAYCLRSPACEYUV

Supports overlaying, using a color space as the source color key for the overlay surface for YUV colors.


##### - dwCKeyCaps.DDCKEYCAPS_SRCOVERLAYONEACTIVE

Supports only one active source color key value for visible overlay surfaces.


##### - dwCKeyCaps.DDCKEYCAPS_SRCOVERLAYYUV

Supports overlaying, using the color key for the source with this overlay surface for YUV colors.


##### - dwCaps.DDCAPS_3D

The display hardware has 3-D acceleration.


##### - dwCaps.DDCAPS_ALIGNBOUNDARYDEST

DirectDraw supports only those overlay destination rectangles with the x-axis aligned to the <b>dwAlignBoundaryDest</b> boundaries of the surface.


##### - dwCaps.DDCAPS_ALIGNBOUNDARYSRC

DirectDraw supports only those overlay source rectangles with the x-axis aligned to the <b>dwAlignBoundarySrc</b> boundaries of the surface.


##### - dwCaps.DDCAPS_ALIGNSIZEDEST

DirectDraw supports only those overlay destination rectangles whose x-axis sizes, in pixels, are <b>dwAlignSizeDest</b> multiples.


##### - dwCaps.DDCAPS_ALIGNSIZESRC

DirectDraw supports only those overlay source rectangles whose x-axis sizes, in pixels, are <b>dwAlignSizeSrc</b> multiples.


##### - dwCaps.DDCAPS_ALIGNSTRIDE

DirectDraw creates display memory surfaces that have a stride alignment equal to the <b>dwAlignStrideAlign</b> value.


##### - dwCaps.DDCAPS_ALPHA

The display hardware supports alpha-only surfaces.


##### - dwCaps.DDCAPS_BANKSWITCHED

The display hardware is bank-switched and is potentially very slow at random access to display memory.


##### - dwCaps.DDCAPS_BLT

Display hardware is capable of bit block transfer (bitblt) operations.


##### - dwCaps.DDCAPS_BLTCOLORFILL

Display hardware is capable of color filling with a blitter.


##### - dwCaps.DDCAPS_BLTDEPTHFILL

Display hardware is capable of depth filling z-buffers with a blitter.


##### - dwCaps.DDCAPS_BLTFOURCC

Display hardware is capable of color-space conversions during bitblt operations.


##### - dwCaps.DDCAPS_BLTQUEUE

Display hardware is capable of asynchronous bitblt operations.


##### - dwCaps.DDCAPS_BLTSTRETCH

Display hardware is capable of stretching during bitblt operations.


##### - dwCaps.DDCAPS_CANBLTSYSMEM

Display hardware is capable of blitting to or from system memory.


##### - dwCaps.DDCAPS_CANCLIP

Display hardware is capable of clipping with blitting.


##### - dwCaps.DDCAPS_CANCLIPSTRETCHED

Display hardware is capable of clipping while stretch blitting.


##### - dwCaps.DDCAPS_COLORKEY

Supports some form of color key in either overlay or bitblt operations. More specific color-key capability information can be found in the <b>dwCKeyCaps</b> member.


##### - dwCaps.DDCAPS_COLORKEYHWASSIST

The color key is partially hardware-assisted. This means that other resources (CPU or video memory) might be used. If this bit is not set, full hardware support is in place.


##### - dwCaps.DDCAPS_GDI

Display hardware is shared with GDI.


##### - dwCaps.DDCAPS_NOHARDWARE

There is no hardware support.


##### - dwCaps.DDCAPS_OVERLAY

Display hardware supports overlays.


##### - dwCaps.DDCAPS_OVERLAYCANTCLIP

Display hardware supports overlays but cannot clip them.


##### - dwCaps.DDCAPS_OVERLAYFOURCC

Overlay hardware is capable of color-space conversions during overlay operations.


##### - dwCaps.DDCAPS_OVERLAYSTRETCH

Overlay hardware is capable of stretching. The <b>dwMinOverlayStretch</b> and <b>dwMaxOverlayStretch</b> members contain valid data.


##### - dwCaps.DDCAPS_PALETTE

DirectDraw is capable of creating and supporting DirectDrawPalette objects for surfaces other than the primary surface.


##### - dwCaps.DDCAPS_PALETTEVSYNC

DirectDraw is capable of updating a palette synchronized with the vertical refresh.


##### - dwCaps.DDCAPS_READSCANLINE

Display hardware is capable of returning the current scan line.


##### - dwCaps.DDCAPS_VBI

Display hardware is capable of generating a vertical-blank interrupt.


##### - dwCaps.DDCAPS_ZBLTS

Supports the use of z-buffers with bitblt operations.


##### - dwCaps.DDCAPS_ZOVERLAYS

Supports the use of the <a href="https://docs.microsoft.com/windows/desktop/api/ddraw/nf-ddraw-idirectdrawsurface7-updateoverlayzorder">IDirectDrawSurface7::UpdateOverlayZOrder</a> method as a z-value for overlays to control their layering.


##### - dwCaps2.DDCAPS2_AUTOFLIPOVERLAY

The overlay can be automatically flipped to the next surface in the flipping chain each time that a video port VSYNC occurs, allowing the video port and the overlay to double-buffer the video without CPU overhead. This option is only valid when the surface is receiving data from a video port. If the video port data is noninterlaced or noninterleaved, it flips on every VSYNC. If the data is being interleaved in memory, it flips on every other VSYNC.


##### - dwCaps2.DDCAPS2_CANBOBHARDWARE

The overlay hardware can display each field of an interlaced video stream individually.


##### - dwCaps2.DDCAPS2_CANBOBINTERLEAVED

The overlay hardware can display each field of an interlaced video stream individually while it is interleaved in memory without causing any artifacts that might normally occur without special hardware support. This option is only valid when the surface is receiving data from a video port and the video is zoomed at least twice in the vertical direction.


##### - dwCaps2.DDCAPS2_CANBOBNONINTERLEAVED

The overlay hardware can display each field of an interlaced video stream individually while it is not interleaved in memory without causing any artifacts that might normally occur without special hardware support. This option is only valid when the surface is receiving data from a video port and the video is zoomed at least twice in the vertical direction.


##### - dwCaps2.DDCAPS2_CANCALIBRATEGAMMA

The system has a calibrator installed that can automatically adjust the gamma ramp so that the result is identical on all systems that have a calibrator. To invoke the calibrator when setting new gamma levels, use the DDSGR_CALIBRATE flag when calling the <a href="https://docs.microsoft.com/windows/desktop/api/ddraw/nf-ddraw-idirectdrawgammacontrol-setgammaramp">IDirectDrawGammaControl::SetGammaRamp</a> method. Calibrating gamma ramps incurs some processing overhead and should not be used frequently.


##### - dwCaps2.DDCAPS2_CANDROPZ16BIT

Sixteen-bit RGBZ values can be converted into 16-bit RGB values. (The system does not support 8-bit conversions.)


##### - dwCaps2.DDCAPS2_CANFLIPODDEVEN

The driver is capable of performing odd and even flip operations, as specified by the DDFLIP_ODD and DDFLIP_EVEN flags that are used with the <a href="https://docs.microsoft.com/windows/desktop/api/ddraw/nf-ddraw-idirectdrawsurface7-flip">IDirectDrawSurface7::Flip</a> method.


##### - dwCaps2.DDCAPS2_CANMANAGETEXTURE

The Direct3D texture manager uses this capability to decide whether to put managed surfaces in nonlocal video memory. If the capability is set, the texture manager puts managed surfaces in nonlocal video memory. Drivers that cannot texture from local video memory should not set this capability.


##### - dwCaps2.DDCAPS2_CANRENDERWINDOWED

The driver is capable of rendering in windowed mode.


##### - dwCaps2.DDCAPS2_CERTIFIED

Display hardware is certified.


##### - dwCaps2.DDCAPS2_COLORCONTROLOVERLAY

The overlay surface contains color controls (such as brightness and sharpness).


##### - dwCaps2.DDCAPS2_COLORCONTROLPRIMARY

The primary surface contains color controls (for instance, gamma).


##### - dwCaps2.DDCAPS2_COPYFOURCC

The driver supports blitting any FOURCC surface to another surface of the same FOURCC.


##### - dwCaps2.DDCAPS2_FLIPINTERVAL

The driver responds to the DDFLIP_INTERVAL* flags. (For more information about these flags, see <a href="https://docs.microsoft.com/windows/desktop/api/ddraw/nf-ddraw-idirectdrawsurface7-flip">IDirectDrawSurface7::Flip</a>). 



##### - dwCaps2.DDCAPS2_FLIPNOVSYNC

The driver responds to the DDFLIP_NOVSYNC flag (For more information about this flag, see <a href="https://docs.microsoft.com/windows/desktop/api/ddraw/nf-ddraw-idirectdrawsurface7-flip">IDirectDrawSurface7::Flip</a>).


##### - dwCaps2.DDCAPS2_NO2DDURING3DSCENE

Two-dimensional operations such as <a href="https://docs.microsoft.com/windows/desktop/api/ddraw/nf-ddraw-idirectdrawsurface7-blt">IDirectDrawSurface7::Blt</a> and <a href="https://docs.microsoft.com/windows/desktop/api/ddraw/nf-ddraw-idirectdrawsurface7-lock">IDirectDrawSurface7::Lock</a> cannot be performed on any surfaces that Direct3D is using between calls to the <a href="https://docs.microsoft.com/windows/desktop/api/d3d9/nf-d3d9-idirect3ddevice9-beginscene">BeginScene</a> and <a href="https://docs.microsoft.com/windows/desktop/api/d3d9/nf-d3d9-idirect3ddevice9-endscene">EndScene</a> methods.


##### - dwCaps2.DDCAPS2_NONLOCALVIDMEM

The display driver supports surfaces in nonlocal video memory.


##### - dwCaps2.DDCAPS2_NONLOCALVIDMEMCAPS

Bitblt capabilities for nonlocal video-memory surfaces differ from local video-memory surfaces. If this flag is present, the DDCAPS2_NONLOCALVIDMEM flag is also present.


##### - dwCaps2.DDCAPS2_NOPAGELOCKREQUIRED

DMA bitblt operations are supported on system-memory surfaces that are not page-locked.


##### - dwCaps2.DDCAPS2_PRIMARYGAMMA

Supports dynamic gamma ramps for the primary surface.


##### - dwCaps2.DDCAPS2_STEREO

New for DirectX 7.0. Turns on the <b>dwSVCaps</b> bit to support stereo mode. The driver can do stereo in at least one mode other than the current mode. The application can use <a href="https://docs.microsoft.com/windows/desktop/api/ddraw/nf-ddraw-idirectdraw7-getdisplaymode">IDirectDraw7::GetDisplayMode</a> or <a href="https://docs.microsoft.com/windows/desktop/api/ddraw/nf-ddraw-idirectdraw7-enumdisplaymodes">IDirectDraw7::EnumDisplayModes</a> to get per-mode stereo information.


##### - dwCaps2.DDCAPS2_TEXMANINNONLOCALVIDMEM

New for DirectX 7.0. The Direct3D texture manager uses this capability to decide whether to put managed surfaces in nonlocal video memory. If the capability is set, the texture manager puts managed surfaces in nonlocal video memory. Drivers that cannot texture from local video memory should not set this capability.


##### - dwCaps2.DDCAPS2_VIDEOPORT

Display hardware supports live video.


##### - dwCaps2.DDCAPS2_WIDESURFACES

The display surface supports surfaces wider than the primary surface.


##### - dwFXAlphaCaps.DDFXALPHACAPS_BLTALPHAEDGEBLEND

Supports alpha blending around the edge of a source color-keyed surface. Used for bitblt operations.


##### - dwFXAlphaCaps.DDFXALPHACAPS_BLTALPHAPIXELS

Supports alpha information in pixel format. The bit depth of alpha information in the pixel format can be 1, 2, 4, or 8. The alpha value becomes more opaque as the alpha value increases. Regardless of the depth of the alpha information, 0 is always the fully transparent value. Used for bitblt operations.


##### - dwFXAlphaCaps.DDFXALPHACAPS_BLTALPHAPIXELSNEG

Supports alpha information in pixel format. The bit depth of alpha information in the pixel format can be 1, 2, 4, or 8. The alpha value becomes more transparent as the alpha value increases. Regardless of the depth of the alpha information, 0 is always the fully opaque value. This flag can be used only if DDCAPS_ALPHA is set. Used for bitblt operations.


##### - dwFXAlphaCaps.DDFXALPHACAPS_BLTALPHASURFACES

Supports alpha-only surfaces. The bit depth of an alpha-only surface can be 1, 2, 4, or 8. The alpha value becomes more opaque as the alpha value increases. Regardless of the depth of the alpha information, 0 is always the fully transparent value. Used for bitblt operations.


##### - dwFXAlphaCaps.DDFXALPHACAPS_BLTALPHASURFACESNEG

Indicates that the alpha channel becomes more transparent as the alpha value increases. The depth of the alpha channel-data can be 1, 2, 4, or 8. Regardless of the depth of the alpha information, 0 is always the fully opaque value. This flag can be set only if DDCAPS_ALPHA has been set. Used for bitblt operations.


##### - dwFXAlphaCaps.DDFXALPHACAPS_OVERLAYALPHAEDGEBLEND

Supports alpha blending around the edge of a source color-keyed surface. Used for overlays.


##### - dwFXAlphaCaps.DDFXALPHACAPS_OVERLAYALPHAPIXELS

Supports alpha information in pixel format. The bit depth of alpha information in pixel format can be 1, 2, 4, or 8. The alpha value becomes more opaque as the alpha value increases. Regardless of the depth of the alpha information, 0 is always the fully transparent value. Used for overlays.


##### - dwFXAlphaCaps.DDFXALPHACAPS_OVERLAYALPHAPIXELSNEG

Supports alpha information in pixel format. The bit depth of alpha information in pixel format can be 1, 2, 4, or 8. The alpha value becomes more transparent as the alpha value increases. Regardless of the depth of the alpha information, 0 is always the fully opaque value. This flag can be used only if DDCAPS_ALPHA has been set. Used for overlays.


##### - dwFXAlphaCaps.DDFXALPHACAPS_OVERLAYALPHASURFACES

Supports alpha-only surfaces. The bit depth of an alpha-only surface can be 1, 2, 4, or 8. The alpha value becomes more opaque as the alpha value increases. Regardless of the depth of the alpha information, 0 is always the fully transparent value. Used for overlays.


##### - dwFXAlphaCaps.DDFXALPHACAPS_OVERLAYALPHASURFACESNEG

Indicates that the alpha channel becomes more transparent as the alpha value increases. The depth of the alpha-channel data can be 1, 2, 4, or 8. Regardless of the depth of the alpha information, 0 is always the fully opaque value. This flag can be used only if DDCAPS_ALPHA has been set. Used for overlays.


##### - dwFXCaps.DDFXCAPS_BLTALPHA

Supports alpha-blended bitblt operations.


##### - dwFXCaps.DDFXCAPS_BLTARITHSTRETCHY

Uses arithmetic operations, rather than pixel-doubling techniques, to stretch and shrink surfaces during a bitblt operation. Occurs along the y-axis (vertically).


##### - dwFXCaps.DDFXCAPS_BLTARITHSTRETCHYN

Uses arithmetic operations, rather than pixel-doubling techniques, to stretch and shrink surfaces during a bitblt operation. Occurs along the y-axis (vertically), and works only for integer stretching (×1, ×2, and so on).


##### - dwFXCaps.DDFXCAPS_BLTFILTER

Driver can do surface-reconstruction filtering for warped bitblts.


##### - dwFXCaps.DDFXCAPS_BLTMIRRORLEFTRIGHT

Supports mirroring left to right in a bitblt operation.


##### - dwFXCaps.DDFXCAPS_BLTMIRRORUPDOWN

Supports mirroring top to bottom in a bitblt operation.


##### - dwFXCaps.DDFXCAPS_BLTROTATION

Supports arbitrary rotation in a bitblt operation.


##### - dwFXCaps.DDFXCAPS_BLTROTATION90

Supports 90-degree rotations in a bitblt operation.


##### - dwFXCaps.DDFXCAPS_BLTSHRINKX

Supports arbitrary shrinking of a surface along the x-axis (horizontally). This flag is valid only for bitblt operations.


##### - dwFXCaps.DDFXCAPS_BLTSHRINKXN

Supports integer shrinking (×1, ×2, and so on) of a surface along the x-axis (horizontally). This flag is valid only for bitblt operations.


##### - dwFXCaps.DDFXCAPS_BLTSHRINKY

Supports arbitrary shrinking of a surface along the y-axis (vertically). This flag is valid only for bitblt operations.


##### - dwFXCaps.DDFXCAPS_BLTSHRINKYN

Supports integer shrinking (×1, ×2, and so on) of a surface along the y-axis (vertically). This flag is valid only for bitblt operations.


##### - dwFXCaps.DDFXCAPS_BLTSTRETCHX

Supports arbitrary stretching of a surface along the x-axis (horizontally). This flag is valid only for bitblt operations.


##### - dwFXCaps.DDFXCAPS_BLTSTRETCHXN

Supports integer stretching (×1, ×2, and so on) of a surface along the x-axis (horizontally). This flag is valid only for bitblt operations.


##### - dwFXCaps.DDFXCAPS_BLTSTRETCHY

Supports arbitrary stretching of a surface along the y-axis (vertically). This flag is valid only for bitblt operations.


##### - dwFXCaps.DDFXCAPS_BLTSTRETCHYN

Supports integer stretching (×1, ×2, and so on) of a surface along the y-axis (vertically). This flag is valid only for bitblt operations.


##### - dwFXCaps.DDFXCAPS_BLTTRANSFORM

Supports geometric transformations (or warps) for blitted sprites. Transformations are not currently supported for explicit bitblt operations.


##### - dwFXCaps.DDFXCAPS_OVERLAYALPHA

Supports alpha blending for overlay surfaces.


##### - dwFXCaps.DDFXCAPS_OVERLAYARITHSTRETCHY

Uses arithmetic operations, rather than pixel-doubling techniques, to stretch and shrink overlay surfaces. Occurs along the y-axis (vertically).


##### - dwFXCaps.DDFXCAPS_OVERLAYARITHSTRETCHYN

Uses arithmetic operations, rather than pixel-doubling techniques, to stretch and shrink overlay surfaces. Occurs along the y-axis (vertically), and works only for integer stretching (×1, ×2, and so on).


##### - dwFXCaps.DDFXCAPS_OVERLAYFILTER

Supports surface-reconstruction filtering for warped overlay sprites. Filtering is not currently supported for explicitly displayed overlay surfaces (those displayed with calls to <a href="https://docs.microsoft.com/windows/desktop/api/ddraw/nf-ddraw-idirectdrawsurface7-updateoverlay">IDirectDrawSurface7::UpdateOverlay</a>).


##### - dwFXCaps.DDFXCAPS_OVERLAYMIRRORLEFTRIGHT

Supports mirroring of overlays across the vertical axis.


##### - dwFXCaps.DDFXCAPS_OVERLAYMIRRORUPDOWN

Supports mirroring of overlays across the horizontal axis.


##### - dwFXCaps.DDFXCAPS_OVERLAYSHRINKX

Supports arbitrary shrinking of a surface along the x-axis (horizontally). This flag is valid only for DDSCAPS_OVERLAY surfaces. This flag indicates only the capabilities of a surface; it does not indicate that shrinking is available.


##### - dwFXCaps.DDFXCAPS_OVERLAYSHRINKXN

Supports integer shrinking (×1, ×2, and so on) of a surface along the x-axis (horizontally). This flag is valid only for DDSCAPS_OVERLAY surfaces. This flag indicates only the capabilities of a surface; it does not indicate that shrinking is available.


##### - dwFXCaps.DDFXCAPS_OVERLAYSHRINKY

Supports arbitrary shrinking of a surface along the y-axis (vertically). This flag is valid only for DDSCAPS_OVERLAY surfaces. This flag indicates only the capabilities of a surface; it does not indicate that shrinking is available.


##### - dwFXCaps.DDFXCAPS_OVERLAYSHRINKYN

Supports integer shrinking (×1, ×2, and so on) of a surface along the y-axis (vertically). This flag is valid only for DDSCAPS_OVERLAY surfaces. This flag indicates only the capabilities of a surface; it does not indicate that shrinking is available.


##### - dwFXCaps.DDFXCAPS_OVERLAYSTRETCHX

Supports arbitrary stretching of a surface along the x-axis (horizontally). This flag is valid only for DDSCAPS_OVERLAY surfaces. This flag indicates only the capabilities of a surface; it does not indicate that stretching is available.


##### - dwFXCaps.DDFXCAPS_OVERLAYSTRETCHXN

Supports integer stretching (×1, ×2, and so on) of a surface along the x-axis (horizontally). This flag is valid only for DDSCAPS_OVERLAY surfaces. This flag indicates only the capabilities of a surface; it does not indicate that stretching is available.


##### - dwFXCaps.DDFXCAPS_OVERLAYSTRETCHY

Supports arbitrary stretching of a surface along the y-axis (vertically). This flag is valid only for DDSCAPS_OVERLAY surfaces. This flag indicates only the capabilities of a surface; it does not indicate that stretching is available.


##### - dwFXCaps.DDFXCAPS_OVERLAYSTRETCHYN

Supports integer stretching (×1, ×2, and so on) of a surface along the y-axis (vertically). This flag is valid only for DDSCAPS_OVERLAY surfaces. This flag indicates only the capabilities of a surface; it does not indicate that stretching is available.


##### - dwFXCaps.DDFXCAPS_OVERLAYTRANSFORM

Supports geometric transformations (or warps) for overlay sprites. Transformations are not currently supported for explicitly displayed overlay surfaces (those displayed with calls to <a href="https://docs.microsoft.com/windows/desktop/api/ddraw/nf-ddraw-idirectdrawsurface7-updateoverlay">IDirectDrawSurface7::UpdateOverlay</a>).


##### - dwPalCaps.DDPCAPS_1BIT

Supports palettes that contain 1-bit color entries (two colors).


##### - dwPalCaps.DDPCAPS_2BIT

Supports palettes that contain 2-bit color entries (four colors).


##### - dwPalCaps.DDPCAPS_4BIT

Supports palettes that contain 4-bit color entries (16 colors).


##### - dwPalCaps.DDPCAPS_8BIT

Supports palettes that contain 8-bit color entries (256 colors).


##### - dwPalCaps.DDPCAPS_8BITENTRIES

Specifies an index to an 8-bit color index. This field is valid only when used with the DDPCAPS_1BIT, DDPCAPS_2BIT, or DDPCAPS_4BIT capability and when the target surface is 8 bits per pixel (bpp). Each color entry is 1 byte long and is an index to an 8-bpp palette on the destination surface.


##### - dwPalCaps.DDPCAPS_ALLOW256

Supports palettes that can have all 256 entries defined.


##### - dwPalCaps.DDPCAPS_ALPHA

Supports palettes that include an alpha component. For alpha-capable palettes, the <b>peFlags</b> member of each <a href="https://docs.microsoft.com/previous-versions/dd162769(v=vs.85)">PALETTEENTRY</a> structure that the palette contains is to be interpreted as a single 8-bit alpha value (in addition to the color data in the <b>peRed</b>, <b>peGreen</b>, and <b>peBlue</b> members). A palette created with this flag can be attached only to a texture surface.


##### - dwPalCaps.DDPCAPS_PRIMARYSURFACE

The palette is attached to the primary surface. Changing the palette has an immediate effect on the display unless the DDPCAPS_VSYNC capability is specified and supported.


##### - dwPalCaps.DDPCAPS_PRIMARYSURFACELEFT

The palette is attached to the primary surface on the left. Changing the palette has an immediate effect on the display unless the DDPCAPS_VSYNC capability is specified and supported.


##### - dwPalCaps.DDPCAPS_VSYNC

The palette can be modified synchronously with the monitor's refresh rate.


##### - dwSVCaps.DDSVCAPS_RESERVED1, DDSVCAPS_RESERVED2, DDSVCAPS_RESERVED3, DDSVCAPS_RESERVED4

Reserved flags.


##### - dwSVCaps.DDSVCAPS_STEREOSEQUENTIAL

New for DirectX 7.0. The driver can do stereo in at least one mode other than the current mode. The application can use <a href="https://docs.microsoft.com/windows/desktop/api/ddraw/nf-ddraw-idirectdraw7-getdisplaymode">IDirectDraw7::GetDisplayMode</a> or <a href="https://docs.microsoft.com/windows/desktop/api/ddraw/nf-ddraw-idirectdraw7-enumdisplaymodes">IDirectDraw7::EnumDisplayModes</a> to get per-mode stereo information.


## -remarks



For backward compatibility, the Ddraw.h header file contains multiple definitions of the DDCAPS structure. The version that passes the preprocessor is determined by the value of the DIRECTDRAW_VERSION constant.



