---
UID: NF:devicetopology.IControlChangeNotify.OnNotify
title: IControlChangeNotify::OnNotify (devicetopology.h)
description: The OnNotify method notifies the client when the status of a connector or subunit changes.
old-location: coreaudio\icontrolchangenotify_onnotify.htm
tech.root: CoreAudio
ms.assetid: a2f32cb9-3c8b-4b44-96a2-dd70afcca71a
ms.date: 12/05/2018
ms.keywords: IControlChangeNotify interface [Core Audio],OnNotify method, IControlChangeNotify.OnNotify, IControlChangeNotify::OnNotify, IControlChangeNotifyOnNotify, OnNotify, OnNotify method [Core Audio], OnNotify method [Core Audio],IControlChangeNotify interface, coreaudio.icontrolchangenotify_onnotify, devicetopology/IControlChangeNotify::OnNotify
f1_keywords:
- devicetopology/IControlChangeNotify.OnNotify
dev_langs:
- c++
req.header: devicetopology.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Devicetopology.h
api_name:
- IControlChangeNotify.OnNotify
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IControlChangeNotify::OnNotify


## -description



The <b>OnNotify</b> method notifies the client when the status of a connector or subunit changes.




## -parameters




### -param dwSenderProcessId [in]

The process ID of the client that changed the state of the control. If a notification is generated by a hardware event, this process ID will differ from the client's process ID. For more information, see Remarks.
          


### -param pguidEventContext [in]

A pointer to the context GUID for the control-change event. The client that initiates the control change supplies this GUID. For more information, see Remarks.
          


## -returns



If the method succeeds, it returns S_OK. If it fails, it returns an error code.
          




## -remarks



A client can use this method to keep track of control changes made by other processes and by the hardware. However, a client that changes a control setting can typically disregard the notification that the control change generates. In its implementation of the <b>OnNotify</b> method, a client can inspect the <i>dwSenderProcessId</i> and <i>pguidEventContext</i> parameters to discover whether it or another client is the source of the control-change event.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/devicetopology/nn-devicetopology-icontrolchangenotify">IControlChangeNotify Interface</a>
 

 

