---
UID: NN:devicetopology.IAudioChannelConfig
title: IAudioChannelConfig (devicetopology.h)
description: The IAudioChannelConfig interface provides access to a hardware channel-configuration control.
old-location: coreaudio\iaudiochannelconfig.htm
tech.root: CoreAudio
ms.assetid: b8e54e9e-a6eb-46e6-a71c-ff498c7e8f47
ms.date: 12/05/2018
ms.keywords: IAudioChannelConfig, IAudioChannelConfig interface [Core Audio], IAudioChannelConfig interface [Core Audio],described, coreaudio.iaudiochannelconfig, devicetopology/IAudioChannelConfig
f1_keywords:
- devicetopology/IAudioChannelConfig
dev_langs:
- c++
req.header: devicetopology.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Devicetopology.h
api_name:
- IAudioChannelConfig
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IAudioChannelConfig interface


## -description



The <b>IAudioChannelConfig</b> interface provides access to a hardware channel-configuration control. The client obtains a reference to the <b>IAudioChannelConfig</b> interface of a subunit by calling the <a href="https://docs.microsoft.com/windows/desktop/api/devicetopology/nf-devicetopology-ipart-activate">IPart::Activate</a> method with parameter <i>refiid</i> set to REFIID IID_IAudioChannelConfig. The call to IPart::Activate succeeds only if the subunit supports the <b>IAudioChannelConfig</b> interface. Only a subunit object that represents a hardware channel-configuration control will support this interface.

A client of the <b>IAudioChannelConfig</b> interface programs a hardware channel-configuration control by writing a channel-configuration mask to the control. The mask specifies the assignment of audio channels to speakers. For more information about channel-configuration masks, see the following:

<ul>
<li>The discussion of the KSPROPERTY_AUDIO_CHANNEL_CONFIG property in the Windows DDK documentation.</li>
<li>The white paper titled "Audio Driver Support for Home Theater Speaker Configurations" at the <a href="http://go.microsoft.com/fwlink/p/?linkid=62989">Audio Device Technologies for Windows</a> website.</li>
</ul>
Most Windows audio adapter drivers support the Windows Driver Model (WDM) and use kernel-streaming (KS) properties to represent the hardware control parameters in subunits (referred to as KS nodes). The <b>IAudioChannelConfig</b> interface provides convenient access to the KSPROPERTY_AUDIO_CHANNEL_CONFIG property of a subunit that has a subtype GUID value of KSNODETYPE_3D_EFFECTS, KSNODETYPE_DAC, KSNODETYPE_VOLUME, or KSNODETYPE_PROLOGIC_DECODER. To obtain the subtype GUID of a subunit, call the <a href="https://docs.microsoft.com/windows/desktop/api/devicetopology/nf-devicetopology-ipart-getsubtype">IPart::GetSubType</a> method. For more information about KS properties and KS node types, see the Windows DDK documentation.




## -inheritance

The <b xmlns:loc="http://microsoft.com/wdcml/l10n">IAudioChannelConfig</b> interface inherits from the <a href="https://docs.microsoft.com/windows/desktop/api/unknwn/nn-unknwn-iunknown">IUnknown</a> interface. <b>IAudioChannelConfig</b> also has these types of members:
<ul>
<li><a href="https://docs.microsoft.com/">Methods</a></li>
</ul>

## -members

The <b>IAudioChannelConfig</b> interface has these methods.
<table class="members" id="memberListMethods">
<tr>
<th align="left" width="37%">Method</th>
<th align="left" width="63%">Description</th>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/devicetopology/nf-devicetopology-iaudiochannelconfig-getchannelconfig">GetChannelConfig</a>
</td>
<td align="left" width="63%">
Gets the current channel-configuration mask from a channel-configuration control.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/devicetopology/nf-devicetopology-iaudiochannelconfig-setchannelconfig">SetChannelConfig</a>
</td>
<td align="left" width="63%">
Sets the channel-configuration mask in a channel-configuration control.

</td>
</tr>
</table> 


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/CoreAudio/core-audio-interfaces">Core Audio Interfaces</a>



<a href="https://docs.microsoft.com/windows/desktop/CoreAudio/devicetopology-api">DeviceTopology API</a>



<a href="https://docs.microsoft.com/windows/desktop/api/devicetopology/nf-devicetopology-ipart-activate">IPart::Activate</a>
 

 

