---
UID: NE:directml.DML_OPERATOR_TYPE
title: DML_OPERATOR_TYPE
description: Defines the type of an operator description.
old-location: direct3d12\dml_operator_type.htm
tech.root: direct3d12
ms.assetid: 2D66A3DB-FE61-4EC2-B626-DD008FF14802
ms.date: 12/5/2018
ms.keywords: DML_OPERATOR_ACTIVATION_ELU, DML_OPERATOR_ACTIVATION_HARDMAX, DML_OPERATOR_ACTIVATION_HARD_SIGMOID, DML_OPERATOR_ACTIVATION_IDENTITY, DML_OPERATOR_ACTIVATION_LEAKY_RELU, DML_OPERATOR_ACTIVATION_LINEAR, DML_OPERATOR_ACTIVATION_LOG_SOFTMAX, DML_OPERATOR_ACTIVATION_PARAMETERIZED_RELU, DML_OPERATOR_ACTIVATION_PARAMETRIC_SOFTPLUS, DML_OPERATOR_ACTIVATION_RELU, DML_OPERATOR_ACTIVATION_SCALED_ELU, DML_OPERATOR_ACTIVATION_SCALED_TANH, DML_OPERATOR_ACTIVATION_SIGMOID, DML_OPERATOR_ACTIVATION_SOFTMAX, DML_OPERATOR_ACTIVATION_SOFTPLUS, DML_OPERATOR_ACTIVATION_SOFTSIGN, DML_OPERATOR_ACTIVATION_TANH, DML_OPERATOR_ACTIVATION_THRESHOLDED_RELU, DML_OPERATOR_AVERAGE_POOLING, DML_OPERATOR_BATCH_NORMALIZATION, DML_OPERATOR_CAST, DML_OPERATOR_CONVOLUTION, DML_OPERATOR_DEPTH_TO_SPACE, DML_OPERATOR_ELEMENT_WISE_ABS, DML_OPERATOR_ELEMENT_WISE_ACOS, DML_OPERATOR_ELEMENT_WISE_ADD, DML_OPERATOR_ELEMENT_WISE_ASIN, DML_OPERATOR_ELEMENT_WISE_ATAN, DML_OPERATOR_ELEMENT_WISE_CEIL, DML_OPERATOR_ELEMENT_WISE_CLIP, DML_OPERATOR_ELEMENT_WISE_CONSTANT_POW, DML_OPERATOR_ELEMENT_WISE_COS, DML_OPERATOR_ELEMENT_WISE_DEQUANTIZE_LINEAR, DML_OPERATOR_ELEMENT_WISE_DIVIDE, DML_OPERATOR_ELEMENT_WISE_EXP, DML_OPERATOR_ELEMENT_WISE_FLOOR, DML_OPERATOR_ELEMENT_WISE_IDENTITY, DML_OPERATOR_ELEMENT_WISE_LOG, DML_OPERATOR_ELEMENT_WISE_LOGICAL_AND, DML_OPERATOR_ELEMENT_WISE_LOGICAL_EQUALS, DML_OPERATOR_ELEMENT_WISE_LOGICAL_GREATER_THAN, DML_OPERATOR_ELEMENT_WISE_LOGICAL_LESS_THAN, DML_OPERATOR_ELEMENT_WISE_LOGICAL_NOT, DML_OPERATOR_ELEMENT_WISE_LOGICAL_OR, DML_OPERATOR_ELEMENT_WISE_LOGICAL_XOR, DML_OPERATOR_ELEMENT_WISE_MAX, DML_OPERATOR_ELEMENT_WISE_MEAN, DML_OPERATOR_ELEMENT_WISE_MIN, DML_OPERATOR_ELEMENT_WISE_MULTIPLY, DML_OPERATOR_ELEMENT_WISE_POW, DML_OPERATOR_ELEMENT_WISE_QUANTIZE_LINEAR, DML_OPERATOR_ELEMENT_WISE_RECIP, DML_OPERATOR_ELEMENT_WISE_SIN, DML_OPERATOR_ELEMENT_WISE_SQRT, DML_OPERATOR_ELEMENT_WISE_SUBTRACT, DML_OPERATOR_ELEMENT_WISE_TAN, DML_OPERATOR_ELEMENT_WISE_THRESHOLD, DML_OPERATOR_GATHER, DML_OPERATOR_GEMM, DML_OPERATOR_GRU, DML_OPERATOR_INVALID, DML_OPERATOR_JOIN, DML_OPERATOR_LOCAL_RESPONSE_NORMALIZATION, DML_OPERATOR_LP_NORMALIZATION, DML_OPERATOR_LP_POOLING, DML_OPERATOR_LSTM, DML_OPERATOR_MAX_POOLING, DML_OPERATOR_MEAN_VARIANCE_NORMALIZATION, DML_OPERATOR_PADDING, DML_OPERATOR_REDUCE, DML_OPERATOR_RNN, DML_OPERATOR_ROI_POOLING, DML_OPERATOR_SLICE, DML_OPERATOR_SPACE_TO_DEPTH, DML_OPERATOR_SPLIT, DML_OPERATOR_TILE, DML_OPERATOR_TOP_K, DML_OPERATOR_TYPE, DML_OPERATOR_TYPE enumeration, DML_OPERATOR_UPSAMPLE_2D, DML_OPERATOR_VALUE_SCALE_2D, direct3d12.dml_operator_type, directml/DML_OPERATOR_ACTIVATION_ELU, directml/DML_OPERATOR_ACTIVATION_HARDMAX, directml/DML_OPERATOR_ACTIVATION_HARD_SIGMOID, directml/DML_OPERATOR_ACTIVATION_IDENTITY, directml/DML_OPERATOR_ACTIVATION_LEAKY_RELU, directml/DML_OPERATOR_ACTIVATION_LINEAR, directml/DML_OPERATOR_ACTIVATION_LOG_SOFTMAX, directml/DML_OPERATOR_ACTIVATION_PARAMETERIZED_RELU, directml/DML_OPERATOR_ACTIVATION_PARAMETRIC_SOFTPLUS, directml/DML_OPERATOR_ACTIVATION_RELU, directml/DML_OPERATOR_ACTIVATION_SCALED_ELU, directml/DML_OPERATOR_ACTIVATION_SCALED_TANH, directml/DML_OPERATOR_ACTIVATION_SIGMOID, directml/DML_OPERATOR_ACTIVATION_SOFTMAX, directml/DML_OPERATOR_ACTIVATION_SOFTPLUS, directml/DML_OPERATOR_ACTIVATION_SOFTSIGN, directml/DML_OPERATOR_ACTIVATION_TANH, directml/DML_OPERATOR_ACTIVATION_THRESHOLDED_RELU, directml/DML_OPERATOR_AVERAGE_POOLING, directml/DML_OPERATOR_BATCH_NORMALIZATION, directml/DML_OPERATOR_CAST, directml/DML_OPERATOR_CONVOLUTION, directml/DML_OPERATOR_DEPTH_TO_SPACE, directml/DML_OPERATOR_ELEMENT_WISE_ABS, directml/DML_OPERATOR_ELEMENT_WISE_ACOS, directml/DML_OPERATOR_ELEMENT_WISE_ADD, directml/DML_OPERATOR_ELEMENT_WISE_ASIN, directml/DML_OPERATOR_ELEMENT_WISE_ATAN, directml/DML_OPERATOR_ELEMENT_WISE_CEIL, directml/DML_OPERATOR_ELEMENT_WISE_CLIP, directml/DML_OPERATOR_ELEMENT_WISE_CONSTANT_POW, directml/DML_OPERATOR_ELEMENT_WISE_COS, directml/DML_OPERATOR_ELEMENT_WISE_DEQUANTIZE_LINEAR, directml/DML_OPERATOR_ELEMENT_WISE_DIVIDE, directml/DML_OPERATOR_ELEMENT_WISE_EXP, directml/DML_OPERATOR_ELEMENT_WISE_FLOOR, directml/DML_OPERATOR_ELEMENT_WISE_IDENTITY, directml/DML_OPERATOR_ELEMENT_WISE_LOG, directml/DML_OPERATOR_ELEMENT_WISE_LOGICAL_AND, directml/DML_OPERATOR_ELEMENT_WISE_LOGICAL_EQUALS, directml/DML_OPERATOR_ELEMENT_WISE_LOGICAL_GREATER_THAN, directml/DML_OPERATOR_ELEMENT_WISE_LOGICAL_LESS_THAN, directml/DML_OPERATOR_ELEMENT_WISE_LOGICAL_NOT, directml/DML_OPERATOR_ELEMENT_WISE_LOGICAL_OR, directml/DML_OPERATOR_ELEMENT_WISE_LOGICAL_XOR, directml/DML_OPERATOR_ELEMENT_WISE_MAX, directml/DML_OPERATOR_ELEMENT_WISE_MEAN, directml/DML_OPERATOR_ELEMENT_WISE_MIN, directml/DML_OPERATOR_ELEMENT_WISE_MULTIPLY, directml/DML_OPERATOR_ELEMENT_WISE_POW, directml/DML_OPERATOR_ELEMENT_WISE_QUANTIZE_LINEAR, directml/DML_OPERATOR_ELEMENT_WISE_RECIP, directml/DML_OPERATOR_ELEMENT_WISE_SIN, directml/DML_OPERATOR_ELEMENT_WISE_SQRT, directml/DML_OPERATOR_ELEMENT_WISE_SUBTRACT, directml/DML_OPERATOR_ELEMENT_WISE_TAN, directml/DML_OPERATOR_ELEMENT_WISE_THRESHOLD, directml/DML_OPERATOR_GATHER, directml/DML_OPERATOR_GEMM, directml/DML_OPERATOR_GRU, directml/DML_OPERATOR_INVALID, directml/DML_OPERATOR_JOIN, directml/DML_OPERATOR_LOCAL_RESPONSE_NORMALIZATION, directml/DML_OPERATOR_LP_NORMALIZATION, directml/DML_OPERATOR_LP_POOLING, directml/DML_OPERATOR_LSTM, directml/DML_OPERATOR_MAX_POOLING, directml/DML_OPERATOR_MEAN_VARIANCE_NORMALIZATION, directml/DML_OPERATOR_PADDING, directml/DML_OPERATOR_REDUCE, directml/DML_OPERATOR_RNN, directml/DML_OPERATOR_ROI_POOLING, directml/DML_OPERATOR_SLICE, directml/DML_OPERATOR_SPACE_TO_DEPTH, directml/DML_OPERATOR_SPLIT, directml/DML_OPERATOR_TILE, directml/DML_OPERATOR_TOP_K, directml/DML_OPERATOR_TYPE, directml/DML_OPERATOR_UPSAMPLE_2D, directml/DML_OPERATOR_VALUE_SCALE_2D
f1_keywords:
- directml/DML_OPERATOR_TYPE
dev_langs:
- c++
req.header: directml.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- DirectML.h
api_name:
- DML_OPERATOR_TYPE
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# DML_OPERATOR_TYPE enumeration

## -description

Defines the type of an operator description.

See [DML_OPERATOR_DESC](/windows/win32/api/directml/ns-directml-dml_operator_desc) for the usage of this enumeration.

## -enum-fields

### -field DML_OPERATOR_INVALID

Indicates an unknown operator type, and is never valid. Using this value results in an error.

### -field DML_OPERATOR_ELEMENT_WISE_IDENTITY

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_identity_operator_desc">DML_ELEMENT_WISE_IDENTITY_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_ABS

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_abs_operator_desc">DML_ELEMENT_WISE_ABS_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_ACOS

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_acos_operator_desc">DML_ELEMENT_WISE_ACOS_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_ADD

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_add_operator_desc">DML_ELEMENT_WISE_ADD_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_ASIN

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_asin_operator_desc">DML_ELEMENT_WISE_ASIN_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_ATAN

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_atan_operator_desc">DML_ELEMENT_WISE_ATAN_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_CEIL

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_ceil_operator_desc">DML_ELEMENT_WISE_CEIL_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_CLIP

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_clip_operator_desc">DML_ELEMENT_WISE_CLIP_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_COS

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_cos_operator_desc">DML_ELEMENT_WISE_COS_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_DIVIDE

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_divide_operator_desc">DML_ELEMENT_WISE_DIVIDE_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_EXP

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_exp_operator_desc">DML_ELEMENT_WISE_EXP_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_FLOOR

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_floor_operator_desc">DML_ELEMENT_WISE_FLOOR_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_LOG

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_log_operator_desc">DML_ELEMENT_WISE_LOG_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_LOGICAL_AND

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_logical_and_operator_desc">DML_ELEMENT_WISE_LOGICAL_AND_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_LOGICAL_EQUALS

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_logical_equals_operator_desc">DML_ELEMENT_WISE_LOGICAL_EQUALS_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_LOGICAL_GREATER_THAN

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_logical_greater_than_operator_desc">DML_ELEMENT_WISE_LOGICAL_GREATER_THAN_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_LOGICAL_LESS_THAN

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_logical_less_than_operator_desc">DML_ELEMENT_WISE_LOGICAL_LESS_THAN_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_LOGICAL_NOT

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_logical_not_operator_desc">DML_ELEMENT_WISE_LOGICAL_NOT_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_LOGICAL_OR

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_logical_or_operator_desc">DML_ELEMENT_WISE_LOGICAL_OR_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_LOGICAL_XOR

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_logical_xor_operator_desc">DML_ELEMENT_WISE_LOGICAL_XOR_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_MAX

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_max_operator_desc">DML_ELEMENT_WISE_MAX_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_MEAN

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_mean_operator_desc">DML_ELEMENT_WISE_MEAN_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_MIN

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_min_operator_desc">DML_ELEMENT_WISE_MIN_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_MULTIPLY

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_multiply_operator_desc">DML_ELEMENT_WISE_MULTIPLY_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_POW

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_pow_operator_desc">DML_ELEMENT_WISE_POW_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_CONSTANT_POW

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_constant_pow_operator_desc">DML_ELEMENT_WISE_CONSTANT_POW_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_RECIP

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_recip_operator_desc">DML_ELEMENT_WISE_RECIP_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_SIN

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_sin_operator_desc">DML_ELEMENT_WISE_SIN_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_SQRT

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_sqrt_operator_desc">DML_ELEMENT_WISE_SQRT_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_SUBTRACT

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_subtract_operator_desc">DML_ELEMENT_WISE_SUBTRACT_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_TAN

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_tan_operator_desc">DML_ELEMENT_WISE_TAN_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_THRESHOLD

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_threshold_operator_desc">DML_ELEMENT_WISE_THRESHOLD_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_QUANTIZE_LINEAR

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_quantize_linear_operator_desc">DML_ELEMENT_WISE_QUANTIZE_LINEAR_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ELEMENT_WISE_DEQUANTIZE_LINEAR

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_element_wise_dequantize_linear_operator_desc">DML_ELEMENT_WISE_DEQUANTIZE_LINEAR_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ACTIVATION_ELU

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_activation_elu_operator_desc">DML_ACTIVATION_ELU_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ACTIVATION_HARDMAX

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_activation_hardmax_operator_desc">DML_ACTIVATION_HARDMAX_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ACTIVATION_HARD_SIGMOID

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_activation_hard_sigmoid_operator_desc">DML_ACTIVATION_HARD_SIGMOID_OPERATOR_DESC</a> structure.


### -field DML_OPERATOR_ACTIVATION_IDENTITY

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_activation_identity_operator_desc">DML_ACTIVATION_IDENTITY_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ACTIVATION_LEAKY_RELU

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_activation_leaky_relu_operator_desc">DML_ACTIVATION_LEAKY_RELU_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ACTIVATION_LINEAR

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_activation_linear_operator_desc">DML_ACTIVATION_LINEAR_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ACTIVATION_LOG_SOFTMAX

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_activation_log_softmax_operator_desc">DML_ACTIVATION_LOG_SOFTMAX_OPERATOR_DESC</a> structure.


### -field DML_OPERATOR_ACTIVATION_PARAMETERIZED_RELU

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_activation_parameterized_relu_operator_desc">DML_ACTIVATION_PARAMETERIZED_RELU_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ACTIVATION_PARAMETRIC_SOFTPLUS

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_activation_parametric_softplus_operator_desc">DML_ACTIVATION_PARAMETRIC_SOFTPLUS_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ACTIVATION_RELU

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_activation_relu_operator_desc">DML_ACTIVATION_RELU_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ACTIVATION_SCALED_ELU

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_activation_scaled_elu_operator_desc">DML_ACTIVATION_SCALED_ELU_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ACTIVATION_SCALED_TANH

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_activation_scaled_tanh_operator_desc">DML_ACTIVATION_SCALED_TANH_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ACTIVATION_SIGMOID

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_activation_sigmoid_operator_desc">DML_ACTIVATION_SIGMOID_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ACTIVATION_SOFTMAX

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_activation_softmax_operator_desc">DML_ACTIVATION_SOFTMAX_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ACTIVATION_SOFTPLUS

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_activation_softplus_operator_desc">DML_ACTIVATION_SOFTPLUS_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ACTIVATION_SOFTSIGN

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_activation_softsign_operator_desc">DML_ACTIVATION_SOFTSIGN_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ACTIVATION_TANH

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_activation_tanh_operator_desc">DML_ACTIVATION_TANH_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ACTIVATION_THRESHOLDED_RELU

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_activation_thresholded_relu_operator_desc">DML_ACTIVATION_THRESHOLDED_RELU_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_CONVOLUTION

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_convolution_operator_desc">DML_CONVOLUTION_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_GEMM

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_gemm_operator_desc">DML_GEMM_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_REDUCE

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_reduce_operator_desc">DML_REDUCE_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_AVERAGE_POOLING

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_average_pooling_operator_desc">DML_AVERAGE_POOLING_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_LP_POOLING

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_lp_pooling_operator_desc">DML_LP_POOLING_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_MAX_POOLING

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_max_pooling_operator_desc">DML_MAX_POOLING_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_ROI_POOLING

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_roi_pooling_operator_desc">DML_ROI_POOLING_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_SLICE

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_slice_operator_desc">DML_SLICE_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_CAST

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_cast_operator_desc">DML_CAST_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_SPLIT

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_split_operator_desc">DML_SPLIT_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_JOIN

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_join_operator_desc">DML_JOIN_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_PADDING

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_padding_operator_desc">DML_PADDING_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_VALUE_SCALE_2D

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_value_scale_2d_operator_desc">DML_VALUE_SCALE_2D_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_UPSAMPLE_2D

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_upsample_2d_operator_desc">DML_UPSAMPLE_2D_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_GATHER

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_gather_operator_desc">DML_GATHER_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_SPACE_TO_DEPTH

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_space_to_depth_operator_desc">DML_SPACE_TO_DEPTH_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_DEPTH_TO_SPACE

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_depth_to_space_operator_desc">DML_DEPTH_TO_SPACE_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_TILE

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_tile_operator_desc">DML_TILE_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_TOP_K

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_top_k_operator_desc">DML_TOP_K_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_BATCH_NORMALIZATION

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_batch_normalization_operator_desc">DML_BATCH_NORMALIZATION_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_MEAN_VARIANCE_NORMALIZATION

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_mean_variance_normalization_operator_desc">DML_MEAN_VARIANCE_NORMALIZATION_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_LOCAL_RESPONSE_NORMALIZATION

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_local_response_normalization_operator_desc">DML_LOCAL_RESPONSE_NORMALIZATION_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_LP_NORMALIZATION

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_lp_normalization_operator_desc">DML_LP_NORMALIZATION_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_RNN

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_rnn_operator_desc">DML_RNN_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_LSTM

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_lstm_operator_desc">DML_LSTM_OPERATOR_DESC</a> structure.

### -field DML_OPERATOR_GRU

Indicates the operator described by the <a href="/windows/win32/api/directml/ns-directml-dml_gru_operator_desc">DML_GRU_OPERATOR_DESC</a> structure.
