---
UID: NS:directml.DML_GATHER_OPERATOR_DESC
title: DML_GATHER_OPERATOR_DESC
description: Describes a DirectML data reorganization operator which, when given a data tensor of rank r &gt;= 1, and an indices tensor of rank q, gathers the entries in the axis dimension of the data (by default, the outermost one is axis == 0) indexed by indices, and concatenates them in an output tensor of rank q + (r - 1).
old-location: direct3d12\dml_gather_operator_desc.htm
tech.root: direct3d12
ms.assetid: 53F01BDE-30FF-4E15-BA1A-8D522B9DE8AF
ms.date: 12/5/2018
ms.keywords: DML_GATHER_OPERATOR_DESC, DML_GATHER_OPERATOR_DESC structure, direct3d12.dml_gather_operator_desc, directml/DML_GATHER_OPERATOR_DESC
f1_keywords:
- directml/DML_GATHER_OPERATOR_DESC
dev_langs:
- c++
req.header: directml.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- DirectML.h
api_name:
- DML_GATHER_OPERATOR_DESC
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# DML_GATHER_OPERATOR_DESC structure


## -description






Describes a DirectML data reorganization operator which, when given a data tensor of rank r &gt;= 1, and an indices tensor of rank q, gathers the entries in the axis dimension of the data (by default, the outermost one is axis == 0) indexed by indices, and concatenates them in an output tensor of rank q + (r - 1).


## -struct-fields




### -field InputTensor

Type: **const [DML_TENSOR_DESC](/windows/desktop/api/directml/ns-directml-dml_tensor_desc)\***

A pointer to a constant [DML_TENSOR_DESC](/windows/desktop/api/directml/ns-directml-dml_tensor_desc) containing the description of the tensor to read from.


### -field IndicesTensor

Type: **const [DML_TENSOR_DESC](/windows/desktop/api/directml/ns-directml-dml_tensor_desc)\***

A pointer to a constant [DML_TENSOR_DESC](/windows/desktop/api/directml/ns-directml-dml_tensor_desc) containing the indices.


### -field OutputTensor

Type: **const [DML_TENSOR_DESC](/windows/desktop/api/directml/ns-directml-dml_tensor_desc)\***

A pointer to a constant [DML_TENSOR_DESC](/windows/desktop/api/directml/ns-directml-dml_tensor_desc) containing the description of the tensor to write the results to.


### -field Axis

Type: [**UINT**](/windows/desktop/winprog/windows-data-types)

The axis dimension of the input tensor to gather on.


### -field IndexDimensions

Type: [**UINT**](/windows/desktop/winprog/windows-data-types)

The number of index dimensions.

