---
UID: NE:directxcollision.ContainmentType
title: ContainmentType
description: Indicates whether an object contains another object.
old-location: dxmath\containmenttype.htm
tech.root: dxmath
ms.assetid: T:Microsoft.directx_sdk.directxcollision.ContainmentType
ms.date: 12/05/2018
ms.keywords: CONTAINS, ContainmentType, ContainmentType enumeration [DirectX Math Support APIs], DISJOINT, INTERSECTS, directxcollision/CONTAINS, directxcollision/ContainmentType, directxcollision/DISJOINT, directxcollision/INTERSECTS, dxmath.containmenttype
f1_keywords:
- directxcollision/ContainmentType
dev_langs:
- c++
req.header: directxcollision.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- DirectXCollision.h
api_name:
- ContainmentType
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# ContainmentType enumeration


## -description


Indicates whether an object contains another object.


## -enum-fields




### -field DISJOINT

The object does not contain the specified object.


### -field INTERSECTS

The objects intersect.


### -field CONTAINS

The object contains the specified object.


## -remarks



<b>Namespace</b>:  Use DirectX

<h3><a id="Platform_Requirements"></a><a id="platform_requirements"></a><a id="PLATFORM_REQUIREMENTS"></a>Platform Requirements</h3>
Microsoft Visual Studio 2010 or Microsoft Visual Studio 2012 with the Windows SDK for Windows 8. Supported for Win32 desktop apps, Windows Store apps, and Windows Phone 8 apps.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/dxmath/ovw-xnamath-reference-enums">DirectXMath Enumerations</a>



<b>Reference</b>
 

 

