---
UID: NF:directxmath.XMConvertToRadians
title: XMConvertToRadians function (directxmath.h)
description: Converts an angle measured in degrees into one measured in radians.
old-location: dxmath\xmconverttoradians.htm
tech.root: dxmath
ms.assetid: M:Microsoft.directx_sdk.conversion.XMConvertToRadians(float)
ms.date: 12/05/2018
ms.keywords: Use DirectX..XMConvertToRadians, XMConvertToRadians, XMConvertToRadians method [DirectX Math Support APIs], dxmath.xmconverttoradians
f1_keywords:
- directxmath/XMConvertToRadians
dev_langs:
- c++
req.header: directxmath.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: Use DirectX.
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- DirectXMath.h
api_name:
- XMConvertToRadians
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# XMConvertToRadians function


## -description


Converts an angle measured in degrees into one measured in radians.


## -parameters




### -param fDegrees [in]

Size of an angle in degrees.


## -returns



Size of the angle in radians.




## -remarks



<h3><a id="Platform_Requirements"></a><a id="platform_requirements"></a><a id="PLATFORM_REQUIREMENTS"></a>Platform Requirements</h3>
Microsoft Visual Studio 2010 or Microsoft Visual Studio 2012 with the Windows SDK for Windows 8. Supported for Win32 desktop apps, Windows Store apps, and Windows Phone 8 apps.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/dxmath/ovw-xnamath-reference-functions-conversion">DirectXMath Library Conversion Functions</a>



<a href="https://docs.microsoft.com/en-us/windows/desktop/api/directxmath/nf-directxmath-xmconverttodegrees">XMConvertToDegrees</a>
 

 

