---
UID: NF:directxmath.XMFLOAT2.operator-assign
title: XMFLOAT2::operator-assign
description: Assigns the vector component data from one instance of XMFLOAT2 to the current instance of XMFLOAT2.
old-location: dxmath\xmfloat2_operator_eq.htm
tech.root: dxmath
ms.assetid: M:Microsoft.directx_sdk.reference.XMFLOAT2.operator = (const XMFLOAT2)
ms.date: 05/13/2019
ms.keywords: Use DirectX..XMFLOAT2.operator =, Use DirectX::::XMFLOAT2::operator =, XMFLOAT2 structure [DirectX Math Support APIs],operator = method, XMFLOAT2.operator =, XMFLOAT2.operator-assign, XMFLOAT2.operator=, XMFLOAT2::operator-assign, XMFLOAT2::operator=, dxmath.xmfloat2_operator_eq, operator = method [DirectX Math Support APIs], operator = method [DirectX Math Support APIs],XMFLOAT2 structure, operator=
f1_keywords:
- directxmath/XMFLOAT2.operator =
dev_langs:
- c++
req.header: directxmath.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: Use DirectX.
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- DirectXMath.h
api_name:
- XMFLOAT2.operator =
targetos: Windows
req.typenames: 
req.redist: 
---

# XMFLOAT2::operator-assign

## -description

Assigns the vector component data from one instance of <code>XMFLOAT2</code> to the current instance of <code>XMFLOAT2</code>.

This operator assigns the vector component data from one instance of <a href="https://msdn.microsoft.com/7F53D7CC-CE2C-4F1F-AA24-C11DD537F8EB">XMFLOAT2</a> to the current instance of <code>XMFLOAT2</code>.

<div class="alert"><b>Note</b>  This operator is only available under C++.</div>

## -parameters

### -param arg1

Instance of <code>XMFLOAT2</code> used to update the current <code>XMFLOAT2</code>structure.

## -returns

The current instance of <code>XMFLOAT2</code> whose vector component data has been updated to match those of the <code>XMFLOAT2</code> instance specified by the <b>Float2</b> argument.

## -see-also

<a href="https://msdn.microsoft.com/7F53D7CC-CE2C-4F1F-AA24-C11DD537F8EB">XMFLOAT2</a>

<a href="https://msdn.microsoft.com/91b6d6e3-7953-461c-8b64-c50f394caa63">XMFLOAT2 Operators</a>
