---
UID: NF:directxmath.XMINT2.operator-assign
title: XMINT2::operator-assign
description: Assigns the vector component data from one instance of XMINT2 to the current instance of XMINT2.
old-location: dxmath\xmint2_operator_eq.htm
tech.root: dxmath
ms.assetid: M:Microsoft.directx_sdk.reference.XMINT2.operator = (const XMINT2)
ms.date: 05/13/2019
ms.keywords: Use DirectX..XMINT2.operator =, Use DirectX::::XMINT2::operator =, XMINT2 structure [DirectX Math Support APIs],operator = method, XMINT2.operator =, XMINT2.operator-assign, XMINT2.operator=, XMINT2::operator-assign, XMINT2::operator=, dxmath.xmint2_operator_eq, operator = method [DirectX Math Support APIs], operator = method [DirectX Math Support APIs],XMINT2 structure, operator=
f1_keywords:
- directxmath/XMINT2.operator =
dev_langs:
- c++
req.header: directxmath.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: Use DirectX.
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- DirectXMath.h
api_name:
- XMINT2.operator =
targetos: Windows
req.typenames: 
req.redist: 
---

# XMINT2::operator-assign

## -description

Assigns the vector component data from one instance of <code>XMINT2</code> to the current instance of <code>XMINT2</code>.

This operator assigns the vector component data from one instance of <a href="https://msdn.microsoft.com/41e10329-9f6f-446f-9640-6c1d65e20cb5">XMINT2</a> to the current instance of <code>XMINT2</code>.

<div class="alert"><b>Note</b>  This operator is only available under C++.</div>

## -parameters

### -param arg1

Instance of <code>XMINT2</code> used to update the current <code>XMINT2</code>structure.

## -returns

The current instance of <code>XMINT2</code> whose vector component data has been updated to match those of the <code>XMINT2</code> instance specified by the <b>Int2</b> argument.

## -see-also

<a href="https://msdn.microsoft.com/41e10329-9f6f-446f-9640-6c1d65e20cb5">XMINT2</a>

<a href="https://msdn.microsoft.com/98822959-f4ef-4f73-8011-f9eba201dcc0">XMINT2 Operators</a>
