---
UID: NF:directxmath.XMINT3.operator-assign
title: XMINT3::operator-assign
description: Assigns the vector component data from one instance of XMINT3 to the current instance of XMINT3.
old-location: dxmath\xmint3_operator_eq.htm
tech.root: dxmath
ms.assetid: M:Microsoft.directx_sdk.reference.XMINT3.operator = (const XMINT3)
ms.date: 05/13/2019
ms.keywords: Use DirectX..XMINT3.operator =, Use DirectX::::XMINT3::operator =, XMINT3 structure [DirectX Math Support APIs],operator = method, XMINT3.operator =, XMINT3.operator-assign, XMINT3.operator=, XMINT3::operator-assign, XMINT3::operator=, dxmath.xmint3_operator_eq, operator = method [DirectX Math Support APIs], operator = method [DirectX Math Support APIs],XMINT3 structure, operator=
f1_keywords:
- directxmath/XMINT3.operator =
dev_langs:
- c++
req.header: directxmath.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: Use DirectX.
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- DirectXMath.h
api_name:
- XMINT3.operator =
targetos: Windows
req.typenames: 
req.redist: 
---

# XMINT3::operator-assign

## -description

Assigns the vector component data from one instance of <code>XMINT3</code> to the current instance of <code>XMINT3</code>.

This operator assigns the vector component data from one instance of <a href="https://msdn.microsoft.com/9924ed70-e6f8-4040-aab1-977bc3f197e6">XMINT3</a> to the current instance of <code>XMINT3</code>.

<div class="alert"><b>Note</b>  This operator is only available under C++.</div>

## -parameters

### -param arg1

Instance of <code>XMINT3</code> used to update the current <code>XMINT3</code> structure.

## -returns

The current instance of <code>XMINT3</code> whose vector component data has been updated to match those of the <code>XMINT3</code> instance specified by the <b>Int3</b>argument.

## -see-also

<a href="https://msdn.microsoft.com/9924ed70-e6f8-4040-aab1-977bc3f197e6">XMINT3</a>

<a href="https://msdn.microsoft.com/4c78cb57-52e7-4a06-91d9-2fb3f73a0f0e">XMINT3 Operators</a>
