---
UID: NF:directxmath.XMINT4.operator-assign
title: XMINT4::operator-assign
description: Assigns the vector component data from one instance of XMINT4 to the current instance of XMINT4.
old-location: dxmath\xmint4_operator_eq.htm
tech.root: dxmath
ms.assetid: M:Microsoft.directx_sdk.reference.XMINT4.operator = (const XMINT4)
ms.date: 05/13/2019
ms.keywords: Use DirectX..XMINT4.operator =, Use DirectX::::XMINT4::operator =, XMINT4 structure [DirectX Math Support APIs],operator = method, XMINT4.operator =, XMINT4.operator-assign, XMINT4.operator=, XMINT4::operator-assign, XMINT4::operator=, dxmath.xmint4_operator_eq, operator = method [DirectX Math Support APIs], operator = method [DirectX Math Support APIs],XMINT4 structure, operator=
f1_keywords:
- directxmath/XMINT4.operator =
dev_langs:
- c++
req.header: directxmath.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: Use DirectX.
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- DirectXMath.h
api_name:
- XMINT4.operator =
targetos: Windows
req.typenames: 
req.redist: 
---

# XMINT4::operator-assign

## -description

Assigns the vector component data from one instance of <code>XMINT4</code> to the current instance of <code>XMINT4</code>.

This operator assigns the vector component data from one instance of <a href="https://msdn.microsoft.com/4562AF48-FC7E-4737-AB7B-7A76789DC70B">XMINT4</a> to the current instance of <code>XMINT4</code>.

<div class="alert"><b>Note</b>  This operator is only available under C++.</div>

## -parameters

### -param arg1

Instance of <code>XMINT4</code> used to update the current <code>XMINT4</code>structure.

## -returns

The current instance of <code>XMINT4</code> whose vector component data has been updated to match those of the <code>XMINT4</code> instance specified by the <b>Int4</b> argument.

## -see-also

<a href="https://msdn.microsoft.com/4562AF48-FC7E-4737-AB7B-7A76789DC70B">XMINT4</a>

<a href="https://msdn.microsoft.com/efb42dbb-30ea-426a-a281-b5b732085805">XMINT4 Operators</a>
