---
UID: NF:directxmath.XMScalarSin
title: XMScalarSin function (directxmath.h)
description: Computes the sine of a radian angle.
old-location: dxmath\xmscalarsin.htm
tech.root: dxmath
ms.assetid: M:Microsoft.directx_sdk.scalar.XMScalarSin(float)
ms.date: 12/05/2018
ms.keywords: Use DirectX..XMScalarSin, XMScalarSin, XMScalarSin method [DirectX Math Support APIs], dxmath.xmscalarsin
f1_keywords:
- directxmath/XMScalarSin
dev_langs:
- c++
req.header: directxmath.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: Use DirectX.
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- DirectXMath.h
api_name:
- XMScalarSin
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# XMScalarSin function


## -description


Computes the sine of a radian angle.


## -parameters




### -param Value [in]

<b>float</b> value describing the radian angle.


## -returns



Returns the sine of <i>Value</i>.




## -remarks



This function uses a 11-degree minimax approximation.

<h3><a id="Platform_Requirements"></a><a id="platform_requirements"></a><a id="PLATFORM_REQUIREMENTS"></a>Platform Requirements</h3>
Microsoft Visual Studio 2010 or Microsoft Visual Studio 2012 with the Windows SDK for Windows 8. Supported for Win32 desktop apps, Windows Store apps, and Windows Phone 8 apps.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/dxmath/ovw-xnamath-reference-functions-scalar">DirectXMath Library Scalar Functions</a>



<a href="https://docs.microsoft.com/en-us/windows/desktop/api/directxmath/nf-directxmath-xmscalarasin">XMScalarASin</a>



<a href="https://docs.microsoft.com/en-us/windows/desktop/api/directxmath/nf-directxmath-xmscalarasinest">XMScalarASinEst</a>



<a href="https://docs.microsoft.com/en-us/windows/desktop/api/directxmath/nf-directxmath-xmscalarsinest">XMScalarSinEst</a>
 

 

