---
UID: NF:directxmath.XMUINT3.operator-assign
title: XMUINT3::operator-assign
description: Assigns the vector component data from one instance of XMUINT3 to the current instance of XMUINT3.
old-location: dxmath\xmuint3_operator_eq.htm
tech.root: dxmath
ms.assetid: M:Microsoft.directx_sdk.reference.XMUINT3.operator = (const XMUINT3)
ms.date: 05/13/2019
ms.keywords: Use DirectX..XMUINT3.operator =, Use DirectX::::XMUINT3::operator =, XMUINT3 structure [DirectX Math Support APIs],operator = method, XMUINT3.operator =, XMUINT3.operator-assign, XMUINT3.operator=, XMUINT3::operator-assign, XMUINT3::operator=, dxmath.xmuint3_operator_eq, operator = method [DirectX Math Support APIs], operator = method [DirectX Math Support APIs],XMUINT3 structure, operator=
f1_keywords:
- directxmath/XMUINT3.operator =
dev_langs:
- c++
req.header: directxmath.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: Use DirectX.
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- DirectXMath.h
api_name:
- XMUINT3.operator =
targetos: Windows
req.typenames: 
req.redist: 
---

# XMUINT3::operator-assign

## -description

Assigns the vector component data from one instance of <code>XMUINT3</code> to the current instance of <code>XMUINT3</code>.

This operator assigns the vector component data from one instance of <a href="https://msdn.microsoft.com/B3B7CD31-8759-4674-AAA9-E13DA1D67675">XMUINT3</a> to the current instance of <code>XMUINT3</code>.

<div class="alert"><b>Note</b>  This operator is only available under C++.</div>

## -parameters

### -param arg1

Instance of <code>XMUINT3</code> used to update the current <code>XMUINT3</code> structure.

## -returns

The current instance of <code>XMUINT3</code> whose vector component data has been updated to match those of the <code>XMUINT3</code> instance specified by the <b>UInt3</b>argument.

## -see-also

<a href="https://msdn.microsoft.com/B3B7CD31-8759-4674-AAA9-E13DA1D67675">XMUINT3</a>

<a href="https://msdn.microsoft.com/6e732b64-9926-4949-9292-c3ac3a553967">XMUINT3 Operators</a>
