---
UID: NF:directxmath.XMUINT4.operator-assign
title: XMUINT4::operator-assign
description: Assigns the vector component data from one instance of XMUINT4 to the current instance of XMUINT4.
old-location: dxmath\xmuint4_operator_eq.htm
tech.root: dxmath
ms.assetid: M:Microsoft.directx_sdk.reference.XMUINT4.operator = (const XMUINT4)
ms.date: 05/13/2019
ms.keywords: Use DirectX..XMUINT4.operator =, Use DirectX::::XMUINT4::operator =, XMUINT4 structure [DirectX Math Support APIs],operator = method, XMUINT4.operator =, XMUINT4.operator-assign, XMUINT4.operator=, XMUINT4::operator-assign, XMUINT4::operator=, dxmath.xmuint4_operator_eq, operator = method [DirectX Math Support APIs], operator = method [DirectX Math Support APIs],XMUINT4 structure, operator=
f1_keywords:
- directxmath/XMUINT4.operator =
dev_langs:
- c++
req.header: directxmath.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: Use DirectX.
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- DirectXMath.h
api_name:
- XMUINT4.operator =
targetos: Windows
req.typenames: 
req.redist: 
---

# XMUINT4::operator-assign

## -description

Assigns the vector component data from one instance of <code>XMUINT4</code> to the current instance of <code>XMUINT4</code>.

This operator assigns the vector component data from one instance of <a href="https://msdn.microsoft.com/d0f31846-0732-4309-8ad6-3e2bfe690736">XMUINT4</a> to the current instance of <code>XMUINT4</code>.

<div class="alert"><b>Note</b>  This operator is only available under C++.</div>

## -parameters

### -param arg1

Instance of <code>XMUINT4</code> used to update the current <code>XMUINT4</code>structure.

## -returns

The current instance of <code>XMUINT4</code> whose vector component data has been updated to match those of the <code>XMUINT4</code> instance specified by the <b>UInt4</b> argument.

## -see-also

<a href="https://msdn.microsoft.com/d0f31846-0732-4309-8ad6-3e2bfe690736">XMUINT4</a>

<a href="https://msdn.microsoft.com/2488e70d-01dd-4d98-840e-35eca28ac10b">XMUINT4 Operators</a>
