---
UID: NF:directxmath.XMVector2IsNaN
title: XMVector2IsNaN function (directxmath.h)
description: Tests whether any component of a 2D vector is a NaN.
old-location: dxmath\xmvector2isnan.htm
tech.root: dxmath
ms.assetid: M:Microsoft.directx_sdk.comparison.XMVector2IsNaN(XMVECTOR)
ms.date: 12/05/2018
ms.keywords: Use DirectX..XMVector2IsNaN, XMVector2IsNaN, XMVector2IsNaN method [DirectX Math Support APIs], dxmath.xmvector2isnan
f1_keywords:
- directxmath/XMVector2IsNaN
dev_langs:
- c++
req.header: directxmath.h
req.include-header: DirectXMath.h
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: Use DirectX.
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- directxmathvector.inl
api_name:
- XMVector2IsNaN
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# XMVector2IsNaN function


## -description


Tests whether any component of a 2D vector is a NaN.


## -parameters




### -param V [in]

2D vector.


## -returns



Returns true if any component of <i>V</i> is a NaN, and false otherwise.




## -remarks



<h3><a id="Platform_Requirements"></a><a id="platform_requirements"></a><a id="PLATFORM_REQUIREMENTS"></a>Platform Requirements</h3>
Microsoft Visual Studio 2010 or Microsoft Visual Studio 2012 with the Windows SDK for Windows 8. Supported for Win32 desktop apps, Windows Store apps, and Windows Phone 8 apps.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/dxmath/ovw-xnamath-reference-functions-vector2-comparison">DirectXMath Library 2D Vector Comparison Functions</a>
 

 

