---
UID: NF:directxmath.XMVector2Length
title: XMVector2Length function (directxmath.h)
description: Computes the length of a 2D vector.
old-location: dxmath\xmvector2length.htm
tech.root: dxmath
ms.assetid: M:Microsoft.directx_sdk.geometric.XMVector2Length(XMVECTOR)
ms.date: 12/05/2018
ms.keywords: Use DirectX..XMVector2Length, XMVector2Length, XMVector2Length method [DirectX Math Support APIs], dxmath.xmvector2length
f1_keywords:
- directxmath/XMVector2Length
dev_langs:
- c++
req.header: directxmath.h
req.include-header: DirectXMath.h
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: Use DirectX.
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- directxmathvector.inl
api_name:
- XMVector2Length
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# XMVector2Length function


## -description


Computes the length of a 2D vector.


## -parameters




### -param V [in]

2D vector.


## -returns



Returns a vector. The length of <i>V</i> is replicated into each component.




## -remarks



<h3><a id="Platform_Requirements"></a><a id="platform_requirements"></a><a id="PLATFORM_REQUIREMENTS"></a>Platform Requirements</h3>
Microsoft Visual Studio 2010 or Microsoft Visual Studio 2012 with the Windows SDK for Windows 8. Supported for Win32 desktop apps, Windows Store apps, and Windows Phone 8 apps.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/dxmath/ovw-xnamath-reference-functions-vector2-geometric">DirectXMath Library 2D Vector Geometric Functions</a>



<a href="https://docs.microsoft.com/windows/desktop/api/directxmath/nf-directxmath-xmvector2lengthest">XMVector2LengthEst</a>



<a href="https://docs.microsoft.com/windows/desktop/api/directxmath/nf-directxmath-xmvector2lengthsq">XMVector2LengthSq</a>
 

 

