---
UID: NF:directxmath.XMVector3EqualInt
title: XMVector3EqualInt function (directxmath.h)
description: Tests whether two 3D vectors are equal, treating each component as an unsigned integer.
old-location: dxmath\xmvector3equalint.htm
tech.root: dxmath
ms.assetid: M:Microsoft.directx_sdk.comparison.XMVector3EqualInt(XMVECTOR,XMVECTOR)
ms.date: 12/05/2018
ms.keywords: Use DirectX..XMVector3EqualInt, XMVector3EqualInt, XMVector3EqualInt method [DirectX Math Support APIs], dxmath.xmvector3equalint
f1_keywords:
- directxmath/XMVector3EqualInt
dev_langs:
- c++
req.header: directxmath.h
req.include-header: DirectXMath.h
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: Use DirectX.
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- directxmathvector.inl
api_name:
- XMVector3EqualInt
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# XMVector3EqualInt function


## -description


Tests whether two 3D vectors are equal, treating each component as an unsigned integer.


## -parameters




### -param V1 [in]

3D vector.


### -param V2 [in]

3D vector.


## -returns



Returns true if the 3D vectors are equal and false otherwise.




## -remarks



<h3><a id="Platform_Requirements"></a><a id="platform_requirements"></a><a id="PLATFORM_REQUIREMENTS"></a>Platform Requirements</h3>
Microsoft Visual Studio 2010 or Microsoft Visual Studio 2012 with the Windows SDK for Windows 8. Supported for Win32 desktop apps, Windows Store apps, and Windows Phone 8 apps.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/dxmath/ovw-xnamath-reference-functions-vector3-comparison">DirectXMath Library 3D Vector Comparison Functions</a>



<a href="https://docs.microsoft.com/windows/desktop/api/directxmath/nf-directxmath-xmvector3equalintr">XMVector3EqualIntR</a>
 

 

