---
UID: NF:directxmath.XMVectorReplicate
title: XMVectorReplicate function (directxmath.h)
description: Replicates a floating-point value into all four components of a vector.
old-location: dxmath\xmvectorreplicate.htm
tech.root: dxmath
ms.assetid: M:Microsoft.directx_sdk.initialization.XMVectorReplicate(float)
ms.date: 12/05/2018
ms.keywords: Use DirectX..XMVectorReplicate, XMVectorReplicate, XMVectorReplicate method [DirectX Math Support APIs], dxmath.xmvectorreplicate
f1_keywords:
- directxmath/XMVectorReplicate
dev_langs:
- c++
req.header: directxmath.h
req.include-header: DirectXMath.h
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: Use DirectX.
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- directxmathvector.inl
api_name:
- XMVectorReplicate
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# XMVectorReplicate function


## -description


Replicates a floating-point value into all four components of a vector.


## -parameters




### -param Value [in]

Value to replicate.


## -returns



Returns a vector, all of whose components are equal to <i>Value</i>.




## -remarks



<h3><a id="Platform_Requirements"></a><a id="platform_requirements"></a><a id="PLATFORM_REQUIREMENTS"></a>Platform Requirements</h3>
Microsoft Visual Studio 2010 or Microsoft Visual Studio 2012 with the Windows SDK for Windows 8. Supported for Win32 desktop apps, Windows Store apps, and Windows Phone 8 apps.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/dxmath/ovw-xnamath-reference-functions-vector-initialization">Vector Initialization Functions</a>



<a href="https://docs.microsoft.com/windows/desktop/api/directxmath/nf-directxmath-xmvectorreplicateint">XMVectorReplicateInt</a>



<a href="https://docs.microsoft.com/windows/desktop/api/directxmath/nf-directxmath-xmvectorreplicateintptr">XMVectorReplicateIntPtr</a>



<a href="https://docs.microsoft.com/en-us/windows/desktop/api/directxmath/nf-directxmath-xmvectorreplicateptr">XMVectorReplicatePtr</a>
 

 

