---
UID: NF:directxmath.XMVectorSplatZ
title: XMVectorSplatZ function (directxmath.h)
description: Replicates the z component of a vector to all of the components.
old-location: dxmath\xmvectorsplatz.htm
tech.root: dxmath
ms.assetid: M:Microsoft.directx_sdk.component-wise.XMVectorSplatZ(XMVECTOR)
ms.date: 12/05/2018
ms.keywords: Use DirectX..XMVectorSplatZ, XMVectorSplatZ, XMVectorSplatZ method [DirectX Math Support APIs], dxmath.xmvectorsplatz
f1_keywords:
- directxmath/XMVectorSplatZ
dev_langs:
- c++
req.header: directxmath.h
req.include-header: DirectXMath.h
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: Use DirectX.
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- directxmathvector.inl
api_name:
- XMVectorSplatZ
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# XMVectorSplatZ function


## -description


Replicates the z component of a vector to all of the components.


## -parameters




### -param V [in]

Vector from which to select the z component.


## -returns



Returns a vector, all of whose components are equal to the z component of <i>V</i>.




## -remarks



<h3><a id="Platform_Requirements"></a><a id="platform_requirements"></a><a id="PLATFORM_REQUIREMENTS"></a>Platform Requirements</h3>
Microsoft Visual Studio 2010 or Microsoft Visual Studio 2012 with the Windows SDK for Windows 8. Supported for Win32 desktop apps, Windows Store apps, and Windows Phone 8 apps.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/dxmath/ovw-xnamath-reference-functions-vector-component-wise">Component-Wise Vector Functions</a>
 

 

