---
UID: NF:directxmath.XMVectorSubtract
title: XMVectorSubtract function (directxmath.h)
description: Computes the difference of two vectors.
old-location: dxmath\xmvectorsubtract.htm
tech.root: dxmath
ms.assetid: M:Microsoft.directx_sdk.arithmetic.XMVectorSubtract(XMVECTOR,XMVECTOR)
ms.date: 12/05/2018
ms.keywords: Use DirectX..XMVectorSubtract, XMVectorSubtract, XMVectorSubtract method [DirectX Math Support APIs], dxmath.xmvectorsubtract
f1_keywords:
- directxmath/XMVectorSubtract
dev_langs:
- c++
req.header: directxmath.h
req.include-header: DirectXMath.h
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: Use DirectX.
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- directxmathvector.inl
api_name:
- XMVectorSubtract
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# XMVectorSubtract function


## -description


Computes the difference of two vectors.


## -parameters




### -param V1 [in]

First vector.


### -param V2 [in]

Vector to subtract from <i>V1</i>


## -returns



Returns a vector that is the difference of <i>V1</i> and <i>V2</i>.




## -remarks



<h3><a id="Platform_Requirements"></a><a id="platform_requirements"></a><a id="PLATFORM_REQUIREMENTS"></a>Platform Requirements</h3>
Microsoft Visual Studio 2010 or Microsoft Visual Studio 2012 with the Windows SDK for Windows 8. Supported for Win32 desktop apps, Windows Store apps, and Windows Phone 8 apps.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/dxmath/ovw-xnamath-reference-functions-vector-arithmetic">Vector Arithmetic Functions</a>
 

 

