---
UID: NF:directxmath.XMVectorSum
title: XMVectorSum function (directxmath.h)
description: Computes the horizontal sum of the components of an XMVECTOR. The horizontal sum is the result of adding each component in the vector together.
old-location: dxmath\xmvectorsum.htm
tech.root: dxmath
ms.assetid: M:Microsoft.directx_sdk.transcendental.XMVectorSum(FXMVECTOR)
ms.date: 12/05/2018
ms.keywords: Use DirectX..XMVectorSum, XMVectorSum, XMVectorSum method [DirectX Math Support APIs], dxmath.xmvectorsum
f1_keywords:
- directxmath/XMVectorSum
dev_langs:
- c++
req.header: directxmath.h
req.include-header: DirectXMath.h
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: Use DirectX.
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- directxmathvector.inl
api_name:
- XMVectorSum
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# XMVectorSum function


## -description


Computes the horizontal sum of the components of an <a href="https://docs.microsoft.com/windows/desktop/dxmath/xmvector-data-type">XMVECTOR</a>. The horizontal sum is the result of adding each component in the vector together.


## -parameters




### -param V [in]

Vector for which to compute the horizontal sum.


## -returns



Returns a vector whose components are the horizontal sum of the components of <i>V</i>.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/dxmath/ovw-xnamath-reference-functions-vector-arithmetic">Vector Arithmetic Functions</a>
 

 

