---
UID: NF:directxpackedvector.XMBYTE2.operator-assign
title: XMBYTE2::operator-assign (directxpackedvector.h)
description: Assigns the vector component data from one instance of XMBYTE2 to the current instance of XMBYTE2.
old-location: dxmath\xmbyte2_operator_eq.htm
tech.root: dxmath
ms.assetid: M:Microsoft.directx_sdk.reference.XMBYTE2.operator = (const XMBYTE2)
ms.date: 12/05/2018
ms.keywords: DirectX::PackedVector.XMBYTE2.operator =, DirectX::PackedVector::XMBYTE2::operator =, XMBYTE2 structure [DirectX Math Support APIs],operator = method, XMBYTE2.operator =, XMBYTE2.operator-assign, XMBYTE2.operator=, XMBYTE2::operator-assign, XMBYTE2::operator=, dxmath.xmbyte2_operator_eq, operator = method [DirectX Math Support APIs], operator = method [DirectX Math Support APIs],XMBYTE2 structure, operator=
f1_keywords:
- directxpackedvector/XMBYTE2.operator =
dev_langs:
- c++
req.header: directxpackedvector.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: DirectX::PackedVector
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- DirectXPackedVector.h
api_name:
- XMBYTE2.operator =
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# XMBYTE2::operator-assign


## -description


Assigns the vector component data from one instance of <code>XMBYTE2</code> to the current instance of <code>XMBYTE2</code>.

This operator assigns the vector component data from one instance of <a href="https://msdn.microsoft.com/AA5A5A85-7AEE-4CD9-AAE9-004A65BAB076">XMBYTE2</a> to the current
  instance of <code>XMBYTE2</code>.
<div class="alert"><b>Note</b>  This operator is only available with C++.</div><div> </div>

## -parameters




### -param arg1

TBD




#### - Byte2 [ref]

Instance of <code>XMBYTE2</code> used to update the current <code>XMBYTE2</code> structure.
      


## -returns



The current instance of <code>XMBYTE2</code> whose vector component data has been updated
	    to match those of the <code>XMBYTE2</code> instance specified by the <b>Byte2</b>argument.
	




## -see-also




<b>Reference</b>



<a href="https://msdn.microsoft.com/AA5A5A85-7AEE-4CD9-AAE9-004A65BAB076">XMBYTE2</a>



<a href="https://msdn.microsoft.com/402876b9-731e-4c30-b48f-bca67ed6dad1">XMBYTE2 Operators</a>
 

 

