---
UID: NF:directxpackedvector.XMBYTE4.operator-assign(XMBYTE4 &&)
title: XMBYTE4::operator=
description: Assigns the vector component data from one instance of XMBYTE4 to the current instance of XMBYTE4.
ms.assetid: 24a7bc33-4bca-476b-9541-c4c2ac03fb7a
ms.date: 05/20/2019
ms.keywords: XMBYTE4::operator=
f1_keywords:
- directxpackedvector/XMBYTE4::operator=
dev_langs:
- c++
targetos: Windows
req.assembly: 
req.construct-type: function
req.ddi-compliance: 
req.dll: 
req.header: directxpackedvector.h
req.idl: 
req.include-header: 
req.irql: 
req.kmdf-ver: 
req.lib: 
req.max-support: 
req.namespace: 
req.redist: 
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.target-type: 
req.type-library: 
req.umdf-ver: 
req.unicode-ansi: 
topic_type:
- apiref
api_type:
- 
api_location:
- directxpackedvector.h
api_name:
- XMBYTE4::operator=
---

# XMBYTE4::operator = 

## -description

Assigns the vector component data from one instance of <a href="https://docs.microsoft.com/windows/desktop/api/directxpackedvector/ns-directxpackedvector-xmbyte4">XMBYTE4</a> to the current instance of **XMBYTE4**.

This operator assigns the vector component data from one instance of **XMBYTE4** to the current instance of **XMBYTE4**.

<div class="alert"><b>Note</b>  This operator is only available under C++.</div>

## -parameters

### -param arg1

Instance of **XMBYTE4** used to update the current **XMBYTE4** structure.

## -returns

The current instance of **XMBYTE4** whose vector component data has been updated to match those of the **XMBYTE4** instance specified by the argument.

## -remarks

## -see-also

<a href="https://docs.microsoft.com/windows/desktop/api/directxpackedvector/ns-directxpackedvector-xmbyte4">XMBYTE4</a>
