---
UID: NF:directxpackedvector.XMBYTEN2.operator-assign
title: XMBYTEN2::operator-assign (directxpackedvector.h)
description: Assigns the vector component data from one instance of XMBYTEN2 to the current instance of XMBYTEN2.
old-location: dxmath\xmbyten2_operator_eq.htm
tech.root: dxmath
ms.assetid: f693bab9-9d65-420d-a079-ad7a8f51c6a3
ms.date: 05/06/2019
ms.keywords: DirectX::PackedVector.XMBYTEN2.operator =, DirectX::PackedVector::XMBYTEN2::operator =, XMBYTEN2 structure [DirectX Math Support APIs],operator = method, XMBYTEN2.operator =, XMBYTEN2.operator-assign, XMBYTEN2.operator=, XMBYTEN2::operator-assign, XMBYTEN2::operator=, dxmath.xmbyten2_operator_eq, operator = method [DirectX Math Support APIs], operator = method [DirectX Math Support APIs],XMBYTEN2 structure, operator=
f1_keywords:
- directxpackedvector/XMBYTEN2.operator =
dev_langs:
- c++
req.header: directxpackedvector.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: DirectX::PackedVector
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- DirectXPackedVector.h
api_name:
- XMBYTEN2.operator =
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# XMBYTEN2::operator-assign

## -description

Assigns the vector component data from one instance of <code>XMBYTEN2</code> to the current instance of <code>XMBYTEN2</code>.

This operator assigns the vector component data from one instance of <a href="https://msdn.microsoft.com/87cadfb8-6b3c-4c66-88c1-c3751edeb3f2">XMBYTEN2</a> to the current instance of <code>XMBYTEN2</code>.

<div class="alert"><b>Note</b>  This operator is only available with C++.</div>

## -parameters

### -param arg1

Instance of <code>XMBYTEN2</code> used to update the current <code>XMBYTEN2</code> structure.

## -returns

The current instance of <code>XMBYTEN2</code> whose vector component data has been updated to match those of the <code>XMBYTEN2</code> instance specified by the <b>Byte2</b>argument.

## -see-also

<a href="https://msdn.microsoft.com/87cadfb8-6b3c-4c66-88c1-c3751edeb3f2">XMBYTEN2</a>

<a href="https://msdn.microsoft.com/451a45f6-d77e-4860-84b1-362ea1f00578">XMBYTEN2 Operators</a>
