---
UID: NF:directxpackedvector.XMConvertFloatToHalf
title: XMConvertFloatToHalf function (directxpackedvector.h)
description: Converts a single-precision floating-point value to a half-precision floating-point value.
old-location: dxmath\xmconvertfloattohalf.htm
tech.root: dxmath
ms.assetid: M:Microsoft.directx_sdk.conversion.XMConvertFloatToHalf(float)
ms.date: 12/05/2018
ms.keywords: DirectX::PackedVector.XMConvertFloatToHalf, XMConvertFloatToHalf, XMConvertFloatToHalf method [DirectX Math Support APIs], dxmath.xmconvertfloattohalf
f1_keywords:
- directxpackedvector/XMConvertFloatToHalf
dev_langs:
- c++
req.header: directxpackedvector.h
req.include-header: DirectXMath.h
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: DirectX::PackedVector
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- directxpackedvector.h
api_name:
- XMConvertFloatToHalf
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# XMConvertFloatToHalf function


## -description


Converts a single-precision floating-point value to a half-precision floating-point value.


## -parameters




### -param Value [in]

<b>float</b> value to convert.


## -returns



Returns the half-precision floating-point value closest to <i>Value</i>.




## -remarks



<h3><a id="Platform_Requirements"></a><a id="platform_requirements"></a><a id="PLATFORM_REQUIREMENTS"></a>Platform Requirements</h3>
Microsoft Visual Studio 2010 or Microsoft Visual Studio 2012 with the Windows SDK for Windows 8. Supported for Win32 desktop apps, Windows Store apps, and Windows Phone 8 apps.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/dxmath/ovw-xnamath-reference-functions-conversion">DirectXMath Library Conversion Functions</a>



<a href="https://docs.microsoft.com/windows/desktop/api/directxpackedvector/nf-directxpackedvector-xmconvertfloattohalfstream">XMConvertFloatToHalfStream</a>



<a href="https://docs.microsoft.com/windows/desktop/api/directxpackedvector/nf-directxpackedvector-xmconverthalftofloat">XMConvertHalfToFloat</a>
 

 

