---
UID: NF:directxpackedvector.XMDECN4.operator-assign(XMDECN4 &&)
title: XMDECN4::operator=
description: Assigns the vector component data from one instance of XMDECN4 to the current instance of XMDECN4.
ms.assetid: 5f8c7563-b0b1-44a4-a52e-7a25e684f284
ms.date: 05/20/2019
ms.keywords: XMDECN4::operator=
f1_keywords:
- directxpackedvector/XMDECN4::operator=
dev_langs:
- c++
targetos: Windows
req.assembly: 
req.construct-type: function
req.ddi-compliance: 
req.dll: 
req.header: directxpackedvector.h
req.idl: 
req.include-header: 
req.irql: 
req.kmdf-ver: 
req.lib: 
req.max-support: 
req.namespace: 
req.redist: 
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.target-type: 
req.type-library: 
req.umdf-ver: 
req.unicode-ansi: 
topic_type:
- apiref
api_type:
- 
api_location:
- directxpackedvector.h
api_name:
- XMDECN4::operator=
---

# XMDECN4::operator =  (const XMDECN4&)

## -description

Assigns the vector component data from one instance of <a href="https://docs.microsoft.com/en-us/windows/desktop/api/directxpackedvector/ns-directxpackedvector-xmdecn4">XMDECN4</a> to the current instance of **XMDECN4**.

This operator assigns the vector component data from one instance of **XMDECN4** to the current instance of **XMDECN4**.

<div class="alert"><b>Note</b>  This operator is only available under C++.</div>

## -parameters

### -param arg1

Instance of **XMDECN4** used to update the current **XMDECN4** structure.

## -returns

The current instance of **XMDECN4** whose vector component data has been updated to match those of the **XMDECN4** instance specified by the argument.

## -remarks

## -see-also

<a href="https://docs.microsoft.com/en-us/windows/desktop/api/directxpackedvector/ns-directxpackedvector-xmdecn4">XMDECN4</a>
