---
UID: NF:directxpackedvector.XMSHORT2.operator-assign
title: XMSHORT2::operator-assign (directxpackedvector.h)
description: Assigns the vector component data from one instance of XMSHORT2 to the current instance of XMSHORT2.
old-location: dxmath\xmshort2_operator_eq.htm
tech.root: dxmath
ms.assetid: M:Microsoft.directx_sdk.reference.XMSHORT2.operator = (const XMSHORT2)
ms.date: 05/06/2019
ms.keywords: DirectX::PackedVector.XMSHORT2.operator =, DirectX::PackedVector::XMSHORT2::operator =, XMSHORT2 structure [DirectX Math Support APIs],operator = method, XMSHORT2.operator =, XMSHORT2.operator-assign, XMSHORT2.operator=, XMSHORT2::operator-assign, XMSHORT2::operator=, dxmath.xmshort2_operator_eq, operator = method [DirectX Math Support APIs], operator = method [DirectX Math Support APIs],XMSHORT2 structure, operator=
f1_keywords:
- directxpackedvector/XMSHORT2.operator =
dev_langs:
- c++
req.header: directxpackedvector.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: DirectX::PackedVector
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- DirectXPackedVector.h
api_name:
- XMSHORT2.operator =
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# XMSHORT2::operator-assign


## -description

Assigns the vector component data from one instance of <code>XMSHORT2</code> to the current instance of <code>XMSHORT2</code>.

This operator assigns the vector component data from one instance of <a href="https://msdn.microsoft.com/C41BEAA7-E620-4D64-8408-584CDB6F835A">XMSHORT2</a> to the current instance of <code>XMSHORT2</code>.

<div class="alert"><b>Note</b>  This operator is only available under C++.</div>

## -parameters

### -param arg1

Instance of <code>XMSHORT2</code> used to update the current <code>XMSHORT2</code>structure.

## -returns

The current instance of <code>XMSHORT2</code> whose vector component data has been updated to match those of the <code>XMSHORT2</code> instance specified by the <b>Short2</b> argument.

## -see-also

<a href="https://msdn.microsoft.com/C41BEAA7-E620-4D64-8408-584CDB6F835A">XMSHORT2</a>

<a href="https://msdn.microsoft.com/7e9cad7b-03c2-45ec-8fe9-110f4197cae1">XMSHORT2 Operators</a>
