---
UID: NF:directxpackedvector.XMSHORT4.operator-assign
title: XMSHORT4::operator-assign (directxpackedvector.h)
description: Assigns the vector component data from one instance of XMSHORT4 to the current instance of XMSHORT4.
old-location: dxmath\xmshort4_operator_eq.htm
tech.root: dxmath
ms.assetid: M:Microsoft.directx_sdk.reference.XMSHORT4.operator = (const XMSHORT4)
ms.date: 05/06/2019
ms.keywords: DirectX::PackedVector.XMSHORT4.operator =, DirectX::PackedVector::XMSHORT4::operator =, XMSHORT4 structure [DirectX Math Support APIs],operator = method, XMSHORT4.operator =, XMSHORT4.operator-assign, XMSHORT4.operator=, XMSHORT4::operator-assign, XMSHORT4::operator=, dxmath.xmshort4_operator_eq, operator = method [DirectX Math Support APIs], operator = method [DirectX Math Support APIs],XMSHORT4 structure, operator=
f1_keywords:
- directxpackedvector/XMSHORT4.operator =
dev_langs:
- c++
req.header: directxpackedvector.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: DirectX::PackedVector
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- DirectXPackedVector.h
api_name:
- XMSHORT4.operator =
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# XMSHORT4::operator-assign

## -description

Assigns the vector component data from one instance of <code>XMSHORT4</code> to the current instance of <code>XMSHORT4</code>.

This operator assigns the vector component data from one instance of <a href="https://msdn.microsoft.com/49DAD98F-14D6-45B9-9D30-0EC553BB32EF">XMSHORT4</a> to the current instance of <code>XMSHORT4</code>.

<div class="alert"><b>Note</b>  This operator is only available under C++.</div>

## -parameters

### -param arg1

Instance of <code>XMSHORT4</code> used to update the current <code>XMSHORT4</code>structure.

## -returns

The current instance of <code>XMSHORT4</code> whose vector component data has been updated to match those of the <code>XMSHORT4</code> instance specified by the <b>Short4</b> argument.

## -see-also

<a href="https://msdn.microsoft.com/49DAD98F-14D6-45B9-9D30-0EC553BB32EF">XMSHORT4</a>

<a href="https://msdn.microsoft.com/b57fbd3a-a483-44fe-8604-28dd50e92f8e">XMSHORT4 Operators</a>
