---
UID: NF:directxpackedvector.XMSHORTN2.operator-assign
title: XMSHORTN2::operator-assign (directxpackedvector.h)
description: Assigns the vector component data from one instance of XMSHORTN2 to the current instance of XMSHORTN2.
old-location: dxmath\xmshortn2_operator_eq.htm
tech.root: dxmath
ms.assetid: M:Microsoft.directx_sdk.reference.XMSHORTN2.operator = (const XMSHORTN2)
ms.date: 05/06/2019
ms.keywords: DirectX::PackedVector.XMSHORTN2.operator =, DirectX::PackedVector::XMSHORTN2::operator =, XMSHORTN2 structure [DirectX Math Support APIs],operator = method, XMSHORTN2.operator =, XMSHORTN2.operator-assign, XMSHORTN2.operator=, XMSHORTN2::operator-assign, XMSHORTN2::operator=, dxmath.xmshortn2_operator_eq, operator = method [DirectX Math Support APIs], operator = method [DirectX Math Support APIs],XMSHORTN2 structure, operator=
f1_keywords:
- directxpackedvector/XMSHORTN2.operator =
dev_langs:
- c++
req.header: directxpackedvector.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: DirectX::PackedVector
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- DirectXPackedVector.h
api_name:
- XMSHORTN2.operator =
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# XMSHORTN2::operator-assign

## -description

Assigns the vector component data from one instance of <code>XMSHORTN2</code> to the current instance of <code>XMSHORTN2</code>.

This operator assigns the vector component data from one instance of <a href="https://msdn.microsoft.com/DAE0ABD5-D2FD-40ED-8F0B-27A42C93508C">XMSHORTN2</a> to the current instance of <code>XMSHORTN2</code>.

<div class="alert"><b>Note</b>  This operator is only available for C++ based development.</div>

## -parameters

### -param arg1

Instance of <code>XMSHORTN2</code> used to update the current <code>XMSHORTN2</code>structure.

## -returns

The current instance of <code>XMSHORTN2</code> whose vector component data has been updated to match those of the <code>XMSHORTN2</code> instance specified by the <b>ShortN2</b> argument.

## -see-also

<a href="https://msdn.microsoft.com/DAE0ABD5-D2FD-40ED-8F0B-27A42C93508C">XMSHORTN2</a>

<a href="https://msdn.microsoft.com/69918b19-3dde-4c12-84f3-caac4f3e3c11">XMSHORTN2 Operators</a>
