---
UID: NF:directxpackedvector.XMUSHORT2.operator-assign(XMUSHORT2 &&)
title: XMUSHORT2::operator=
description: Assigns the vector component data from one instance of XMUSHORT2 to the current instance of XMUSHORT2.
ms.assetid: 0a966d6c-3091-48a5-8684-d586cd29d2fd
ms.date: 05/20/2019
ms.keywords: XMUSHORT2::operator=
f1_keywords:
- directxpackedvector/XMUSHORT2::operator=
dev_langs:
- c++
targetos: Windows
req.assembly: 
req.construct-type: function
req.ddi-compliance: 
req.dll: 
req.header: directxpackedvector.h
req.idl: 
req.include-header: 
req.irql: 
req.kmdf-ver: 
req.lib: 
req.max-support: 
req.namespace: 
req.redist: 
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.target-type: 
req.type-library: 
req.umdf-ver: 
req.unicode-ansi: 
topic_type:
- apiref
api_type:
- 
api_location:
- directxpackedvector.h
api_name:
- XMUSHORT2::operator=
---

# XMUSHORT2::operator = 

## -description

Assigns the vector component data from one instance of <a href="https://docs.microsoft.com/windows/desktop/api/directxpackedvector/ns-directxpackedvector-xmushort2">XMUSHORT2</a> to the current instance of **XMUSHORT2**.

This operator assigns the vector component data from one instance of **XMUSHORT2** to the current instance of **XMUSHORT2**.

<div class="alert"><b>Note</b>  This operator is only available under C++.</div>

## -parameters

### -param arg1

Instance of **XMUSHORT2** used to update the current **XMUSHORT2** structure.

## -returns

The current instance of **XMUSHORT2** whose vector component data has been updated to match those of the **XMUSHORT2** instance specified by the argument.

## -remarks

## -see-also

<a href="https://docs.microsoft.com/windows/desktop/api/directxpackedvector/ns-directxpackedvector-xmushort2">XMUSHORT2</a>
