---
UID: NF:directxpackedvector.XMUSHORT4.operator-assign(XMUSHORT4 &&)
title: XMUSHORT4::operator=
description: Assigns the vector component data from one instance of XMUSHORT4 to the current instance of XMUSHORT4.
ms.assetid: acc868e1-ad25-4ea9-b126-d5c50be8b888
ms.date: 05/20/2019
ms.keywords: XMUSHORT4::operator=
f1_keywords:
- directxpackedvector/XMUSHORT4::operator=
dev_langs:
- c++
targetos: Windows
req.assembly: 
req.construct-type: function
req.ddi-compliance: 
req.dll: 
req.header: directxpackedvector.h
req.idl: 
req.include-header: 
req.irql: 
req.kmdf-ver: 
req.lib: 
req.max-support: 
req.namespace: 
req.redist: 
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.target-type: 
req.type-library: 
req.umdf-ver: 
req.unicode-ansi: 
topic_type:
- apiref
api_type:
- 
api_location:
- directxpackedvector.h
api_name:
- XMUSHORT4::operator=
---

# XMUSHORT4::operator = 

## -description

Assigns the vector component data from one instance of <a href="https://docs.microsoft.com/windows/desktop/api/directxpackedvector/ns-directxpackedvector-xmushort4">XMUSHORT4</a> to the current instance of **XMUSHORT4**.

This operator assigns the vector component data from one instance of **XMUSHORT4** to the current instance of **XMUSHORT4**.

<div class="alert"><b>Note</b>  This operator is only available under C++.</div>

## -parameters

### -param arg1

Instance of **XMUSHORT4** used to update the current **XMUSHORT4** structure.

## -returns

The current instance of **XMUSHORT4** whose vector component data has been updated to match those of the **XMUSHORT4** instance specified by the argument.

## -remarks

## -see-also

<a href="https://docs.microsoft.com/windows/desktop/api/directxpackedvector/ns-directxpackedvector-xmushort4">XMUSHORT4</a>
