---
UID: NF:directxpackedvector.XMXDEC4.operator-assign(XMXDEC4 &&)
title: XMXDEC4::operator=
description: Assigns the vector component data from one instance of XMXDEC4 to the current instance of XMXDEC4.
ms.assetid: c5472b9e-619f-4760-9db6-54cd191e5007
ms.date: 05/20/2019
ms.keywords: XMXDEC4::operator=
f1_keywords:
- directxpackedvector/XMXDEC4::operator=
dev_langs:
- c++
targetos: Windows
req.assembly: 
req.construct-type: function
req.ddi-compliance: 
req.dll: 
req.header: directxpackedvector.h
req.idl: 
req.include-header: 
req.irql: 
req.kmdf-ver: 
req.lib: 
req.max-support: 
req.namespace: 
req.redist: 
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.target-type: 
req.type-library: 
req.umdf-ver: 
req.unicode-ansi: 
topic_type:
- apiref
api_type:
- 
api_location:
- directxpackedvector.h
api_name:
- XMXDEC4::operator=
---

# XMXDEC4::operator =  (const XMXDEC4&)

## -description

Assigns the vector component data from one instance of <a href="https://docs.microsoft.com/windows/desktop/api/directxpackedvector/ns-directxpackedvector-xmxdec4">XMXDEC4</a> to the current instance of **XMXDEC4**.

This operator assigns the vector component data from one instance of **XMXDEC4** to the current instance of **XMXDEC4**.

<div class="alert"><b>Note</b>  This operator is only available under C++.</div>

## -parameters

### -param arg1

Instance of **XMXDEC4** used to update the current **XMXDEC4** structure.

## -returns

The current instance of **XMXDEC4** whose vector component data has been updated to match those of the **XMXDEC4** instance specified by the *XDec4* argument.

## -remarks

## -see-also

<a href="https://docs.microsoft.com/windows/desktop/api/directxpackedvector/ns-directxpackedvector-xmxdec4">XMXDEC4</a>

<a href="https://msdn.microsoft.com/07952c7d-0d87-4c93-9a91-d72c702c6200">operator = </a>
