---
UID: NF:directxpackedvector.XMXDECN4.operator-assign(XMXDECN4 &&)
title: XMXDECN4::operator-assign(XMXDECN4 &&) (directxpackedvector.h)
description: Assigns the vector component data from one instance of XMXDECN4 to the current instance of XMXDECN4.
old-location: dxmath\xmxdecn4_operator_eq_1.htm
tech.root: dxmath
ms.assetid: M:Microsoft.directx_sdk.reference.XMXDECN4.operator = (const XMXDECN4)
ms.date: 05/06/2019
ms.keywords: XMXDECN4 structure [DirectX Math Support APIs],operator = method, XMXDECN4.operator =(const XMXDECN4&), XMXDECN4.operator-assign(XMXDECN4 &&), XMXDECN4.operator=, XMXDECN4::operator-assign(XMXDECN4 &&), XMXDECN4::operator=, dxmath.xmxdecn4_operator_eq_1, operator = method [DirectX Math Support APIs], operator = method [DirectX Math Support APIs],XMXDECN4 structure, operator=
f1_keywords:
- directxpackedvector/XMXDECN4.operator =
dev_langs:
- c++
req.header: directxpackedvector.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: DirectX::PackedVector
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- DirectXPackedVector.h
api_name:
- XMXDECN4.operator =
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# XMXDECN4::operator-assign(XMXDECN4 &&)

## -description

Assigns the vector component data from one instance of <code>XMXDECN4</code> to the current instance of <code>XMXDECN4</code>.

<div class="alert"><b>Note</b>  This operator is only available under C++.</div>

## -parameters

### -param arg1

Instance of <code>XMXDECN4</code> used to update the current <code>XMXDECN4</code>structure.

## -returns

The current instance of <code>XMXDECN4</code> whose vector component data has been updated to match those of the <code>XMXDECN4</code> instance specified by the <b>XDecN4</b> argument.

## -see-also

<a href="https://docs.microsoft.com/en-us/windows/desktop/api/directxpackedvector/ns-directxpackedvector-xmxdecn4">XMXDECN4</a>

<a href="https://msdn.microsoft.com/d60f196b-281a-428c-bdae-f2d4ad1e206d">operator = </a>
