---
UID: NE:docobj.OLECMDID
title: OLECMDID (docobj.h)
description: Specifies which standard command is to be executed. A single value from this enumeration is passed in the nCmdID argument of IOleCommandTarget::Exec.
old-location: com\olecmdid.htm
tech.root: com
ms.assetid: ae1592b6-2afd-4379-a18e-d46b226bc9e2
ms.date: 12/05/2018
ms.keywords: OLECMDID, OLECMDID enumeration [COM], OLECMDID_ACTIVEXINSTALLSCOPE, OLECMDID_ADDTRAVELENTRY, OLECMDID_ALLOWUILESSSAVEAS, OLECMDID_CLEARSELECTION, OLECMDID_CLOSE, OLECMDID_COPY, OLECMDID_CUT, OLECMDID_DELETE, OLECMDID_DONTDOWNLOADCSS, OLECMDID_ENABLE_INTERACTION, OLECMDID_FIND, OLECMDID_FOCUSVIEWCONTROLS, OLECMDID_FOCUSVIEWCONTROLSQUERY, OLECMDID_GETPRINTTEMPLATE, OLECMDID_GETZOOMRANGE, OLECMDID_HIDETOOLBARS, OLECMDID_HTTPEQUIV, OLECMDID_HTTPEQUIV_DONE, OLECMDID_NEW, OLECMDID_ONTOOLBARACTIVATED, OLECMDID_ONUNLOAD, OLECMDID_OPEN, OLECMDID_OPTICAL_GETZOOMRANGE, OLECMDID_OPTICAL_ZOOM, OLECMDID_PAGEACTIONBLOCKED, OLECMDID_PAGEACTIONUIQUERY, OLECMDID_PAGESETUP, OLECMDID_PASTE, OLECMDID_PASTESPECIAL, OLECMDID_PREREFRESH, OLECMDID_PRINT, OLECMDID_PRINT2, OLECMDID_PRINTPREVIEW, OLECMDID_PRINTPREVIEW2, OLECMDID_PROPERTIES, OLECMDID_PROPERTYBAG2, OLECMDID_REDO, OLECMDID_REFRESH, OLECMDID_SAVE, OLECMDID_SAVEAS, OLECMDID_SAVECOPYAS, OLECMDID_SELECTALL, OLECMDID_SETDOWNLOADSTATE, OLECMDID_SETPRINTTEMPLATE, OLECMDID_SETPROGRESSMAX, OLECMDID_SETPROGRESSPOS, OLECMDID_SETPROGRESSTEXT, OLECMDID_SETTITLE, OLECMDID_SHOWFIND, OLECMDID_SHOWMESSAGE, OLECMDID_SHOWPAGEACTIONMENU, OLECMDID_SHOWPAGESETUP, OLECMDID_SHOWPRINT, OLECMDID_SHOWSCRIPTERROR, OLECMDID_SPELL, OLECMDID_STOP, OLECMDID_STOPDOWNLOAD, OLECMDID_UNDO, OLECMDID_UPDATEBACKFORWARDSTATE, OLECMDID_UPDATECOMMANDS, OLECMDID_UPDATEPAGESTATUS, OLECMDID_UPDATETRAVELENTRY, OLECMDID_UPDATETRAVELENTRY_DATARECOVERY, OLECMDID_WINDOWSTATECHANGED, OLECMDID_ZOOM, _ole_OLECMDID, com.olecmdid, docobj/OLECMDID, docobj/OLECMDID_ACTIVEXINSTALLSCOPE, docobj/OLECMDID_ADDTRAVELENTRY, docobj/OLECMDID_ALLOWUILESSSAVEAS, docobj/OLECMDID_CLEARSELECTION, docobj/OLECMDID_CLOSE, docobj/OLECMDID_COPY, docobj/OLECMDID_CUT, docobj/OLECMDID_DELETE, docobj/OLECMDID_DONTDOWNLOADCSS, docobj/OLECMDID_ENABLE_INTERACTION, docobj/OLECMDID_FIND, docobj/OLECMDID_FOCUSVIEWCONTROLS, docobj/OLECMDID_FOCUSVIEWCONTROLSQUERY, docobj/OLECMDID_GETPRINTTEMPLATE, docobj/OLECMDID_GETZOOMRANGE, docobj/OLECMDID_HIDETOOLBARS, docobj/OLECMDID_HTTPEQUIV, docobj/OLECMDID_HTTPEQUIV_DONE, docobj/OLECMDID_NEW, docobj/OLECMDID_ONTOOLBARACTIVATED, docobj/OLECMDID_ONUNLOAD, docobj/OLECMDID_OPEN, docobj/OLECMDID_OPTICAL_GETZOOMRANGE, docobj/OLECMDID_OPTICAL_ZOOM, docobj/OLECMDID_PAGEACTIONBLOCKED, docobj/OLECMDID_PAGEACTIONUIQUERY, docobj/OLECMDID_PAGESETUP, docobj/OLECMDID_PASTE, docobj/OLECMDID_PASTESPECIAL, docobj/OLECMDID_PREREFRESH, docobj/OLECMDID_PRINT, docobj/OLECMDID_PRINT2, docobj/OLECMDID_PRINTPREVIEW, docobj/OLECMDID_PRINTPREVIEW2, docobj/OLECMDID_PROPERTIES, docobj/OLECMDID_PROPERTYBAG2, docobj/OLECMDID_REDO, docobj/OLECMDID_REFRESH, docobj/OLECMDID_SAVE, docobj/OLECMDID_SAVEAS, docobj/OLECMDID_SAVECOPYAS, docobj/OLECMDID_SELECTALL, docobj/OLECMDID_SETDOWNLOADSTATE, docobj/OLECMDID_SETPRINTTEMPLATE, docobj/OLECMDID_SETPROGRESSMAX, docobj/OLECMDID_SETPROGRESSPOS, docobj/OLECMDID_SETPROGRESSTEXT, docobj/OLECMDID_SETTITLE, docobj/OLECMDID_SHOWFIND, docobj/OLECMDID_SHOWMESSAGE, docobj/OLECMDID_SHOWPAGEACTIONMENU, docobj/OLECMDID_SHOWPAGESETUP, docobj/OLECMDID_SHOWPRINT, docobj/OLECMDID_SHOWSCRIPTERROR, docobj/OLECMDID_SPELL, docobj/OLECMDID_STOP, docobj/OLECMDID_STOPDOWNLOAD, docobj/OLECMDID_UNDO, docobj/OLECMDID_UPDATEBACKFORWARDSTATE, docobj/OLECMDID_UPDATECOMMANDS, docobj/OLECMDID_UPDATEPAGESTATUS, docobj/OLECMDID_UPDATETRAVELENTRY, docobj/OLECMDID_UPDATETRAVELENTRY_DATARECOVERY, docobj/OLECMDID_WINDOWSTATECHANGED, docobj/OLECMDID_ZOOM
f1_keywords:
- docobj/OLECMDID
dev_langs:
- c++
req.header: docobj.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- DocObj.h
api_name:
- OLECMDID
targetos: Windows
req.typenames: OLECMDID
req.redist: 
ms.custom: 19H1
---

# OLECMDID enumeration


## -description


Specifies which standard command is to be executed. A single value from this enumeration is passed in the <i>nCmdID</i> argument of <a href="https://docs.microsoft.com/windows/desktop/api/docobj/nf-docobj-iolecommandtarget-exec">IOleCommandTarget::Exec</a>.




## -enum-fields




### -field OLECMDID_OPEN

<b>File</b> menu, <b>Open</b> command


### -field OLECMDID_NEW

<b>File</b> menu, <b>New</b> command


### -field OLECMDID_SAVE

<b>File</b> menu, <b>Save</b> command


### -field OLECMDID_SAVEAS

<b>File</b> menu, <b>Save As</b> command


### -field OLECMDID_SAVECOPYAS

<b>File</b> menu, <b>Save Copy As</b> command


### -field OLECMDID_PRINT

<b>File</b> menu, <b>Print</b> command


### -field OLECMDID_PRINTPREVIEW

<b>File</b> menu, <b>Print Preview</b> command


### -field OLECMDID_PAGESETUP

<b>File</b> menu, <b>Page Setup</b> command


### -field OLECMDID_SPELL

<b>Tools</b> menu, <b>Spelling</b> command


### -field OLECMDID_PROPERTIES

<b>File</b> menu, <b>Properties</b> command


### -field OLECMDID_CUT

<b>Edit</b> menu, <b>Cut</b> command


### -field OLECMDID_COPY

<b>Edit</b> menu, <b>Copy</b> command


### -field OLECMDID_PASTE

<b>Edit</b> menu, <b>Paste</b> command


### -field OLECMDID_PASTESPECIAL

<b>Edit</b> menu, <b>Paste Special</b> command


### -field OLECMDID_UNDO

<b>Edit</b> menu, <b>Undo</b> command


### -field OLECMDID_REDO

<b>Edit</b> menu, <b>Redo</b> command


### -field OLECMDID_SELECTALL

<b>Edit</b> menu, <b>Select All</b> command


### -field OLECMDID_CLEARSELECTION

<b>Edit</b> menu, <b>Clear</b> command


### -field OLECMDID_ZOOM

<b>View</b> menu, <b>Zoom</b> command (see below for details.)


### -field OLECMDID_GETZOOMRANGE

Retrieves zoom range applicable to <b>View Zoom</b> (see below for details.)


### -field OLECMDID_UPDATECOMMANDS

Informs the receiver, usually a frame, of state changes. The receiver can then query the status of the commands whenever convenient. 


### -field OLECMDID_REFRESH

Asks the receiver to refresh its display. Implemented by the document/object.


### -field OLECMDID_STOP

Stops all current processing. Implemented by the document/object.


### -field OLECMDID_HIDETOOLBARS

<b>View</b> menu, <b>Toolbars</b> command. Implemented by the document/object to hide its toolbars. 


### -field OLECMDID_SETPROGRESSMAX

Sets the maximum value of a progress indicator if one is owned by the receiving object, usually a frame. The minimum value is always zero. 


### -field OLECMDID_SETPROGRESSPOS

Sets the current value of a progress indicator if one is owned by the receiving object, usually a frame. 


### -field OLECMDID_SETPROGRESSTEXT

Sets the text contained in a progress indicator if one is owned by the receiving object, usually a frame. If the receiver currently has no progress indicator, this text should be displayed in the status bar (if one exists) as with <a href="https://docs.microsoft.com/windows/desktop/api/oleidl/nf-oleidl-ioleinplaceframe-setstatustext">IOleInPlaceFrame::SetStatusText</a>.


### -field OLECMDID_SETTITLE

Sets the title bar text of the receiving object, usually a frame. 


### -field OLECMDID_SETDOWNLOADSTATE

Called by the object when downloading state changes. Takes a VT_BOOL parameter, which is <b>TRUE</b> if the object is downloading data and <b>FALSE</b> if it not. Primarily implemented by the frame. 


### -field OLECMDID_STOPDOWNLOAD

Stops the download when executed. Typically, this command is propagated to all contained objects. When queried, sets MSOCMDF_ENABLED. Implemented by the document/object. 


### -field OLECMDID_ONTOOLBARACTIVATED


### -field OLECMDID_FIND

<b>Edit</b> menu, <b>Find</b> command


### -field OLECMDID_DELETE

<b>Edit</b> menu, <b>Delete</b> command


### -field OLECMDID_HTTPEQUIV

Issued in response to <b>HTTP-EQUIV</b> metatag and results in a call to the deprecated <a href="https://docs.microsoft.com/windows/desktop/api/shdeprecated/nf-shdeprecated-ibrowserservice-onhttpequiv">OnHttpEquiv</a> method with the <i>fDone</i> parameter set to <b>false</b>. This command takes a <b>VT_BSTR</b> parameter which is passed to <b>OnHttpEquiv</b>.


### -field OLECMDID_HTTPEQUIV_DONE

Issued in response to <b>HTTP-EQUIV</b> metatag and results in a call to the deprecated <a href="https://docs.microsoft.com/windows/desktop/api/shdeprecated/nf-shdeprecated-ibrowserservice-onhttpequiv">OnHttpEquiv</a> method with the <i>fDone</i> parameter set to <b>true</b>. This command takes a <b>VT_BSTR</b> parameter which is passed to <b>OnHttpEquiv</b>.


### -field OLECMDID_ENABLE_INTERACTION

Pauses or resumes receiver interaction. This command takes a <b>VT_BOOL</b> parameter that pauses interaction when set to <b>FALSE</b> and resumes interaction when set to <b>TRUE</b>.


### -field OLECMDID_ONUNLOAD

Notifies the receiver of an intent to close the window imminently. This command takes a <b>VT_BOOL</b> output parameter that returns <b>TRUE</b> if the receiver can close and <b>FALSE</b> if it can't.


### -field OLECMDID_PROPERTYBAG2

This command has no effect.


### -field OLECMDID_PREREFRESH

Notifies the receiver that a refresh is about to start.


### -field OLECMDID_SHOWSCRIPTERROR

Tells the receiver to display the script error message.


### -field OLECMDID_SHOWMESSAGE

This command takes an <a href="https://docs.microsoft.com/previous-versions/hh773930(v=vs.85)">IHTMLEventObj</a> input parameter that  contains a  message that the receiver shows.


### -field OLECMDID_SHOWFIND

Tells the receiver to show the Find dialog box. It takes a <b>VT_DISPATCH</b> input param.


### -field OLECMDID_SHOWPAGESETUP

Tells the receiver to show the Page Setup dialog box. It takes an <a href="https://docs.microsoft.com/previous-versions/hh773930(v=vs.85)">IHTMLEventObj2</a>  input parameter.


### -field OLECMDID_SHOWPRINT

Tells the receiver to show the Print dialog box. It takes an <a href="https://docs.microsoft.com/previous-versions/hh773930(v=vs.85)">IHTMLEventObj2</a>  input parameter.


### -field OLECMDID_CLOSE

The exit command for the File menu.


### -field OLECMDID_ALLOWUILESSSAVEAS

Supports the <a href="https://docs.microsoft.com/windows/desktop/api/docobj/nf-docobj-iolecommandtarget-querystatus">QueryStatus</a> method.


### -field OLECMDID_DONTDOWNLOADCSS

Notifies the  receiver that CSS files should not be downloaded when in <a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nn-shobjidl_core-iapplicationdesignmodesettings">DesignMode</a>.


### -field OLECMDID_UPDATEPAGESTATUS

This command has no effect.


### -field OLECMDID_PRINT2

<b>File</b> menu, updated <b>Print</b> command


### -field OLECMDID_PRINTPREVIEW2

<b>File</b> menu, updated <b>Print Preview</b> command


### -field OLECMDID_SETPRINTTEMPLATE

Sets an explicit Print Template value of <b>TRUE</b> or <b>FALSE</b>, based on a <b>VT_BOOL</b> input parameter.


### -field OLECMDID_GETPRINTTEMPLATE

Gets a  <b>VT_BOOL</b> output parameter indicating whether the Print Template value is <b>TRUE</b> or <b>FALSE</b>.


### -field OLECMDID_PAGEACTIONBLOCKED

Indicates that a page action has been blocked. PAGEACTIONBLOCKED is designed for use with applications that host the Internet Explorer WebBrowser control to implement their own UI.


### -field OLECMDID_PAGEACTIONUIQUERY

Specifies which actions are displayed in the Internet Explorer notification band.


### -field OLECMDID_FOCUSVIEWCONTROLS

Causes the Internet Explorer WebBrowser control to focus its default notification band. Hosts can send this command at any time. The return value is S_OK if the band is present and is in focus, or S_FALSE otherwise.


### -field OLECMDID_FOCUSVIEWCONTROLSQUERY

This notification event is provided for applications that display Internet Explorers default notification band implementation. By default, when the user presses the ALT-N key combination, Internet Explorer treats it as a request to focus the notification band.


### -field OLECMDID_SHOWPAGEACTIONMENU

Causes the Internet Explorer WebBrowser control to show the Information Bar menu.


### -field OLECMDID_ADDTRAVELENTRY

Causes the Internet Explorer WebBrowser control to create an entry at the current Travel Log offset. The Docobject should implement <a href="http://go.microsoft.com/fwlink/p/?LinkID=144763">ITravelLogClient</a> and <a href="https://docs.microsoft.com/windows/desktop/api/objidl/nn-objidl-ipersist">IPersist</a> interfaces, which are used by the Travel Log as it processes this command with calls to GetWindowData and GetPersistID, respectively.


### -field OLECMDID_UPDATETRAVELENTRY

Called when LoadHistory is processed to update the previous Docobject state. For synchronous handling, this command can be called before returning from the LoadHistory call. For asynchronous handling, it can be called later.


### -field OLECMDID_UPDATEBACKFORWARDSTATE

Updates the state of the browser's Back and Forward buttons.


### -field OLECMDID_OPTICAL_ZOOM

Windows Internet Explorer 7 and later. Sets the zoom factor of the browser. Takes a VT_I4 parameter in the range of 10 to 1000 (percent).


### -field OLECMDID_OPTICAL_GETZOOMRANGE

Windows Internet Explorer 7 and later. Retrieves the minimum and maximum browser zoom factor limits. Returns a VT_I4 parameter; the LOWORD is the minimum zoom factor, the HIWORD is the maximum.


### -field OLECMDID_WINDOWSTATECHANGED

Windows Internet Explorer 7 and later. Notifies the Internet Explorer WebBrowser control of changes in window states, such as losing focus, or becoming hidden or minimized. The host indicates what has changed by setting OLECMDID_WINDOWSTATE_FLAG option flags in nCmdExecOpt.


### -field OLECMDID_ACTIVEXINSTALLSCOPE

Windows Internet Explorer 8 with Windows Vista. Has no effect with Windows Internet Explorer 8 with Windows XP. Notifies Trident to use the indicated Install Scope to install the ActiveX Control specified by the indicated Class ID. For more information, see the Remarks section.


### -field OLECMDID_UPDATETRAVELENTRY_DATARECOVERY

Internet Explorer 8. Unlike OLECMDID_UPDATETRAVELENTRY, this updates a Travel Log entry that is not initialized from a previous Docobject state. While this command is not called from <a href="https://docs.microsoft.com/previous-versions/windows/internet-explorer/ie-developer/platform-apis/aa768216(v=vs.85)">IPersistHistory::LoadHistory</a>, it can be called separately to save browser state that can be used later to recover from a crash.


### -field OLECMDID_SHOWTASKDLG


### -field OLECMDID_POPSTATEEVENT


### -field OLECMDID_VIEWPORT_MODE


### -field OLECMDID_LAYOUT_VIEWPORT_WIDTH


### -field OLECMDID_VISUAL_VIEWPORT_EXCLUDE_BOTTOM


### -field OLECMDID_USER_OPTICAL_ZOOM


### -field OLECMDID_PAGEAVAILABLE


### -field OLECMDID_GETUSERSCALABLE


### -field OLECMDID_UPDATE_CARET


### -field OLECMDID_ENABLE_VISIBILITY


### -field OLECMDID_MEDIA_PLAYBACK


### -field OLECMDID_SETFAVICON


### -field OLECMDID_SET_HOST_FULLSCREENMODE


### -field OLECMDID_EXITFULLSCREEN


### -field OLECMDID_SCROLLCOMPLETE


### -field OLECMDID_ONBEFOREUNLOAD


### -field OLECMDID_SHOWMESSAGE_BLOCKABLE


### -field OLECMDID_SHOWTASKDLG_BLOCKABLE




## -remarks



In OLE Compound Documents technology, an object that is being edited in-place disables the <b>Zoom</b> control on its toolbar and the <b>Zoom</b> command on its <b>View</b> menu, because, the <b>Zoom</b> command applies logically to the container document, not to the object. The OLECMDID_ZOOM and OLECMDID_GETZOOMRANGE commands notify the container's frame object of the zoom range it should use to display a document object in its user interface. The container frame is the client-side object that implements <a href="https://docs.microsoft.com/windows/desktop/api/oleidl/nn-oleidl-ioleinplaceframe">IOleInPlaceFrame</a> and, optionally, <a href="https://docs.microsoft.com/windows/desktop/api/docobj/nn-docobj-iolecommandtarget">IOleCommandTarget</a>.



The OLECMDID_ZOOM command takes one <b>LONG</b> argument as input and writes one <b>LONG</b> argument on output. This command is used for three purposes: 



<ul>
<li>To query the current zoom value. The caller of <a href="https://docs.microsoft.com/windows/desktop/api/docobj/nf-docobj-iolecommandtarget-exec">IOleCommandTarget::Exec</a> passes OLECMDEXECOPT_DONTPROMPTUSER as the execute option in <i>nCmdExecOpt</i> and <b>NULL</b> for pvIn. The object returns the current zoom value in <i>pvaOut</i>. When the object goes UI active, it retrieves the current zoom value from the container's frame object using this same mechanism and updates its zoom control with the returned value. 
</li>
<li>To display the <b>Zoom</b> dialog box. The caller of <a href="https://docs.microsoft.com/windows/desktop/api/docobj/nf-docobj-iolecommandtarget-exec">IOleCommandTarget::Exec</a> passes OLECMDEXECOPT_PROMPTUSER in <i>nCmdExecOpt</i>. The caller can optionally pass the initial value for the dialog box through <i>pvaIn</i>; otherwise <i>pvaIn</i> must be <b>NULL</b>. If the user clicks <b>Cancel</b>, the object returns OLECMDERR_E_CANCELED. If the user clicks <b>OK</b>, the object passes the user-selected value in <i>pvaOut</i>. When user chooses the <b>Zoom</b> command from the <b>View</b> menu, the object calls the container's frame object in the same manner. The container then zooms the document to the user selected value, and the object updates its <b>Zoom</b> control with that value.
</li>
<li>To set a <b>Zoom</b> value. The caller of <a href="https://docs.microsoft.com/windows/desktop/api/docobj/nf-docobj-iolecommandtarget-exec">IOleCommandTarget::Exec</a> passes OLECMDEXECOPT_DONTPROMPTUSER in <i>nCmdExecOpt</i> and passes the zoom value to apply through <i>pvaIn</i>. The object validates and normalizes the new value and returns the validated value in <i>pvaOut</i>. When the user selects a new zoom value (using the <b>Zoom</b> control on the toolbar, for instance), the object calls the container's frame object in this manner. The container zooms the document to 100 percent, and the object updates the <b>Zoom</b> control with that value.</li>
</ul>
The OLECMDID_GETZOOMRANGE command is used to determine the range of valid zoom values from an object that implements <a href="https://docs.microsoft.com/windows/desktop/api/docobj/nn-docobj-iolecommandtarget">IOleCommandTarget</a>. The caller passes MSOCMDEXECOPT_DONTPROMPTUSER in nCmdExecOpt and <b>NULL</b> for <i>pvaIn</i>. The object returns its zoom range in <i>pvaOut</i> where the HIWORD contains the maximum zoom value and the LOWORD contains the minimum zoom value. Typically this command is used when the user drops down the <b>Zoom</b> control on the toolbar of the UI-active object. The applications and objects that support this command are required to support all the integral zoom values that are within the (min,max) pair they return.



The OLECMDID_ACTIVEXINSTALLSCOPE command notifies Trident to use the indicated Install Scope to install the ActiveX Control specified by the indicated class ID. The Install Scope is passed in a VT_ARRAY in pvaIn of the <a href="https://docs.microsoft.com/windows/desktop/api/docobj/nf-docobj-iolecommandtarget-exec">IOleCommandTarget::Exec</a> method whose elements are as follows.

<table>
<tr>
<th>Data</th>
<th>VARIANT Type</th>
<th>Index</th>
</tr>
<tr>
<td>Class ID</td>
<td>VT_BSTR</td>
<td>0</td>
</tr>
<tr>
<td>Install Scope</td>
<td>VT_UI4</td>
<td>1</td>
</tr>
</table>
 

The Install Scope must be one of the following values.

<table>
<tr>
<th>Value</th>
<th>Description</th>
</tr>
<tr>
<td>INSTALL_SCOPE_USERS</td>
<td>The ActiveX control should register to HKCU and for the instant user only.
</td>
</tr>
<tr>
<td>INSTALL_SCOPE_MACHINE</td>
<td>The ActiveX control should register to HKLM and across the computer
</td>
</tr>
</table>
 

The following is an example use of the OLECMDID_ACTIVEXINSTALLSCOPE command.


```cpp
IOleCommandTarget::Exec(
NULL, // Pointer to command group
OLECMDARGINDEX_ACTIVEXINSTALL_INSTALLSCOPE, // ID of command to execute
NULL, // Options
&varArgs, // pvain pointer to input arguments
NULL) // pointer to command output

```





## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/docobj/nn-docobj-iolecommandtarget">IOleCommandTarget</a>



<a href="https://docs.microsoft.com/windows/desktop/api/docobj/nf-docobj-iolecommandtarget-exec">IOleCommandTarget::Exec</a>



<a href="https://docs.microsoft.com/windows/desktop/api/oleidl/nn-oleidl-ioleinplaceframe">IOleInPlaceFrame</a>
 

 

