---
UID: NE:dot1x._ONEX_REASON_CODE
title: ONEX_REASON_CODE (dot1x.h)
description: Specifies the possible values that indicate the reason that 802.1X authentication failed.
old-location: nwifi\onex_reason_code.htm
tech.root: NativeWiFi
ms.assetid: 9ce6ff56-946c-4058-b9a6-33dab4124c24
ms.date: 12/05/2018
ms.keywords: ONEX_AUTHENTICATOR_NO_LONGER_PRESENT, ONEX_EAP_FAILURE_RECEIVED, ONEX_IDENTITY_NOT_FOUND, ONEX_NO_RESPONSE_TO_IDENTITY, ONEX_PROFILE_DISALLOWED_EAP_TYPE, ONEX_PROFILE_EXPIRED_EXPLICIT_CREDENTIALS, ONEX_PROFILE_INVALID_AUTH_MODE, ONEX_PROFILE_INVALID_EAP_CONNECTION_PROPERTIES, ONEX_PROFILE_INVALID_EAP_TYPE_OR_FLAG, ONEX_PROFILE_INVALID_EXPLICIT_CREDENTIALS, ONEX_PROFILE_INVALID_LENGTH, ONEX_PROFILE_INVALID_ONEX_FLAGS, ONEX_PROFILE_INVALID_SUPPLICANT_MODE, ONEX_PROFILE_INVALID_TIMER_VALUE, ONEX_PROFILE_VERSION_NOT_SUPPORTED, ONEX_REASON_CODE, ONEX_REASON_CODE enumeration [NativeWIFI], ONEX_REASON_CODE_SUCCESS, ONEX_REASON_START, ONEX_UI_CANCELLED, ONEX_UI_DISABLED, ONEX_UI_FAILURE, ONEX_UI_NOT_PERMITTED, ONEX_UNABLE_TO_IDENTIFY_USER, PONEX_REASON_CODE, PONEX_REASON_CODE enumeration pointer [NativeWIFI], dot1x/ONEX_AUTHENTICATOR_NO_LONGER_PRESENT, dot1x/ONEX_EAP_FAILURE_RECEIVED, dot1x/ONEX_IDENTITY_NOT_FOUND, dot1x/ONEX_NO_RESPONSE_TO_IDENTITY, dot1x/ONEX_PROFILE_DISALLOWED_EAP_TYPE, dot1x/ONEX_PROFILE_EXPIRED_EXPLICIT_CREDENTIALS, dot1x/ONEX_PROFILE_INVALID_AUTH_MODE, dot1x/ONEX_PROFILE_INVALID_EAP_CONNECTION_PROPERTIES, dot1x/ONEX_PROFILE_INVALID_EAP_TYPE_OR_FLAG, dot1x/ONEX_PROFILE_INVALID_EXPLICIT_CREDENTIALS, dot1x/ONEX_PROFILE_INVALID_LENGTH, dot1x/ONEX_PROFILE_INVALID_ONEX_FLAGS, dot1x/ONEX_PROFILE_INVALID_SUPPLICANT_MODE, dot1x/ONEX_PROFILE_INVALID_TIMER_VALUE, dot1x/ONEX_PROFILE_VERSION_NOT_SUPPORTED, dot1x/ONEX_REASON_CODE, dot1x/ONEX_REASON_CODE_SUCCESS, dot1x/ONEX_REASON_START, dot1x/ONEX_UI_CANCELLED, dot1x/ONEX_UI_DISABLED, dot1x/ONEX_UI_FAILURE, dot1x/ONEX_UI_NOT_PERMITTED, dot1x/ONEX_UNABLE_TO_IDENTIFY_USER, dot1x/PONEX_REASON_CODE, nwifi.onex_reason_code
f1_keywords:
- dot1x/ONEX_REASON_CODE
dev_langs:
- c++
req.header: dot1x.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- dot1x.h
api_name:
- ONEX_REASON_CODE
targetos: Windows
req.typenames: ONEX_REASON_CODE, PONEX_REASON_CODE
req.redist: 
ms.custom: 19H1
---

# ONEX_REASON_CODE enumeration


## -description


The <b>ONEX_REASON_CODE</b> enumerated type specifies the possible values that indicate the reason that 802.1X authentication failed.



## -enum-fields




### -field ONEX_REASON_CODE_SUCCESS

Indicates the 802.1X authentication was a success.


### -field ONEX_REASON_START

Indicates the start of the range that specifies the possible values for 802.1X reason code.


### -field ONEX_UNABLE_TO_IDENTIFY_USER

The 802.1X module was unable to identify a set of credentials to be used. An example is when the authentication mode is set to user, but no user is logged on. 


### -field ONEX_IDENTITY_NOT_FOUND

The EAP module was unable to acquire an identity for the user. Thus value is not currently used. All EAP-specific errors are returned as <b>ONEX_EAP_FAILURE_RECEIVED</b>. 


### -field ONEX_UI_DISABLED

To proceed with 802.1X authentication, the system needs to request user input, but the user interface is disabled. On Windows Vista and on Windows Server 2008, this value can be returned if an EAP method requested user input for a profile for Guest or local machine authentication. On Windows 7 and on Windows Server 2008 R2 with the Wireless LAN Service installed, this value should not be returned.


### -field ONEX_UI_FAILURE

The 802.1X authentication module was unable to return the requested user input. On Windows 7 and on Windows Server 2008 R2 with the Wireless LAN Service installed, this value can be returned if an EAP method requested user input, but the UI could not be displayed (the network icon was configured to not show in the taskbar, for example). 


### -field ONEX_EAP_FAILURE_RECEIVED

The EAP module returned an error code.  The <a href="https://docs.microsoft.com/windows/desktop/api/dot1x/ns-dot1x-onex_eap_error">ONEX_EAP_ERROR</a> structure may contain additional information about the specific EAP error (a certificate not found, for example).


### -field ONEX_AUTHENTICATOR_NO_LONGER_PRESENT

The peer with which the 802.1X module was negotiating is no longer present or is not responding (a laptop client moved out of range of the wireless access point, for example).


### -field ONEX_NO_RESPONSE_TO_IDENTITY

No response was received to an EAP identity response packet. This value indicates a problem with the infrastructure (a link between the wireless access point and the authentication server is not functioning, for example).


### -field ONEX_PROFILE_VERSION_NOT_SUPPORTED

The 802.1X module does not support this version of the profile. 


### -field ONEX_PROFILE_INVALID_LENGTH

The length member specified in the 802.1X profile is invalid.


### -field ONEX_PROFILE_DISALLOWED_EAP_TYPE

The EAP type specified in the 802.1X profile is not allowed for this media. An example is when the keyed MD5 algorithm is used for wireless transmission.


### -field ONEX_PROFILE_INVALID_EAP_TYPE_OR_FLAG

The EAP type or EAP flags specified in the 802.1X profile are not valid. An example is when EAP type is not installed on the system.


### -field ONEX_PROFILE_INVALID_ONEX_FLAGS

The 802.1X flags specified in the 802.1X profile are not valid.


### -field ONEX_PROFILE_INVALID_TIMER_VALUE

One or more timer values specified in the 802.1X profile is out of its valid range.


### -field ONEX_PROFILE_INVALID_SUPPLICANT_MODE

The supplicant mode specified in the 802.1X profile is not valid.


### -field ONEX_PROFILE_INVALID_AUTH_MODE

The authentication mode specified in the 802.1X profile is not valid. 


### -field ONEX_PROFILE_INVALID_EAP_CONNECTION_PROPERTIES

The EAP connection properties specified in the 802.1X profile are not valid. 


### -field ONEX_UI_CANCELLED

User input was canceled. This value can be returned if an EAP method requested user input, but the user hit the Cancel button or dismissed the user input dialog.

This value is supported on Windows 7 and on Windows Server 2008 R2 with the Wireless LAN Service installed.


### -field ONEX_PROFILE_INVALID_EXPLICIT_CREDENTIALS

The saved user credentials are not valid.  This value can be returned if a profile was saved with bad credentials (an incorrect password, for example), since the credentials are not tested until the profile is actually used to establish a connection.  

This value is supported on Windows 7 and on Windows Server 2008 R2 with the Wireless LAN Service installed.


### -field ONEX_PROFILE_EXPIRED_EXPLICIT_CREDENTIALS

The saved user credentials have expired. This value can be returned if a profile was saved with credentials and the credentials subsequently expired (password expirarion after some period of time, for example).

This value is supported on Windows 7 and on Windows Server 2008 R2 with the Wireless LAN Service installed.


### -field ONEX_UI_NOT_PERMITTED

User interface is not permitted. On Windows 7 and on Windows Server 2008 R2 with the Wireless LAN Service installed, this value can be returned if an EAP method requested user input and the profile is configured with user credentials saved by another user and not the currently logged in user.

This value is supported on Windows 7 and on Windows Server 2008 R2 with the Wireless LAN Service installed.


## -remarks



The <b>ONEX_REASON_CODE</b> enumerated type is used by the 802.1X module, a new wireless configuration component supported on Windows Vista and  later.  

The <a href="https://docs.microsoft.com/windows/desktop/api/dot1x/ns-dot1x-onex_result_update_data">ONEX_RESULT_UPDATE_DATA</a> contains information on a status change to 802.1X authentication. The <b>ONEX_RESULT_UPDATE_DATA</b> structure is returned  when  the <b>NotificationSource</b> member of the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/legacy/ms706902(v=vs.85)">WLAN_NOTIFICATION_DATA</a> structure is <b>WLAN_NOTIFICATION_SOURCE_ONEX</b>  and the <b>NotificationCode</b> member of the <b>WLAN_NOTIFICATION_DATA</b> structure for received notification  is <b>OneXNotificationTypeResultUpdate</b>. For this notification, the <b>pData</b> member of the <b>WLAN_NOTIFICATION_DATA</b> structure points to an  <b>ONEX_RESULT_UPDATE_DATA</b> structure that contains information on the 802.1X authentication status change. 

The <b>oneXStatus</b> member of the <a href="https://docs.microsoft.com/windows/desktop/api/dot1x/ns-dot1x-onex_result_update_data">ONEX_RESULT_UPDATE_DATA</a> structure contains an <a href="https://docs.microsoft.com/windows/desktop/api/dot1x/ns-dot1x-onex_status">ONEX_STATUS</a> structure. If an error occurred during 802.1X authentication, the dwReason menber of this <b>ONEX_STATUS</b> structure contains the reason for the error specified as a value from the <b>ONEX_REASON_CODE</b> enumeration. 




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/NativeWiFi/about-the-acm-architecture">About the ACM Architecture</a>



<a href="https://docs.microsoft.com/windows/desktop/api/dot1x/ne-dot1x-onex_notification_type">ONEX_NOTIFICATION_TYPE</a>



<a href="https://docs.microsoft.com/windows/desktop/api/dot1x/ns-dot1x-onex_result_update_data">ONEX_RESULT_UPDATE_DATA</a>



<a href="https://docs.microsoft.com/windows/desktop/api/dot1x/ns-dot1x-onex_status">ONEX_STATUS</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/legacy/ms706902(v=vs.85)">WLAN_NOTIFICATION_DATA</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wlanapi/nf-wlanapi-wlanregisternotification">WlanRegisterNotification</a>
 

 

