---
UID: NS:dot1x._ONEX_EAP_ERROR
title: ONEX_EAP_ERROR (dot1x.h)
description: Contains 802.1X EAP error when an error occurs with 802.1X authentication.
old-location: nwifi\onex_eap_error.htm
tech.root: NativeWiFi
ms.assetid: 20126b9a-732e-460d-bb10-4d7485b25eb9
ms.date: 12/05/2018
ms.keywords: '*PONEX_EAP_ERROR, EAP_E_AUTHENTICATION_FAILED, EAP_E_CERT_STORE_INACCESSIBLE, EAP_E_EAPHOST_EAPQEC_INACCESSIBLE, EAP_E_EAPHOST_IDENTITY_UNKNOWN, EAP_E_EAPHOST_METHOD_INVALID_PACKET, EAP_E_EAPHOST_METHOD_NOT_INSTALLED, EAP_E_EAPHOST_METHOD_OPERATION_NOT_SUPPORTED, EAP_E_EAPHOST_REMOTE_INVALID_PACKET, EAP_E_EAPHOST_XML_MALFORMED, EAP_E_METHOD_CONFIG_DOES_NOT_SUPPORT_SSO, EAP_E_NO_SMART_CARD_READER, EAP_E_SERVER_CERT_EXPIRED, EAP_E_SERVER_CERT_INVALID, EAP_E_SERVER_CERT_OTHER_ERROR, EAP_E_SERVER_CERT_REVOKED, EAP_E_SERVER_ROOT_CERT_NOT_FOUND, EAP_E_USER_CERT_EXPIRED, EAP_E_USER_CERT_INVALID, EAP_E_USER_CERT_NOT_FOUND, EAP_E_USER_CERT_OTHER_ERROR, EAP_E_USER_CERT_REJECTED, EAP_E_USER_CERT_REVOKED, EAP_E_USER_CREDENTIALS_REJECTED, EAP_E_USER_NAME_PASSWORD_REJECTED, EAP_E_USER_ROOT_CERT_EXPIRED, EAP_E_USER_ROOT_CERT_INVALID, EAP_E_USER_ROOT_CERT_NOT_FOUND, EAP_I_EAPHOST_EAP_NEGOTIATION_FAILED, EAP_I_USER_ACCOUNT_OTHER_ERROR, ERROR_BAD_ARGUMENTS, ERROR_CANTOPEN, ERROR_DATATYPE_MISMATCH, ERROR_INVALID_DATA, ERROR_INVALID_PARAMETER, ERROR_PATH_NOT_FOUND, E_UNEXPECTED, GUID_EapHost_Cause_CertStoreInaccessible, GUID_EapHost_Cause_EapNegotiationFailed, GUID_EapHost_Cause_EapQecInaccessible, GUID_EapHost_Cause_Generic_AuthFailure, GUID_EapHost_Cause_IdentityUnknown, GUID_EapHost_Cause_MethodDLLNotFound, GUID_EapHost_Cause_MethodDoesNotSupportOperation, GUID_EapHost_Cause_Method_Config_Does_Not_Support_Sso, GUID_EapHost_Cause_No_SmartCardReader_Found, GUID_EapHost_Cause_Server_CertExpired, GUID_EapHost_Cause_Server_CertInvalid, GUID_EapHost_Cause_Server_CertNotFound, GUID_EapHost_Cause_Server_CertOtherError, GUID_EapHost_Cause_Server_CertRevoked, GUID_EapHost_Cause_Server_Root_CertNameRequired, GUID_EapHost_Cause_Server_Root_CertNotFound, GUID_EapHost_Cause_ThirdPartyMethod_Host_Reset, GUID_EapHost_Cause_User_Account_OtherProblem, GUID_EapHost_Cause_User_CertExpired, GUID_EapHost_Cause_User_CertInvalid, GUID_EapHost_Cause_User_CertNotFound, GUID_EapHost_Cause_User_CertOtherError, GUID_EapHost_Cause_User_CertRejected, GUID_EapHost_Cause_User_CertRevoked, GUID_EapHost_Cause_User_CredsRejected, GUID_EapHost_Cause_User_Root_CertExpired, GUID_EapHost_Cause_User_Root_CertInvalid, GUID_EapHost_Cause_User_Root_CertNotFound, GUID_EapHost_Cause_XmlMalformed, GUID_EapHost_Default, GUID_EapHost_Help_EapConfigureTypes, GUID_EapHost_Help_FailedAuth, GUID_EapHost_Help_ObtainingCerts, GUID_EapHost_Help_SelectingCerts, GUID_EapHost_Help_SetupEapServer, GUID_EapHost_Help_Troubleshooting, GUID_EapHost_Repair_ContactAdmin_AuthFailure, GUID_EapHost_Repair_ContactAdmin_CertNameAbsent, GUID_EapHost_Repair_ContactAdmin_CertStoreInaccessible, GUID_EapHost_Repair_ContactAdmin_IdentityUnknown, GUID_EapHost_Repair_ContactAdmin_InvalidUserAccount, GUID_EapHost_Repair_ContactAdmin_InvalidUserCert, GUID_EapHost_Repair_ContactAdmin_MethodNotFound, GUID_EapHost_Repair_ContactAdmin_NegotiationFailed, GUID_EapHost_Repair_ContactAdmin_NoSmartCardReader, GUID_EapHost_Repair_ContactAdmin_RootCertInvalid, GUID_EapHost_Repair_ContactAdmin_RootCertNotFound, GUID_EapHost_Repair_ContactAdmin_RootExpired, GUID_EapHost_Repair_ContactSysadmin, GUID_EapHost_Repair_Method_Not_Support_Sso, GUID_EapHost_Repair_RestartNap, GUID_EapHost_Repair_Retry_Authentication, GUID_EapHost_Repair_Server_ClientSelectServerCert, GUID_EapHost_Repair_User_AuthFailure, GUID_EapHost_Repair_User_GetNewCert, GUID_EapHost_Repair_User_SelectValidCert, ONEX_EAP_ERROR, ONEX_EAP_ERROR structure [NativeWIFI], Other, PONEX_EAP_ERROR, PONEX_EAP_ERROR structure pointer [NativeWIFI], dot1x/ONEX_EAP_ERROR, dot1x/PONEX_EAP_ERROR, nwifi.onex_eap_error'
f1_keywords:
- dot1x/ONEX_EAP_ERROR
dev_langs:
- c++
req.header: dot1x.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- dot1x.h
api_name:
- ONEX_EAP_ERROR
targetos: Windows
req.typenames: ONEX_EAP_ERROR, *PONEX_EAP_ERROR
req.redist: 
ms.custom: 19H1
---

# ONEX_EAP_ERROR structure


## -description


The <b>ONEX_EAP_ERROR</b> structure contains 802.1X EAP error when an error occurs with 802.1X authentication.


## -struct-fields




### -field dwWinError

The error value defined in the <i>Winerror.h</i> header file. This member also sometimes contains the reason the EAP method failed. The existing values for this member for the reason the EAP method failed are defined in the <i>Eaphosterror.h</i> header file.

Some possible values are listed below.

<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="ERROR_PATH_NOT_FOUND"></a><a id="error_path_not_found"></a><dl>
<dt><b>ERROR_PATH_NOT_FOUND</b></dt>
<dt>3L</dt>
</dl>
</td>
<td width="60%">
The system cannot find the path specified.

</td>
</tr>
<tr>
<td width="40%"><a id="ERROR_INVALID_DATA"></a><a id="error_invalid_data"></a><dl>
<dt><b>ERROR_INVALID_DATA</b></dt>
<dt>13L</dt>
</dl>
</td>
<td width="60%">
The data is not valid.

</td>
</tr>
<tr>
<td width="40%"><a id="ERROR_INVALID_PARAMETER"></a><a id="error_invalid_parameter"></a><dl>
<dt><b>ERROR_INVALID_PARAMETER</b></dt>
<dt>87L</dt>
</dl>
</td>
<td width="60%">
A parameter is incorrect.

</td>
</tr>
<tr>
<td width="40%"><a id="ERROR_BAD_ARGUMENTS"></a><a id="error_bad_arguments"></a><dl>
<dt><b>ERROR_BAD_ARGUMENTS</b></dt>
<dt>160L</dt>
</dl>
</td>
<td width="60%">
One or more arguments are not correct.

</td>
</tr>
<tr>
<td width="40%"><a id="ERROR_CANTOPEN"></a><a id="error_cantopen"></a><dl>
<dt><b>ERROR_CANTOPEN</b></dt>
<dt>1011L</dt>
</dl>
</td>
<td width="60%">
The configuration registry key could not be opened.

</td>
</tr>
<tr>
<td width="40%"><a id="ERROR_DATATYPE_MISMATCH"></a><a id="error_datatype_mismatch"></a><dl>
<dt><b>ERROR_DATATYPE_MISMATCH</b></dt>
<dt>1629L</dt>
</dl>
</td>
<td width="60%">
The data supplied is of the wrong type.

</td>
</tr>
<tr>
<td width="40%"><a id="EAP_I_USER_ACCOUNT_OTHER_ERROR"></a><a id="eap_i_user_account_other_error"></a><dl>
<dt><b>EAP_I_USER_ACCOUNT_OTHER_ERROR</b></dt>
<dt>0x40420110</dt>
</dl>
</td>
<td width="60%">
The EAPHost received EAP failure after the identity exchange. There is likely a problem with the authenticating user's account.

</td>
</tr>
<tr>
<td width="40%"><a id="E_UNEXPECTED"></a><a id="e_unexpected"></a><dl>
<dt><b>E_UNEXPECTED</b></dt>
<dt>0x8000FFFFL</dt>
</dl>
</td>
<td width="60%">
A catastrophic failure occurred.

</td>
</tr>
<tr>
<td width="40%"><a id="EAP_E_CERT_STORE_INACCESSIBLE"></a><a id="eap_e_cert_store_inaccessible"></a><dl>
<dt><b>EAP_E_CERT_STORE_INACCESSIBLE</b></dt>
<dt>0x80420010</dt>
</dl>
</td>
<td width="60%">
The certificate store can't be accessed on either the authenticator or the peer.

</td>
</tr>
<tr>
<td width="40%"><a id="EAP_E_EAPHOST_METHOD_NOT_INSTALLED"></a><a id="eap_e_eaphost_method_not_installed"></a><dl>
<dt><b>EAP_E_EAPHOST_METHOD_NOT_INSTALLED</b></dt>
<dt>0x80420011</dt>
</dl>
</td>
<td width="60%">
The requested EAP method is not installed.

</td>
</tr>
<tr>
<td width="40%"><a id="EAP_E_EAPHOST_EAPQEC_INACCESSIBLE"></a><a id="eap_e_eaphost_eapqec_inaccessible"></a><dl>
<dt><b>EAP_E_EAPHOST_EAPQEC_INACCESSIBLE</b></dt>
<dt>0x80420013</dt>
</dl>
</td>
<td width="60%">
The EAPHost is not able to communicate with the EAP quarantine enforcement client (QEC) on a  client with Network Access Protection (NAP) enabled. 

</td>
</tr>
<tr>
<td width="40%"><a id="EAP_E_EAPHOST_IDENTITY_UNKNOWN"></a><a id="eap_e_eaphost_identity_unknown"></a><dl>
<dt><b>EAP_E_EAPHOST_IDENTITY_UNKNOWN</b></dt>
<dt>0x80420014</dt>
</dl>
</td>
<td width="60%">
The EAPHost returns this error if the authenticator fails the authentication after the peer sent its identity.

</td>
</tr>
<tr>
<td width="40%"><a id="EAP_E_AUTHENTICATION_FAILED"></a><a id="eap_e_authentication_failed"></a><dl>
<dt><b>EAP_E_AUTHENTICATION_FAILED</b></dt>
<dt>0x80420015</dt>
</dl>
</td>
<td width="60%">
The EAPHost returns this error on authentication failure.

</td>
</tr>
<tr>
<td width="40%"><a id="EAP_I_EAPHOST_EAP_NEGOTIATION_FAILED"></a><a id="eap_i_eaphost_eap_negotiation_failed"></a><dl>
<dt><b>EAP_I_EAPHOST_EAP_NEGOTIATION_FAILED</b></dt>
<dt>0x80420016</dt>
</dl>
</td>
<td width="60%">
The EAPHost returns this error when the client and the server aren't configured with compatible EAP types.

</td>
</tr>
<tr>
<td width="40%"><a id="EAP_E_EAPHOST_METHOD_INVALID_PACKET"></a><a id="eap_e_eaphost_method_invalid_packet"></a><dl>
<dt><b>EAP_E_EAPHOST_METHOD_INVALID_PACKET</b></dt>
<dt>0x80420017</dt>
</dl>
</td>
<td width="60%">
The EAPMethod received an EAP packet that cannot be processed.

</td>
</tr>
<tr>
<td width="40%"><a id="EAP_E_EAPHOST_REMOTE_INVALID_PACKET"></a><a id="eap_e_eaphost_remote_invalid_packet"></a><dl>
<dt><b>EAP_E_EAPHOST_REMOTE_INVALID_PACKET</b></dt>
<dt>0x80420018</dt>
</dl>
</td>
<td width="60%">
The EAPHost received a packet that cannot be processed.

</td>
</tr>
<tr>
<td width="40%"><a id="EAP_E_EAPHOST_XML_MALFORMED"></a><a id="eap_e_eaphost_xml_malformed"></a><dl>
<dt><b>EAP_E_EAPHOST_XML_MALFORMED</b></dt>
<dt>0x80420019</dt>
</dl>
</td>
<td width="60%">
The EAPHost configuration schema validation failed.

</td>
</tr>
<tr>
<td width="40%"><a id="EAP_E_METHOD_CONFIG_DOES_NOT_SUPPORT_SSO"></a><a id="eap_e_method_config_does_not_support_sso"></a><dl>
<dt><b>EAP_E_METHOD_CONFIG_DOES_NOT_SUPPORT_SSO</b></dt>
<dt>0x8042001A</dt>
</dl>
</td>
<td width="60%">
The EAP method does not support single signon for the provided configuration.

</td>
</tr>
<tr>
<td width="40%"><a id="EAP_E_EAPHOST_METHOD_OPERATION_NOT_SUPPORTED"></a><a id="eap_e_eaphost_method_operation_not_supported"></a><dl>
<dt><b>EAP_E_EAPHOST_METHOD_OPERATION_NOT_SUPPORTED</b></dt>
<dt>0x80420020</dt>
</dl>
</td>
<td width="60%">
The EAPHost returns this error when a configured EAP method does not support a requested operation (procedure call).

</td>
</tr>
<tr>
<td width="40%"><a id="EAP_E_USER_CERT_NOT_FOUND"></a><a id="eap_e_user_cert_not_found"></a><dl>
<dt><b>EAP_E_USER_CERT_NOT_FOUND</b></dt>
<dt>0x80420100</dt>
</dl>
</td>
<td width="60%">
The EAPHost could not find the user certificate for authentication.

</td>
</tr>
<tr>
<td width="40%"><a id="EAP_E_USER_CERT_INVALID"></a><a id="eap_e_user_cert_invalid"></a><dl>
<dt><b>EAP_E_USER_CERT_INVALID</b></dt>
<dt>0x80420101</dt>
</dl>
</td>
<td width="60%">
The user certificate being used for authentication does not have a proper extended key usage (EKU) set.

</td>
</tr>
<tr>
<td width="40%"><a id="EAP_E_USER_CERT_EXPIRED"></a><a id="eap_e_user_cert_expired"></a><dl>
<dt><b>EAP_E_USER_CERT_EXPIRED</b></dt>
<dt>0x80420102</dt>
</dl>
</td>
<td width="60%">
The EAPhost found a user certificate which has expired.

</td>
</tr>
<tr>
<td width="40%"><a id="EAP_E_USER_CERT_REVOKED"></a><a id="eap_e_user_cert_revoked"></a><dl>
<dt><b>EAP_E_USER_CERT_REVOKED</b></dt>
<dt>0x80420103</dt>
</dl>
</td>
<td width="60%">
The user certificate being used for authentication has been revoked.

</td>
</tr>
<tr>
<td width="40%"><a id="EAP_E_USER_CERT_OTHER_ERROR"></a><a id="eap_e_user_cert_other_error"></a><dl>
<dt><b>EAP_E_USER_CERT_OTHER_ERROR</b></dt>
<dt>0x80420104</dt>
</dl>
</td>
<td width="60%">
An unknown error occurred with the user certificate being used for authentication.

</td>
</tr>
<tr>
<td width="40%"><a id="EAP_E_USER_CERT_REJECTED"></a><a id="eap_e_user_cert_rejected"></a><dl>
<dt><b>EAP_E_USER_CERT_REJECTED</b></dt>
<dt>0x80420105</dt>
</dl>
</td>
<td width="60%">
The authenticator rejected  the user certificate being used for authentication.

</td>
</tr>
<tr>
<td width="40%"><a id="EAP_E_USER_CREDENTIALS_REJECTED"></a><a id="eap_e_user_credentials_rejected"></a><dl>
<dt><b>EAP_E_USER_CREDENTIALS_REJECTED</b></dt>
<dt>0x80420111</dt>
</dl>
</td>
<td width="60%">
The authenticator rejected the user credentials for authentication.

</td>
</tr>
<tr>
<td width="40%"><a id="EAP_E_USER_NAME_PASSWORD_REJECTED"></a><a id="eap_e_user_name_password_rejected"></a><dl>
<dt><b>EAP_E_USER_NAME_PASSWORD_REJECTED</b></dt>
<dt>0x80420112</dt>
</dl>
</td>
<td width="60%">
The authenticator rejected the user credentials for authentication.

</td>
</tr>
<tr>
<td width="40%"><a id="EAP_E_NO_SMART_CARD_READER"></a><a id="eap_e_no_smart_card_reader"></a><dl>
<dt><b>EAP_E_NO_SMART_CARD_READER</b></dt>
<dt>0x80420113</dt>
</dl>
</td>
<td width="60%">
No smart card reader was present.

</td>
</tr>
<tr>
<td width="40%"><a id="EAP_E_SERVER_CERT_INVALID"></a><a id="eap_e_server_cert_invalid"></a><dl>
<dt><b>EAP_E_SERVER_CERT_INVALID</b></dt>
<dt>0x80420201</dt>
</dl>
</td>
<td width="60%">
The server certificate being user for authentication does not have a proper EKU set  .

</td>
</tr>
<tr>
<td width="40%"><a id="EAP_E_SERVER_CERT_EXPIRED"></a><a id="eap_e_server_cert_expired"></a><dl>
<dt><b>EAP_E_SERVER_CERT_EXPIRED</b></dt>
<dt>0x80420202</dt>
</dl>
</td>
<td width="60%">
The EAPhost found a server certificate which has expired.

</td>
</tr>
<tr>
<td width="40%"><a id="EAP_E_SERVER_CERT_REVOKED"></a><a id="eap_e_server_cert_revoked"></a><dl>
<dt><b>EAP_E_SERVER_CERT_REVOKED</b></dt>
<dt>0x80420203</dt>
</dl>
</td>
<td width="60%">
The server certificate being used for authentication has been revoked.

</td>
</tr>
<tr>
<td width="40%"><a id="EAP_E_SERVER_CERT_OTHER_ERROR"></a><a id="eap_e_server_cert_other_error"></a><dl>
<dt><b>EAP_E_SERVER_CERT_OTHER_ERROR</b></dt>
<dt>0x80420204</dt>
</dl>
</td>
<td width="60%">
An unknown error occurred with the server certificate being used for authentication.

</td>
</tr>
<tr>
<td width="40%"><a id="EAP_E_USER_ROOT_CERT_NOT_FOUND"></a><a id="eap_e_user_root_cert_not_found"></a><dl>
<dt><b>EAP_E_USER_ROOT_CERT_NOT_FOUND</b></dt>
<dt>0x80420300</dt>
</dl>
</td>
<td width="60%">
The EAPHost could not find a certificate in trusted root certificate store for user certificate validation.

</td>
</tr>
<tr>
<td width="40%"><a id="EAP_E_USER_ROOT_CERT_INVALID"></a><a id="eap_e_user_root_cert_invalid"></a><dl>
<dt><b>EAP_E_USER_ROOT_CERT_INVALID</b></dt>
<dt>0x80420301</dt>
</dl>
</td>
<td width="60%">
The authentication failed because the root certificate used for this network is not valid.

</td>
</tr>
<tr>
<td width="40%"><a id="EAP_E_USER_ROOT_CERT_EXPIRED"></a><a id="eap_e_user_root_cert_expired"></a><dl>
<dt><b>EAP_E_USER_ROOT_CERT_EXPIRED</b></dt>
<dt>0x80420302</dt>
</dl>
</td>
<td width="60%">
The trusted root certificate needed for user certificate validation has expired.

</td>
</tr>
<tr>
<td width="40%"><a id="EAP_E_SERVER_ROOT_CERT_NOT_FOUND"></a><a id="eap_e_server_root_cert_not_found"></a><dl>
<dt><b>EAP_E_SERVER_ROOT_CERT_NOT_FOUND</b></dt>
<dt>0x80420400</dt>
</dl>
</td>
<td width="60%">
The EAPHost could not find a root certificate in the trusted root certificate store for server certificate velidation.

</td>
</tr>
</table>
 


### -field type

The EAP method type that raised the error during 802.1X authentication. The <a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_method_type">EAP_METHOD_TYPE</a> structure is defined in the <i>Eaptypes.h</i> header file.


### -field dwReasonCode

The reason the EAP method failed. Some of the values for this member are defined in the <i>Eaphosterror.h</i> header file and some are defined in in the <i>Winerror.h</i> header file, although other values are possible.

Possible values are listed below.

<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="ERROR_BAD_ARGUMENTS"></a><a id="error_bad_arguments"></a><dl>
<dt><b>ERROR_BAD_ARGUMENTS</b></dt>
</dl>
</td>
<td width="60%">
One or more arguments are not correct.

</td>
</tr>
<tr>
<td width="40%"><a id="ERROR_INVALID_DATA"></a><a id="error_invalid_data"></a><dl>
<dt><b>ERROR_INVALID_DATA</b></dt>
</dl>
</td>
<td width="60%">
The data is not valid.

</td>
</tr>
<tr>
<td width="40%"><a id="ERROR_INVALID_PARAMETER"></a><a id="error_invalid_parameter"></a><dl>
<dt><b>ERROR_INVALID_PARAMETER</b></dt>
</dl>
</td>
<td width="60%">
A parameter is incorrect.

</td>
</tr>
<tr>
<td width="40%"><a id="EAP_I_USER_ACCOUNT_OTHER_ERROR"></a><a id="eap_i_user_account_other_error"></a><dl>
<dt><b>EAP_I_USER_ACCOUNT_OTHER_ERROR</b></dt>
</dl>
</td>
<td width="60%">
The EAPHost received EAP failure after the identity exchange. There is likely a problem with the authenticating user's account.

</td>
</tr>
<tr>
<td width="40%"><a id="Other"></a><a id="other"></a><a id="OTHER"></a><dl>
<dt><b>Other</b></dt>
</dl>
</td>
<td width="60%">
Use 
<a href="https://docs.microsoft.com/windows/desktop/api/winbase/nf-winbase-formatmessage">FormatMessage</a> to obtain the message string for the returned error.

</td>
</tr>
</table>
 


### -field rootCauseGuid

A unique ID that identifies cause of error in EAPHost. An EAP method can define a new GUID and associate the GUID with a specific root cause. The existing values for this member are defined in the <i>Eaphosterror.h</i> header file.

<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Default"></a><a id="guid_eaphost_default"></a><a id="GUID_EAPHOST_DEFAULT"></a><dl>
<dt><b>GUID_EapHost_Default</b></dt>
<dt>{0x00000000, 0x0000, 0x0000, 0, 0, 0, 0, 0, 0, 0, 0}</dt>
</dl>
</td>
<td width="60%">
The default error cause.

This is not a fixed GUID when it reaches supplicant, but the first portion will be 
filled by a generic Win32/RAS error. This helps create a unique GUID for every 
unique error. 

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Cause_MethodDLLNotFound"></a><a id="guid_eaphost_cause_methoddllnotfound"></a><a id="GUID_EAPHOST_CAUSE_METHODDLLNOTFOUND"></a><dl>
<dt><b>GUID_EapHost_Cause_MethodDLLNotFound</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 1}}</dt>
</dl>
</td>
<td width="60%">
EAPHost cannot locate the DLL for the EAP method.

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Cause_CertStoreInaccessible"></a><a id="guid_eaphost_cause_certstoreinaccessible"></a><a id="GUID_EAPHOST_CAUSE_CERTSTOREINACCESSIBLE"></a><dl>
<dt><b>GUID_EapHost_Cause_CertStoreInaccessible</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 4}}</dt>
</dl>
</td>
<td width="60%">
 Both the authenticator and the peer are unable to access the certificate store. 

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Cause_Server_CertExpired"></a><a id="guid_eaphost_cause_server_certexpired"></a><a id="GUID_EAPHOST_CAUSE_SERVER_CERTEXPIRED"></a><dl>
<dt><b>GUID_EapHost_Cause_Server_CertExpired</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 5}}</dt>
</dl>
</td>
<td width="60%">
EAPHost found an expired server certificate. 

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Cause_Server_CertInvalid"></a><a id="guid_eaphost_cause_server_certinvalid"></a><a id="GUID_EAPHOST_CAUSE_SERVER_CERTINVALID"></a><dl>
<dt><b>GUID_EapHost_Cause_Server_CertInvalid</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 6}}</dt>
</dl>
</td>
<td width="60%">
The server certificate being user for authentication does not have a proper extended key usage (EKU) set. 

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Cause_Server_CertNotFound"></a><a id="guid_eaphost_cause_server_certnotfound"></a><a id="GUID_EAPHOST_CAUSE_SERVER_CERTNOTFOUND"></a><dl>
<dt><b>GUID_EapHost_Cause_Server_CertNotFound</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 7}} </dt>
</dl>
</td>
<td width="60%">
EAPHost could not find the server certificate for authentication. 

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Cause_Server_CertRevoked"></a><a id="guid_eaphost_cause_server_certrevoked"></a><a id="GUID_EAPHOST_CAUSE_SERVER_CERTREVOKED"></a><dl>
<dt><b>GUID_EapHost_Cause_Server_CertRevoked</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 8}}</dt>
</dl>
</td>
<td width="60%">
The  server certificate being used for authentication has been revoked. 

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Cause_User_CertExpired"></a><a id="guid_eaphost_cause_user_certexpired"></a><a id="GUID_EAPHOST_CAUSE_USER_CERTEXPIRED"></a><dl>
<dt><b>GUID_EapHost_Cause_User_CertExpired</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 9}}</dt>
</dl>
</td>
<td width="60%">
EAPHost found an expired user certificate.

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Cause_User_CertInvalid"></a><a id="guid_eaphost_cause_user_certinvalid"></a><a id="GUID_EAPHOST_CAUSE_USER_CERTINVALID"></a><dl>
<dt><b>GUID_EapHost_Cause_User_CertInvalid</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0xA}}</dt>
</dl>
</td>
<td width="60%">
The user certificate being user for authentication does not have proper extended key usage (EKU) set. 

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Cause_User_CertNotFound"></a><a id="guid_eaphost_cause_user_certnotfound"></a><a id="GUID_EAPHOST_CAUSE_USER_CERTNOTFOUND"></a><dl>
<dt><b>GUID_EapHost_Cause_User_CertNotFound</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0xB}}</dt>
</dl>
</td>
<td width="60%">
EAPHost could not find a user certificate for authentication. 

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Cause_User_CertOtherError"></a><a id="guid_eaphost_cause_user_certothererror"></a><a id="GUID_EAPHOST_CAUSE_USER_CERTOTHERERROR"></a><dl>
<dt><b>GUID_EapHost_Cause_User_CertOtherError</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0xC}}</dt>
</dl>
</td>
<td width="60%">
An unknown error occurred with the user certification being used for authentication. 

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Cause_User_CertRejected"></a><a id="guid_eaphost_cause_user_certrejected"></a><a id="GUID_EAPHOST_CAUSE_USER_CERTREJECTED"></a><dl>
<dt><b>GUID_EapHost_Cause_User_CertRejected</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0xD}}</dt>
</dl>
</td>
<td width="60%">
The authenticator rejected the user certification. 

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Cause_User_CertRevoked"></a><a id="guid_eaphost_cause_user_certrevoked"></a><a id="GUID_EAPHOST_CAUSE_USER_CERTREVOKED"></a><dl>
<dt><b>GUID_EapHost_Cause_User_CertRevoked</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0xE}}</dt>
</dl>
</td>
<td width="60%">
The user certificate  being used for authentication has been revoked.

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Cause_User_Root_CertExpired"></a><a id="guid_eaphost_cause_user_root_certexpired"></a><a id="GUID_EAPHOST_CAUSE_USER_ROOT_CERTEXPIRED"></a><dl>
<dt><b>GUID_EapHost_Cause_User_Root_CertExpired</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0xF}}</dt>
</dl>
</td>
<td width="60%">
The trusted root certificate needed for user certificate validation has expired.

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Cause_User_Root_CertInvalid"></a><a id="guid_eaphost_cause_user_root_certinvalid"></a><a id="GUID_EAPHOST_CAUSE_USER_ROOT_CERTINVALID"></a><dl>
<dt><b>GUID_EapHost_Cause_User_Root_CertInvalid</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0x10}}</dt>
</dl>
</td>
<td width="60%">
 The authentication failed because the root certificate used for this network is not valid. 

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Cause_User_Root_CertNotFound"></a><a id="guid_eaphost_cause_user_root_certnotfound"></a><a id="GUID_EAPHOST_CAUSE_USER_ROOT_CERTNOTFOUND"></a><dl>
<dt><b>GUID_EapHost_Cause_User_Root_CertNotFound</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0x11}}</dt>
</dl>
</td>
<td width="60%">
EAPHost could not find a certificate in a trusted root certificate store for user certification validation. 

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Cause_Server_Root_CertNameRequired"></a><a id="guid_eaphost_cause_server_root_certnamerequired"></a><a id="GUID_EAPHOST_CAUSE_SERVER_ROOT_CERTNAMEREQUIRED"></a><dl>
<dt><b>GUID_EapHost_Cause_Server_Root_CertNameRequired</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0x12}}</dt>
</dl>
</td>
<td width="60%">
The authentication failed because the certificate on the server computer does not have a server name specified. 

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Cause_EapNegotiationFailed"></a><a id="guid_eaphost_cause_eapnegotiationfailed"></a><a id="GUID_EAPHOST_CAUSE_EAPNEGOTIATIONFAILED"></a><dl>
<dt><b>GUID_EapHost_Cause_EapNegotiationFailed</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0x1C}}</dt>
</dl>
</td>
<td width="60%">
The authentication failed because Windows does not have the authentication method required for this network. 

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Cause_XmlMalformed"></a><a id="guid_eaphost_cause_xmlmalformed"></a><a id="GUID_EAPHOST_CAUSE_XMLMALFORMED"></a><dl>
<dt><b>GUID_EapHost_Cause_XmlMalformed</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0x1D}}</dt>
</dl>
</td>
<td width="60%">
The EAPHost configuration schema validation failed. 

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Cause_MethodDoesNotSupportOperation"></a><a id="guid_eaphost_cause_methoddoesnotsupportoperation"></a><a id="GUID_EAPHOST_CAUSE_METHODDOESNOTSUPPORTOPERATION"></a><dl>
<dt><b>GUID_EapHost_Cause_MethodDoesNotSupportOperation</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0x1E}}</dt>
</dl>
</td>
<td width="60%">
EAPHost returns this error when a configured EAP method does not support a requested operation (procedure call). 

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Cause_No_SmartCardReader_Found"></a><a id="guid_eaphost_cause_no_smartcardreader_found"></a><a id="GUID_EAPHOST_CAUSE_NO_SMARTCARDREADER_FOUND"></a><dl>
<dt><b>GUID_EapHost_Cause_No_SmartCardReader_Found</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0x2B}}</dt>
</dl>
</td>
<td width="60%">
A valid smart card needs to be present for authentication to be proceed.

This GUID is supported on Windows Server 2008 R2 with the Wireless LAN Service installed and on Windows 7 .

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Cause_Generic_AuthFailure"></a><a id="guid_eaphost_cause_generic_authfailure"></a><a id="GUID_EAPHOST_CAUSE_GENERIC_AUTHFAILURE"></a><dl>
<dt><b>GUID_EapHost_Cause_Generic_AuthFailure</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 1, 4}}</dt>
</dl>
</td>
<td width="60%">
EAPHost returns this error on a generic, unspecified authentication failure. 

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Cause_Server_CertOtherError"></a><a id="guid_eaphost_cause_server_certothererror"></a><a id="GUID_EAPHOST_CAUSE_SERVER_CERTOTHERERROR"></a><dl>
<dt><b>GUID_EapHost_Cause_Server_CertOtherError</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 1, 8}}</dt>
</dl>
</td>
<td width="60%">
An unknown error occurred with the server certificate. 

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Cause_User_Account_OtherProblem"></a><a id="guid_eaphost_cause_user_account_otherproblem"></a><a id="GUID_EAPHOST_CAUSE_USER_ACCOUNT_OTHERPROBLEM"></a><dl>
<dt><b>GUID_EapHost_Cause_User_Account_OtherProblem</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 1, 0xE}}</dt>
</dl>
</td>
<td width="60%">
An EAP failure was received after an identity exchange, indicating the likelihood of a problem with the authenticating user's account. 

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Cause_Server_Root_CertNotFound"></a><a id="guid_eaphost_cause_server_root_certnotfound"></a><a id="GUID_EAPHOST_CAUSE_SERVER_ROOT_CERTNOTFOUND"></a><dl>
<dt><b>GUID_EapHost_Cause_Server_Root_CertNotFound</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 1, 0x12}}</dt>
</dl>
</td>
<td width="60%">
EAPHost could not find a root certificate in a trusted root certificate store for the server certification  validation. 

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Cause_IdentityUnknown"></a><a id="guid_eaphost_cause_identityunknown"></a><a id="GUID_EAPHOST_CAUSE_IDENTITYUNKNOWN"></a><dl>
<dt><b>GUID_EapHost_Cause_IdentityUnknown</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 2, 4}}</dt>
</dl>
</td>
<td width="60%">
EAPHost returns this error if the authenticator fails the authentication after the peer identity was submitted. 

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Cause_User_CredsRejected"></a><a id="guid_eaphost_cause_user_credsrejected"></a><a id="GUID_EAPHOST_CAUSE_USER_CREDSREJECTED"></a><dl>
<dt><b>GUID_EapHost_Cause_User_CredsRejected</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 2, 0xE}}</dt>
</dl>
</td>
<td width="60%">
The authenticator rejected user credentials for authentication.  

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Cause_ThirdPartyMethod_Host_Reset"></a><a id="guid_eaphost_cause_thirdpartymethod_host_reset"></a><a id="GUID_EAPHOST_CAUSE_THIRDPARTYMETHOD_HOST_RESET"></a><dl>
<dt><b>GUID_EapHost_Cause_ThirdPartyMethod_Host_Reset</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 2, 0x12}}</dt>
</dl>
</td>
<td width="60%">
The host of the third party method is not responding and was automatically restarted. 

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Cause_EapQecInaccessible"></a><a id="guid_eaphost_cause_eapqecinaccessible"></a><a id="GUID_EAPHOST_CAUSE_EAPQECINACCESSIBLE"></a><dl>
<dt><b>GUID_EapHost_Cause_EapQecInaccessible</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 3, 0x12}}</dt>
</dl>
</td>
<td width="60%">
EAPHost was not able to communicate with the EAP quarantine enforcement client (QEC) on a client with Network Access Protection (NAP) enabled. This error may occur when the NAP service is not responding.

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Cause_Method_Config_Does_Not_Support_Sso"></a><a id="guid_eaphost_cause_method_config_does_not_support_sso"></a><a id="GUID_EAPHOST_CAUSE_METHOD_CONFIG_DOES_NOT_SUPPORT_SSO"></a><dl>
<dt><b>GUID_EapHost_Cause_Method_Config_Does_Not_Support_Sso</b></dt>
<dt>{0xda18bd32, 0x004f, 0x41fa, {0xae, 0x08, 0x0b, 0xc8, 0x5e, 0x58, 0x45, 0xac}}</dt>
</dl>
</td>
<td width="60%">
The EAP method does not support single signon for the provided configuration data.

This GUID is supported on   Windows Server 2008 R2 with the Wireless LAN Service installed and on Windows 7.

</td>
</tr>
</table>
 


### -field repairGuid

A  unique ID that maps to a localizable string that identifies the repair action that can be taken to fix the reported error. The existing values for this member are defined in the <i>Eaphosterror.h</i> header file.

<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Repair_ContactSysadmin"></a><a id="guid_eaphost_repair_contactsysadmin"></a><a id="GUID_EAPHOST_REPAIR_CONTACTSYSADMIN"></a><dl>
<dt><b>GUID_EapHost_Repair_ContactSysadmin</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 2}}</dt>
</dl>
</td>
<td width="60%">
The user should contact the network administrator.

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Repair_Server_ClientSelectServerCert"></a><a id="guid_eaphost_repair_server_clientselectservercert"></a><a id="GUID_EAPHOST_REPAIR_SERVER_CLIENTSELECTSERVERCERT"></a><dl>
<dt><b>GUID_EapHost_Repair_Server_ClientSelectServerCert</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0x18}}</dt>
</dl>
</td>
<td width="60%">
The user should choose a different and valid certificate for authentication with this network.

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Repair_User_AuthFailure"></a><a id="guid_eaphost_repair_user_authfailure"></a><a id="GUID_EAPHOST_REPAIR_USER_AUTHFAILURE"></a><dl>
<dt><b>GUID_EapHost_Repair_User_AuthFailure</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0x19}}</dt>
</dl>
</td>
<td width="60%">
The user should contact your network administrator. Your administrator can verify your user name and password for network authentication.

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Repair_User_GetNewCert"></a><a id="guid_eaphost_repair_user_getnewcert"></a><a id="GUID_EAPHOST_REPAIR_USER_GETNEWCERT"></a><dl>
<dt><b>GUID_EapHost_Repair_User_GetNewCert</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0x1A}}
</dt>
</dl>
</td>
<td width="60%">
The user should obtain an updated certificate from the network administrator. The certificate required to connect to this network can't be found on your computer.

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Repair_User_SelectValidCert"></a><a id="guid_eaphost_repair_user_selectvalidcert"></a><a id="GUID_EAPHOST_REPAIR_USER_SELECTVALIDCERT"></a><dl>
<dt><b>GUID_EapHost_Repair_User_SelectValidCert</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0x1B}} </dt>
</dl>
</td>
<td width="60%">
The user should use a different and valid user certificate for authentication with the network.

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Repair_ContactAdmin_AuthFailure"></a><a id="guid_eaphost_repair_contactadmin_authfailure"></a><a id="GUID_EAPHOST_REPAIR_CONTACTADMIN_AUTHFAILURE"></a><dl>
<dt><b>GUID_EapHost_Repair_ContactAdmin_AuthFailure</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0x1F}}</dt>
</dl>
</td>
<td width="60%">
The user should contact your network administrator. Windows can't verify your identity for connection to this network.

This GUID is supported on   Windows Server 2008 R2 with the Wireless LAN Service installed and on Windows 7.

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Repair_ContactAdmin_IdentityUnknown"></a><a id="guid_eaphost_repair_contactadmin_identityunknown"></a><a id="GUID_EAPHOST_REPAIR_CONTACTADMIN_IDENTITYUNKNOWN"></a><dl>
<dt><b>GUID_EapHost_Repair_ContactAdmin_IdentityUnknown</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0x20}}</dt>
</dl>
</td>
<td width="60%">
The user should contact your network administrator. Windows can't verify your identity for connection to this network.

This GUID is supported on Windows  Windows Server 2008 R2 with the Wireless LAN Service installed and on Windows 7.

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Repair_ContactAdmin_NegotiationFailed"></a><a id="guid_eaphost_repair_contactadmin_negotiationfailed"></a><a id="GUID_EAPHOST_REPAIR_CONTACTADMIN_NEGOTIATIONFAILED"></a><dl>
<dt><b>GUID_EapHost_Repair_ContactAdmin_NegotiationFailed</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0x21}}</dt>
</dl>
</td>
<td width="60%">
The user should contact your network administrator. Windows needs to be configured to use the authentication method required for this network.

This GUID is supported on   Windows Server 2008 R2 with the Wireless LAN Service installed and on Windows 7.

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Repair_ContactAdmin_MethodNotFound_"></a><a id="guid_eaphost_repair_contactadmin_methodnotfound_"></a><a id="GUID_EAPHOST_REPAIR_CONTACTADMIN_METHODNOTFOUND_"></a><dl>
<dt><b>GUID_EapHost_Repair_ContactAdmin_MethodNotFound </b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0x22}}</dt>
</dl>
</td>
<td width="60%">
The user should contact your network administrator.  Windows needs to be configured to use the authentication method required for this network.

This GUID is supported on Windows  Windows Server 2008 R2 with the Wireless LAN Service installed and on Windows 7.

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Repair_RestartNap"></a><a id="guid_eaphost_repair_restartnap"></a><a id="GUID_EAPHOST_REPAIR_RESTARTNAP"></a><dl>
<dt><b>GUID_EapHost_Repair_RestartNap</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0x23}}</dt>
</dl>
</td>
<td width="60%">
The user should start the Network Access Protection service. The Network Access Protection service is not responding.  Start or restart the Network Access Protection service, and then try connecting again.

This GUID is supported on   Windows Server 2008 R2 with the Wireless LAN Service installed and on Windows 7 .

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Repair_ContactAdmin_CertStoreInaccessible"></a><a id="guid_eaphost_repair_contactadmin_certstoreinaccessible"></a><a id="GUID_EAPHOST_REPAIR_CONTACTADMIN_CERTSTOREINACCESSIBLE"></a><dl>
<dt><b>GUID_EapHost_Repair_ContactAdmin_CertStoreInaccessible</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0x24}}</dt>
</dl>
</td>
<td width="60%">
The user should contact your network administrator. The certificate store on this computer needs to be repaired.

This GUID is supported on Windows  Windows Server 2008 R2 with the Wireless LAN Service installed and on Windows 7.

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Repair_ContactAdmin_InvalidUserAccount"></a><a id="guid_eaphost_repair_contactadmin_invaliduseraccount"></a><a id="GUID_EAPHOST_REPAIR_CONTACTADMIN_INVALIDUSERACCOUNT"></a><dl>
<dt><b>GUID_EapHost_Repair_ContactAdmin_InvalidUserAccount</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0x25}}</dt>
</dl>
</td>
<td width="60%">
The user should contact your network administrator. A problem with your user account needs to be resolved.

This GUID is supported on Windows Server 2008 R2 with the Wireless LAN Service installed and on Windows 7.

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Repair_ContactAdmin_RootCertInvalid"></a><a id="guid_eaphost_repair_contactadmin_rootcertinvalid"></a><a id="GUID_EAPHOST_REPAIR_CONTACTADMIN_ROOTCERTINVALID"></a><dl>
<dt><b>GUID_EapHost_Repair_ContactAdmin_RootCertInvalid</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0x26}}</dt>
</dl>
</td>
<td width="60%">
The user should contact your network administrator. The root certificate used for this network needs to be repaired.

This GUID is supported on Windows Server 2008 R2 with the Wireless LAN Service installed and on Windows 7.

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Repair_ContactAdmin_RootCertNotFound"></a><a id="guid_eaphost_repair_contactadmin_rootcertnotfound"></a><a id="GUID_EAPHOST_REPAIR_CONTACTADMIN_ROOTCERTNOTFOUND"></a><dl>
<dt><b>GUID_EapHost_Repair_ContactAdmin_RootCertNotFound</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0x27}}</dt>
</dl>
</td>
<td width="60%">
The user should contact your network administrator. The certificate used by the server for this network needs to be properly installed on your computer.

This GUID is supported on Windows Server 2008 R2 with the Wireless LAN Service installed and on Windows 7.

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Repair_ContactAdmin_RootExpired"></a><a id="guid_eaphost_repair_contactadmin_rootexpired"></a><a id="GUID_EAPHOST_REPAIR_CONTACTADMIN_ROOTEXPIRED"></a><dl>
<dt><b>GUID_EapHost_Repair_ContactAdmin_RootExpired</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0x28}}</dt>
</dl>
</td>
<td width="60%">
The user should contact your network administrator. The root certificate used for this network needs to be renewed.

This GUID is supported on Windows Server 2008 R2 with the Wireless LAN Service installed and on Windows 7.

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Repair_ContactAdmin_CertNameAbsent"></a><a id="guid_eaphost_repair_contactadmin_certnameabsent"></a><a id="GUID_EAPHOST_REPAIR_CONTACTADMIN_CERTNAMEABSENT"></a><dl>
<dt><b>GUID_EapHost_Repair_ContactAdmin_CertNameAbsent</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0x29}}</dt>
</dl>
</td>
<td width="60%">
The user should contact your network administrator. A problem with the server certificate used for this network needs to be resolved.

This GUID is supported on Windows Server 2008 R2 with the Wireless LAN Service installed and on Windows 7.

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Repair_ContactAdmin_NoSmartCardReader"></a><a id="guid_eaphost_repair_contactadmin_nosmartcardreader"></a><a id="GUID_EAPHOST_REPAIR_CONTACTADMIN_NOSMARTCARDREADER"></a><dl>
<dt><b>GUID_EapHost_Repair_ContactAdmin_NoSmartCardReader</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0x2A}}</dt>
</dl>
</td>
<td width="60%">
The user should connect a smart card reader to your computer, insert a smart card, and attempt to connect again.

This GUID is supported on Windows Server 2008 R2 with the Wireless LAN Service installed and on Windows 7.

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Repair_ContactAdmin_InvalidUserCert"></a><a id="guid_eaphost_repair_contactadmin_invalidusercert"></a><a id="GUID_EAPHOST_REPAIR_CONTACTADMIN_INVALIDUSERCERT"></a><dl>
<dt><b>GUID_EapHost_Repair_ContactAdmin_InvalidUserCert</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0x2C}}</dt>
</dl>
</td>
<td width="60%">
The user should contact your network administrator. The user certificate on this  computer needs to be repaired.

This GUID is supported on Windows Server 2008 R2 with the Wireless LAN Service installed and on Windows 7.

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Repair_Method_Not_Support_Sso"></a><a id="guid_eaphost_repair_method_not_support_sso"></a><a id="GUID_EAPHOST_REPAIR_METHOD_NOT_SUPPORT_SSO"></a><dl>
<dt><b>GUID_EapHost_Repair_Method_Not_Support_Sso</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0x2D}}</dt>
</dl>
</td>
<td width="60%">
The user should contact your network administrator. Windows needs to be configured to use the authentication method required for this network.

This GUID is supported on Windows Server 2008 R2 with the Wireless LAN Service installed and on Windows 7.

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Repair_Retry_Authentication"></a><a id="guid_eaphost_repair_retry_authentication"></a><a id="GUID_EAPHOST_REPAIR_RETRY_AUTHENTICATION"></a><dl>
<dt><b>GUID_EapHost_Repair_Retry_Authentication</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 1, 0x1B}}</dt>
</dl>
</td>
<td width="60%">
The user should try to connect to the network again.

</td>
</tr>
</table>
 


### -field helpLinkGuid

A unique ID that maps to a localizable string that specifies an URL for a page that contains additional information about an error or repair message.  An EAP method can potentially define a new GUID and associate with one specific help link. Some of the existing values for this member are defined in the <i>Eaphosterror.h</i> header file.

<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Help_Troubleshooting"></a><a id="guid_eaphost_help_troubleshooting"></a><a id="GUID_EAPHOST_HELP_TROUBLESHOOTING"></a><dl>
<dt><b>GUID_EapHost_Help_Troubleshooting</b></dt>
<dt>{0x33307acf, 0x0698, 0x41ba, {0xb0, 0x14, 0xea, 0x0a, 0x2e, 0xb8, 0xd0, 0xa8}}</dt>
</dl>
</td>
<td width="60%">
The URL for the page with more information about troubleshooting. This currently is a generic networking troubleshooting help page, not EAP specific.

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Help_EapConfigureTypes"></a><a id="guid_eaphost_help_eapconfiguretypes"></a><a id="GUID_EAPHOST_HELP_EAPCONFIGURETYPES"></a><dl>
<dt><b>GUID_EapHost_Help_EapConfigureTypes</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0x03}}</dt>
</dl>
</td>
<td width="60%">
The URL for the page with more information about configuring EAP types.

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Help_FailedAuth"></a><a id="guid_eaphost_help_failedauth"></a><a id="GUID_EAPHOST_HELP_FAILEDAUTH"></a><dl>
<dt><b>GUID_EapHost_Help_FailedAuth</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0x13}}</dt>
</dl>
</td>
<td width="60%">
The URL for the page with more information about authentication failures.

This GUID is supported on Windows Vista

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Help_SelectingCerts"></a><a id="guid_eaphost_help_selectingcerts"></a><a id="GUID_EAPHOST_HELP_SELECTINGCERTS"></a><dl>
<dt><b>GUID_EapHost_Help_SelectingCerts</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0x15}}</dt>
</dl>
</td>
<td width="60%">
The URL for the page with more information about selecting the appropriate certificate to use for authentication.

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Help_SetupEapServer"></a><a id="guid_eaphost_help_setupeapserver"></a><a id="GUID_EAPHOST_HELP_SETUPEAPSERVER"></a><dl>
<dt><b>GUID_EapHost_Help_SetupEapServer</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0x16}}</dt>
</dl>
</td>
<td width="60%">
The URL for the page with more information about setting up an EAP server.

This GUID is supported on Windows Vista

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Help_Troubleshooting"></a><a id="guid_eaphost_help_troubleshooting"></a><a id="GUID_EAPHOST_HELP_TROUBLESHOOTING"></a><dl>
<dt><b>GUID_EapHost_Help_Troubleshooting</b></dt>
<dt>{0x9612fc67, 0x6150, 0x4209, {0xa8, 0x5e, 0xa8, 0xd8, 0, 0, 0, 0x17}}</dt>
</dl>
</td>
<td width="60%">
The URL for the page with more information about troubleshooting.

This GUID is supported on Windows Vista

</td>
</tr>
<tr>
<td width="40%"><a id="GUID_EapHost_Help_ObtainingCerts"></a><a id="guid_eaphost_help_obtainingcerts"></a><a id="GUID_EAPHOST_HELP_OBTAININGCERTS"></a><dl>
<dt><b>GUID_EapHost_Help_ObtainingCerts</b></dt>
<dt>{0xf535eea3, 0x1bdd, 0x46ca, {0xa2, 0xfc, 0xa6, 0x65, 0x59, 0x39, 0xb7, 0xe8}}</dt>
</dl>
</td>
<td width="60%">
The URL for the page with more information about getting EAP certificates.

</td>
</tr>
</table>
 


### -field fRootCauseString

Indicates if the <b>ONEX_EAP_ERROR</b> structure contains a root cause string in the <b>RootCauseString</b> member.


### -field fRepairString

Indicates if the <b>ONEX_EAP_ERROR</b> structure contains a repair string in the <b>RepairString</b> member.


### -field RootCauseString

A localized and readable string that describes the root cause of the error. This member contains a NULL-terminated Unicode string starting at the <b>dwOffset</b> member of the <a href="https://docs.microsoft.com/windows/desktop/api/dot1x/ns-dot1x-onex_variable_blob">ONEX_VARIABLE_BLOB</a> if the <b>fRootCauseString</b> bitfield member is set.


### -field RepairString

A localized and readable string that describes the possible repair action.
This member contains a NULL-terminated Unicode string starting at the <b>dwOffset</b> member of the <a href="https://docs.microsoft.com/windows/desktop/api/dot1x/ns-dot1x-onex_variable_blob">ONEX_VARIABLE_BLOB</a> if the <b>fRepairString</b> bitfield member is set.


## -remarks



The <b>ONEX_EAP_ERROR</b> structure is used by the 802.1X module, a new wireless configuration component supported on Windows Vista and  later.  

Many members of the <b>ONEX_EAP_ERROR</b> structure correspond with similar members in the <a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_error">EAP_ERROR</a> structure

The <a href="https://docs.microsoft.com/windows/desktop/api/dot1x/ns-dot1x-onex_result_update_data">ONEX_RESULT_UPDATE_DATA</a> contains information on a status change to 802.1X authentication. The <b>ONEX_RESULT_UPDATE_DATA</b> structure is returned  when  the <b>NotificationSource</b> member of the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/legacy/ms706902(v=vs.85)">WLAN_NOTIFICATION_DATA</a> structure is <b>WLAN_NOTIFICATION_SOURCE_ONEX</b>  and the <b>NotificationCode</b> member of the <b>WLAN_NOTIFICATION_DATA</b> structure for received notification  is <b>OneXNotificationTypeResultUpdate</b>. For this notification, the <b>pData</b> member of the <b>WLAN_NOTIFICATION_DATA</b> structure points to an  <b>ONEX_RESULT_UPDATE_DATA</b> structure that contains information on the 802.1X authentication status change. 

If the <b>fEapError</b> member in the <a href="https://docs.microsoft.com/windows/desktop/api/dot1x/ns-dot1x-onex_result_update_data">ONEX_RESULT_UPDATE_DATA</a> structure is set, then the  <b>eapError</b> member of the <b>ONEX_RESULT_UPDATE_DATA</b> structure contains an <a href="https://docs.microsoft.com/windows/desktop/api/dot1x/ns-dot1x-onex_variable_blob">ONEX_VARIABLE_BLOB</a> structure with an <b>ONEX_EAP_ERROR</b> structure embedded starting at the <b>dwOffset</b> member of the  <b>ONEX_VARIABLE_BLOB</b>. 




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/NativeWiFi/about-the-acm-architecture">About the ACM Architecture</a>



[Common EAPHost API Structures](https://docs.microsoft.com/windows/win32/eaphost/common-eap-host-api-structures)a>



<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_error">EAP_ERROR</a>



<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_method_type">EAP_METHOD_TYPE</a>



<a href="https://docs.microsoft.com/windows/desktop/api/dot1x/ne-dot1x-onex_notification_type">ONEX_NOTIFICATION_TYPE</a>



<a href="https://docs.microsoft.com/windows/desktop/api/dot1x/ns-dot1x-onex_result_update_data">ONEX_RESULT_UPDATE_DATA</a>



<a href="https://docs.microsoft.com/windows/desktop/api/dot1x/ns-dot1x-onex_variable_blob">ONEX_VARIABLE_BLOB</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/legacy/ms706902(v=vs.85)">WLAN_NOTIFICATION_DATA</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wlanapi/nf-wlanapi-wlanregisternotification">WlanRegisterNotification</a>
 

 

