---
UID: NE:dsrole._DSROLE_OPERATION_STATE
title: DSROLE_OPERATION_STATE (dsrole.h)
description: Used with the DSROLE_OPERATION_STATE_INFO structure to indicate the operational state of a computer.
old-location: ad\dsrole_operation_state.htm
tech.root: ad
ms.assetid: de294893-e78a-4b51-9a48-0c71f91b6fde
ms.date: 12/05/2018
ms.keywords: DSROLE_OPERATION_STATE, DSROLE_OPERATION_STATE enumeration [Active Directory], DsRoleOperationActive, DsRoleOperationIdle, DsRoleOperationNeedReboot, ad.dsrole_operation_state, dsrole/DSROLE_OPERATION_STATE, dsrole/DsRoleOperationActive, dsrole/DsRoleOperationIdle, dsrole/DsRoleOperationNeedReboot
f1_keywords:
- dsrole/DSROLE_OPERATION_STATE
dev_langs:
- c++
req.header: dsrole.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista
req.target-min-winversvr: Windows Server 2008
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Dsrole.h
api_name:
- DSROLE_OPERATION_STATE
targetos: Windows
req.typenames: DSROLE_OPERATION_STATE
req.redist: 
ms.custom: 19H1
---

# DSROLE_OPERATION_STATE enumeration


## -description


The <b>DSROLE_OPERATION_STATE</b> enumeration is used with the <a href="https://docs.microsoft.com/windows/desktop/api/dsrole/ns-dsrole-dsrole_operation_state_info">DSROLE_OPERATION_STATE_INFO</a> structure to indicate the operational state of a computer.


## -enum-fields




### -field DsRoleOperationIdle

The computer is idle.


### -field DsRoleOperationActive

The computer is active.


### -field DsRoleOperationNeedReboot

The computer requires a restart.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/dsrole/ns-dsrole-dsrole_operation_state_info">DSROLE_OPERATION_STATE_INFO</a>



<a href="https://docs.microsoft.com/windows/desktop/AD/enumerations-in-active-directory-domain-services">Enumerations in Active Directory Domain Services</a>
 

 

