---
UID: NE:dwmapi.GESTURE_TYPE
title: GESTURE_TYPE (dwmapi.h)
description: Identifies the gesture type specified in DwmRenderGesture.
old-location: dwm\gesture_type.htm
tech.root: dwm
ms.assetid: 3FBDDFC9-A3E7-43DC-B7C6-A23976861C28
ms.date: 12/05/2018
ms.keywords: GESTURE_TYPE, GESTURE_TYPE enumeration [Desktop Window Manager], GT_PEN_DOUBLETAP, GT_PEN_PRESSANDHOLD, GT_PEN_PRESSANDHOLDABORT, GT_PEN_RIGHTTAP, GT_PEN_TAP, GT_TOUCH_DOUBLETAP, GT_TOUCH_PRESSANDHOLD, GT_TOUCH_PRESSANDHOLDABORT, GT_TOUCH_PRESSANDTAP, GT_TOUCH_RIGHTTAP, GT_TOUCH_TAP, dwm.gesture_type, dwmapi/GESTURE_TYPE, dwmapi/GT_PEN_DOUBLETAP, dwmapi/GT_PEN_PRESSANDHOLD, dwmapi/GT_PEN_PRESSANDHOLDABORT, dwmapi/GT_PEN_RIGHTTAP, dwmapi/GT_PEN_TAP, dwmapi/GT_TOUCH_DOUBLETAP, dwmapi/GT_TOUCH_PRESSANDHOLD, dwmapi/GT_TOUCH_PRESSANDHOLDABORT, dwmapi/GT_TOUCH_PRESSANDTAP, dwmapi/GT_TOUCH_RIGHTTAP, dwmapi/GT_TOUCH_TAP
f1_keywords:
- dwmapi/GESTURE_TYPE
dev_langs:
- c++
req.header: dwmapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Dwmapi.h
api_name:
- GESTURE_TYPE
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# GESTURE_TYPE enumeration


## -description


Identifies the gesture type specified in <a href="https://docs.microsoft.com/windows/desktop/api/dwmapi/nf-dwmapi-dwmrendergesture">DwmRenderGesture</a>.


## -enum-fields




### -field GT_PEN_TAP

A pen tap.


### -field GT_PEN_DOUBLETAP

A pen double tap.


### -field GT_PEN_RIGHTTAP

A pen right tap.


### -field GT_PEN_PRESSANDHOLD

A pen press and hold.


### -field GT_PEN_PRESSANDHOLDABORT

An abort of the pen press and hold.


### -field GT_TOUCH_TAP

A touch tap.


### -field GT_TOUCH_DOUBLETAP

A touch double tap.


### -field GT_TOUCH_RIGHTTAP

A touch right tap.


### -field GT_TOUCH_PRESSANDHOLD

A touch press and hold.


### -field GT_TOUCH_PRESSANDHOLDABORT

An abort of the pen press and hold.


### -field GT_TOUCH_PRESSANDTAP

A touch press and tap.

