---
UID: NE:dwrite.DWRITE_INFORMATIONAL_STRING_ID
title: DWRITE_INFORMATIONAL_STRING_ID (dwrite.h)
description: The informational string enumeration which identifies a string embedded in a font file.
old-location: directwrite\dwrite_informational_string_id.htm
tech.root: DirectWrite
ms.assetid: bbd5ea62-0837-49e4-a1e8-1d55d5d39ee3
ms.date: 12/05/2018
ms.keywords: DWRITE_INFORMATIONAL_STRING_COPYRIGHT_NOTICE, DWRITE_INFORMATIONAL_STRING_DESCRIPTION, DWRITE_INFORMATIONAL_STRING_DESIGNER, DWRITE_INFORMATIONAL_STRING_DESIGNER_URL, DWRITE_INFORMATIONAL_STRING_FONT_VENDOR_URL, DWRITE_INFORMATIONAL_STRING_FULL_NAME, DWRITE_INFORMATIONAL_STRING_ID, DWRITE_INFORMATIONAL_STRING_ID enumeration [Direct Write], DWRITE_INFORMATIONAL_STRING_LICENSE_DESCRIPTION, DWRITE_INFORMATIONAL_STRING_LICENSE_INFO_URL, DWRITE_INFORMATIONAL_STRING_MANUFACTURER, DWRITE_INFORMATIONAL_STRING_NONE, DWRITE_INFORMATIONAL_STRING_POSTSCRIPT_CID_NAME, DWRITE_INFORMATIONAL_STRING_POSTSCRIPT_NAME, DWRITE_INFORMATIONAL_STRING_PREFERRED_FAMILY_NAMES, DWRITE_INFORMATIONAL_STRING_PREFERRED_SUBFAMILY_NAMES, DWRITE_INFORMATIONAL_STRING_SAMPLE_TEXT, DWRITE_INFORMATIONAL_STRING_TRADEMARK, DWRITE_INFORMATIONAL_STRING_VERSION_STRINGS, DWRITE_INFORMATIONAL_STRING_WIN32_FAMILY_NAMES, DWRITE_INFORMATIONAL_STRING_WIN32_SUBFAMILY_NAMES, directwrite.dwrite_informational_string_id, dwrite/DWRITE_INFORMATIONAL_STRING_COPYRIGHT_NOTICE, dwrite/DWRITE_INFORMATIONAL_STRING_DESCRIPTION, dwrite/DWRITE_INFORMATIONAL_STRING_DESIGNER, dwrite/DWRITE_INFORMATIONAL_STRING_DESIGNER_URL, dwrite/DWRITE_INFORMATIONAL_STRING_FONT_VENDOR_URL, dwrite/DWRITE_INFORMATIONAL_STRING_FULL_NAME, dwrite/DWRITE_INFORMATIONAL_STRING_ID, dwrite/DWRITE_INFORMATIONAL_STRING_LICENSE_DESCRIPTION, dwrite/DWRITE_INFORMATIONAL_STRING_LICENSE_INFO_URL, dwrite/DWRITE_INFORMATIONAL_STRING_MANUFACTURER, dwrite/DWRITE_INFORMATIONAL_STRING_NONE, dwrite/DWRITE_INFORMATIONAL_STRING_POSTSCRIPT_CID_NAME, dwrite/DWRITE_INFORMATIONAL_STRING_POSTSCRIPT_NAME, dwrite/DWRITE_INFORMATIONAL_STRING_PREFERRED_FAMILY_NAMES, dwrite/DWRITE_INFORMATIONAL_STRING_PREFERRED_SUBFAMILY_NAMES, dwrite/DWRITE_INFORMATIONAL_STRING_SAMPLE_TEXT, dwrite/DWRITE_INFORMATIONAL_STRING_TRADEMARK, dwrite/DWRITE_INFORMATIONAL_STRING_VERSION_STRINGS, dwrite/DWRITE_INFORMATIONAL_STRING_WIN32_FAMILY_NAMES, dwrite/DWRITE_INFORMATIONAL_STRING_WIN32_SUBFAMILY_NAMES
f1_keywords:
- dwrite/DWRITE_INFORMATIONAL_STRING_ID
dev_langs:
- c++
req.header: dwrite.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 7, Windows Vista with SP2 and Platform Update for Windows Vista [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2008 R2, Windows Server 2008 with SP2 and Platform Update for Windows Server 2008 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- dwrite.h
api_name:
- DWRITE_INFORMATIONAL_STRING_ID
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# DWRITE_INFORMATIONAL_STRING_ID enumeration


## -description


The informational string enumeration which identifies a string embedded in a font file.


## -enum-fields




### -field DWRITE_INFORMATIONAL_STRING_NONE

Indicates the string containing the unspecified name ID.


### -field DWRITE_INFORMATIONAL_STRING_COPYRIGHT_NOTICE

Indicates the string containing the copyright notice provided by the font.


### -field DWRITE_INFORMATIONAL_STRING_VERSION_STRINGS

Indicates the string containing a version number.


### -field DWRITE_INFORMATIONAL_STRING_TRADEMARK

Indicates the string containing the trademark information provided by the font.


### -field DWRITE_INFORMATIONAL_STRING_MANUFACTURER

Indicates the string containing the name of the font manufacturer.


### -field DWRITE_INFORMATIONAL_STRING_DESIGNER

Indicates the string containing the name of the font designer.


### -field DWRITE_INFORMATIONAL_STRING_DESIGNER_URL

Indicates the string containing the URL of the font designer (with protocol, e.g., http://, ftp://).


### -field DWRITE_INFORMATIONAL_STRING_DESCRIPTION

Indicates the string containing the description of the font. This may also contain revision information, usage recommendations, history, features, and so on.


### -field DWRITE_INFORMATIONAL_STRING_FONT_VENDOR_URL

Indicates the string containing the URL of the font vendor (with protocol, e.g., http://, ftp://). If a unique serial number is embedded in the URL, it can be used to register the font.


### -field DWRITE_INFORMATIONAL_STRING_LICENSE_DESCRIPTION

Indicates the string containing the description of how the font may be legally used, or different example scenarios for licensed use.


### -field DWRITE_INFORMATIONAL_STRING_LICENSE_INFO_URL

Indicates the string containing the URL where additional licensing information can be found.


### -field DWRITE_INFORMATIONAL_STRING_WIN32_FAMILY_NAMES

Indicates the string containing the GDI-compatible family name. Since GDI allows a maximum of four fonts per family, fonts in the same family may have different GDI-compatible family names (e.g., "Arial", "Arial Narrow", "Arial Black").


### -field DWRITE_INFORMATIONAL_STRING_WIN32_SUBFAMILY_NAMES

Indicates the string containing a GDI-compatible subfamily name.


### -field DWRITE_INFORMATIONAL_STRING_TYPOGRAPHIC_FAMILY_NAMES


### -field DWRITE_INFORMATIONAL_STRING_TYPOGRAPHIC_SUBFAMILY_NAMES


### -field DWRITE_INFORMATIONAL_STRING_SAMPLE_TEXT

Contains sample text for display in font lists. This can be the font name or any other text that the designer thinks is the best 

example to display the font in.


### -field DWRITE_INFORMATIONAL_STRING_FULL_NAME

The full name of the font, like Arial Bold, from <i>name id 4</i> in the name table


### -field DWRITE_INFORMATIONAL_STRING_POSTSCRIPT_NAME

The postscript name of the font, like GillSans-Bold, from <i>name id 6</i> in the name table.


### -field DWRITE_INFORMATIONAL_STRING_POSTSCRIPT_CID_NAME

The postscript CID findfont name, from <i>name id 20</i> in the name table


### -field DWRITE_INFORMATIONAL_STRING_WEIGHT_STRETCH_STYLE_FAMILY_NAME


### -field DWRITE_INFORMATIONAL_STRING_DESIGN_SCRIPT_LANGUAGE_TAG


### -field DWRITE_INFORMATIONAL_STRING_SUPPORTED_SCRIPT_LANGUAGE_TAG


### -field DWRITE_INFORMATIONAL_STRING_PREFERRED_FAMILY_NAMES

Indicates the string containing the family name preferred by the designer. This enables font designers to group more than four fonts in a single family without losing compatibility with GDI. This name is typically only present if it differs from the GDI-compatible family name.


### -field DWRITE_INFORMATIONAL_STRING_PREFERRED_SUBFAMILY_NAMES

Indicates the string containing the subfamily name preferred by the designer. This name is typically only present if it differs from the GDI-compatible subfamily name.


### -field DWRITE_INFORMATIONAL_STRING_WWS_FAMILY_NAME



