---
UID: NE:dwrite.DWRITE_PARAGRAPH_ALIGNMENT
title: DWRITE_PARAGRAPH_ALIGNMENT (dwrite.h)
description: Specifies the alignment of paragraph text along the flow direction axis, relative to the top and bottom of the flow's layout box.
old-location: directwrite\dwrite_paragraph_alignment.htm
tech.root: DirectWrite
ms.assetid: fcd11308-741a-47cb-aa7a-0ae2c7a9e769
ms.date: 12/05/2018
ms.keywords: DWRITE_PARAGRAPH_ALIGNMENT, DWRITE_PARAGRAPH_ALIGNMENT enumeration [Direct Write], DWRITE_PARAGRAPH_ALIGNMENT_CENTER, DWRITE_PARAGRAPH_ALIGNMENT_FAR, DWRITE_PARAGRAPH_ALIGNMENT_NEAR, directwrite.dwrite_paragraph_alignment, dwrite/DWRITE_PARAGRAPH_ALIGNMENT, dwrite/DWRITE_PARAGRAPH_ALIGNMENT_CENTER, dwrite/DWRITE_PARAGRAPH_ALIGNMENT_FAR, dwrite/DWRITE_PARAGRAPH_ALIGNMENT_NEAR
f1_keywords:
- dwrite/DWRITE_PARAGRAPH_ALIGNMENT
dev_langs:
- c++
req.header: dwrite.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 7, Windows Vista with SP2 and Platform Update for Windows Vista [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2008 R2, Windows Server 2008 with SP2 and Platform Update for Windows Server 2008 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- dwrite.h
api_name:
- DWRITE_PARAGRAPH_ALIGNMENT
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# DWRITE_PARAGRAPH_ALIGNMENT enumeration


## -description


Specifies the alignment of paragraph text along the flow direction axis, relative to the top and bottom of the flow's layout box.
  


## -enum-fields




### -field DWRITE_PARAGRAPH_ALIGNMENT_NEAR

The top of the text flow is aligned to the top edge of the layout box.


### -field DWRITE_PARAGRAPH_ALIGNMENT_FAR

The bottom of the text flow is aligned to the bottom edge of the layout box.


### -field DWRITE_PARAGRAPH_ALIGNMENT_CENTER

The center of the flow is aligned to the center of the layout box.

