---
UID: NE:dwrite.DWRITE_TEXT_ALIGNMENT
title: DWRITE_TEXT_ALIGNMENT (dwrite.h)
description: Specifies the alignment of paragraph text along the reading direction axis, relative to the leading and trailing edge of the layout box.
old-location: directwrite\dwrite_text_alignment.htm
tech.root: DirectWrite
ms.assetid: 76b347f8-185b-4da6-9647-4d066334ac12
ms.date: 12/05/2018
ms.keywords: DWRITE_TEXT_ALIGNMENT, DWRITE_TEXT_ALIGNMENT enumeration [Direct Write], DWRITE_TEXT_ALIGNMENT_CENTER, DWRITE_TEXT_ALIGNMENT_JUSTIFIED, DWRITE_TEXT_ALIGNMENT_LEADING, DWRITE_TEXT_ALIGNMENT_TRAILING, directwrite.dwrite_text_alignment, dwrite/DWRITE_TEXT_ALIGNMENT, dwrite/DWRITE_TEXT_ALIGNMENT_CENTER, dwrite/DWRITE_TEXT_ALIGNMENT_JUSTIFIED, dwrite/DWRITE_TEXT_ALIGNMENT_LEADING, dwrite/DWRITE_TEXT_ALIGNMENT_TRAILING
f1_keywords:
- dwrite/DWRITE_TEXT_ALIGNMENT
dev_langs:
- c++
req.header: dwrite.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 7, Windows Vista with SP2 and Platform Update for Windows Vista [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2008 R2, Windows Server 2008 with SP2 and Platform Update for Windows Server 2008 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- dwrite.h
api_name:
- DWRITE_TEXT_ALIGNMENT
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# DWRITE_TEXT_ALIGNMENT enumeration


## -description


Specifies the alignment of paragraph text along the reading direction axis, relative to the leading and trailing edge of the layout box.


## -enum-fields




### -field DWRITE_TEXT_ALIGNMENT_LEADING

The leading edge of the paragraph text is aligned to the leading edge of the layout box.


### -field DWRITE_TEXT_ALIGNMENT_TRAILING

The trailing edge of the paragraph text is aligned to the  trailing edge of the layout box.


### -field DWRITE_TEXT_ALIGNMENT_CENTER

The center of the paragraph text is aligned to the center of the layout box.


### -field DWRITE_TEXT_ALIGNMENT_JUSTIFIED

Align text to the leading side, and also justify text to fill the lines.

