---
UID: NE:dwrite_1.DWRITE_PANOSE_CONTRAST
title: DWRITE_PANOSE_CONTRAST (dwrite_1.h)
description: The DWRITE_PANOSE_CONTRAST enumeration contains values that specify the ratio between thickest and thinnest point of the stroke for a letter such as uppercase 'O'.
old-location: directwrite\dwrite_panose_contrast.htm
tech.root: DirectWrite
ms.assetid: EB526A2A-1E85-4A65-B485-4AE87F45C2A0
ms.date: 12/05/2018
ms.keywords: DWRITE_PANOSE_CONTRAST, DWRITE_PANOSE_CONTRAST enumeration [Direct Write], DWRITE_PANOSE_CONTRAST_ANY, DWRITE_PANOSE_CONTRAST_BROKEN, DWRITE_PANOSE_CONTRAST_HIGH, DWRITE_PANOSE_CONTRAST_HORIZONTAL_HIGH, DWRITE_PANOSE_CONTRAST_HORIZONTAL_LOW, DWRITE_PANOSE_CONTRAST_HORIZONTAL_MEDIUM, DWRITE_PANOSE_CONTRAST_LOW, DWRITE_PANOSE_CONTRAST_MEDIUM, DWRITE_PANOSE_CONTRAST_MEDIUM_HIGH, DWRITE_PANOSE_CONTRAST_MEDIUM_LOW, DWRITE_PANOSE_CONTRAST_NONE, DWRITE_PANOSE_CONTRAST_NO_FIT, DWRITE_PANOSE_CONTRAST_VERY_HIGH, DWRITE_PANOSE_CONTRAST_VERY_LOW, directwrite.dwrite_panose_contrast, dwrite_1/DWRITE_PANOSE_CONTRAST, dwrite_1/DWRITE_PANOSE_CONTRAST_ANY, dwrite_1/DWRITE_PANOSE_CONTRAST_BROKEN, dwrite_1/DWRITE_PANOSE_CONTRAST_HIGH, dwrite_1/DWRITE_PANOSE_CONTRAST_HORIZONTAL_HIGH, dwrite_1/DWRITE_PANOSE_CONTRAST_HORIZONTAL_LOW, dwrite_1/DWRITE_PANOSE_CONTRAST_HORIZONTAL_MEDIUM, dwrite_1/DWRITE_PANOSE_CONTRAST_LOW, dwrite_1/DWRITE_PANOSE_CONTRAST_MEDIUM, dwrite_1/DWRITE_PANOSE_CONTRAST_MEDIUM_HIGH, dwrite_1/DWRITE_PANOSE_CONTRAST_MEDIUM_LOW, dwrite_1/DWRITE_PANOSE_CONTRAST_NONE, dwrite_1/DWRITE_PANOSE_CONTRAST_NO_FIT, dwrite_1/DWRITE_PANOSE_CONTRAST_VERY_HIGH, dwrite_1/DWRITE_PANOSE_CONTRAST_VERY_LOW
f1_keywords:
- dwrite_1/DWRITE_PANOSE_CONTRAST
dev_langs:
- c++
req.header: dwrite_1.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8 and Platform Update for Windows 7 [desktop apps only]
req.target-min-winversvr: Windows Server 2012 and Platform Update for Windows Server 2008 R2 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Dwrite_1.h
api_name:
- DWRITE_PANOSE_CONTRAST
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# DWRITE_PANOSE_CONTRAST enumeration


## -description


The <b>DWRITE_PANOSE_CONTRAST</b> enumeration contains values that specify the ratio between thickest and thinnest point of the stroke for a letter such as uppercase 'O'.


## -enum-fields




### -field DWRITE_PANOSE_CONTRAST_ANY

Any contrast.


### -field DWRITE_PANOSE_CONTRAST_NO_FIT

No fit contrast.


### -field DWRITE_PANOSE_CONTRAST_NONE

No contrast.


### -field DWRITE_PANOSE_CONTRAST_VERY_LOW

Very low contrast.


### -field DWRITE_PANOSE_CONTRAST_LOW

Low contrast.


### -field DWRITE_PANOSE_CONTRAST_MEDIUM_LOW

Medium low contrast.


### -field DWRITE_PANOSE_CONTRAST_MEDIUM

Medium contrast.


### -field DWRITE_PANOSE_CONTRAST_MEDIUM_HIGH

Medium high contrast.


### -field DWRITE_PANOSE_CONTRAST_HIGH

High contrast.


### -field DWRITE_PANOSE_CONTRAST_VERY_HIGH

Very high contrast.


### -field DWRITE_PANOSE_CONTRAST_HORIZONTAL_LOW

Horizontal low contrast.


### -field DWRITE_PANOSE_CONTRAST_HORIZONTAL_MEDIUM

Horizontal medium contrast.


### -field DWRITE_PANOSE_CONTRAST_HORIZONTAL_HIGH

Horizontal high contrast.


### -field DWRITE_PANOSE_CONTRAST_BROKEN

Broken contrast.


## -see-also




<a href="/windows/win32/api/dwrite_1/ns-dwrite_1-dwrite_panose">DWRITE_PANOSE</a>
 

 

