---
UID: NE:dwrite_1.DWRITE_PANOSE_MIDLINE
title: DWRITE_PANOSE_MIDLINE (dwrite_1.h)
description: The DWRITE_PANOSE_MIDLINE enumeration contains values that specify info about the placement of midline across uppercase characters and the treatment of diagonal stem apexes.
old-location: directwrite\dwrite_panose_midline.htm
tech.root: DirectWrite
ms.assetid: 97639251-7703-4F3B-85FC-E33D666CA837
ms.date: 12/05/2018
ms.keywords: DWRITE_PANOSE_MIDLINE, DWRITE_PANOSE_MIDLINE enumeration [Direct Write], DWRITE_PANOSE_MIDLINE_ANY, DWRITE_PANOSE_MIDLINE_CONSTANT_POINTED, DWRITE_PANOSE_MIDLINE_CONSTANT_SERIFED, DWRITE_PANOSE_MIDLINE_CONSTANT_TRIMMED, DWRITE_PANOSE_MIDLINE_HIGH_POINTED, DWRITE_PANOSE_MIDLINE_HIGH_SERIFED, DWRITE_PANOSE_MIDLINE_HIGH_TRIMMED, DWRITE_PANOSE_MIDLINE_LOW_POINTED, DWRITE_PANOSE_MIDLINE_LOW_SERIFED, DWRITE_PANOSE_MIDLINE_LOW_TRIMMED, DWRITE_PANOSE_MIDLINE_NO_FIT, DWRITE_PANOSE_MIDLINE_STANDARD_POINTED, DWRITE_PANOSE_MIDLINE_STANDARD_SERIFED, DWRITE_PANOSE_MIDLINE_STANDARD_TRIMMED, directwrite.dwrite_panose_midline, dwrite_1/DWRITE_PANOSE_MIDLINE, dwrite_1/DWRITE_PANOSE_MIDLINE_ANY, dwrite_1/DWRITE_PANOSE_MIDLINE_CONSTANT_POINTED, dwrite_1/DWRITE_PANOSE_MIDLINE_CONSTANT_SERIFED, dwrite_1/DWRITE_PANOSE_MIDLINE_CONSTANT_TRIMMED, dwrite_1/DWRITE_PANOSE_MIDLINE_HIGH_POINTED, dwrite_1/DWRITE_PANOSE_MIDLINE_HIGH_SERIFED, dwrite_1/DWRITE_PANOSE_MIDLINE_HIGH_TRIMMED, dwrite_1/DWRITE_PANOSE_MIDLINE_LOW_POINTED, dwrite_1/DWRITE_PANOSE_MIDLINE_LOW_SERIFED, dwrite_1/DWRITE_PANOSE_MIDLINE_LOW_TRIMMED, dwrite_1/DWRITE_PANOSE_MIDLINE_NO_FIT, dwrite_1/DWRITE_PANOSE_MIDLINE_STANDARD_POINTED, dwrite_1/DWRITE_PANOSE_MIDLINE_STANDARD_SERIFED, dwrite_1/DWRITE_PANOSE_MIDLINE_STANDARD_TRIMMED
f1_keywords:
- dwrite_1/DWRITE_PANOSE_MIDLINE
dev_langs:
- c++
req.header: dwrite_1.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8 and Platform Update for Windows 7 [desktop apps only]
req.target-min-winversvr: Windows Server 2012 and Platform Update for Windows Server 2008 R2 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Dwrite_1.h
api_name:
- DWRITE_PANOSE_MIDLINE
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# DWRITE_PANOSE_MIDLINE enumeration


## -description


The <b>DWRITE_PANOSE_MIDLINE</b> enumeration contains values that specify info about the placement of midline across uppercase characters and the treatment of diagonal stem apexes.


## -enum-fields




### -field DWRITE_PANOSE_MIDLINE_ANY

Any midline.


### -field DWRITE_PANOSE_MIDLINE_NO_FIT

No fit midline.


### -field DWRITE_PANOSE_MIDLINE_STANDARD_TRIMMED

Standard trimmed midline.


### -field DWRITE_PANOSE_MIDLINE_STANDARD_POINTED

Standard pointed midline.


### -field DWRITE_PANOSE_MIDLINE_STANDARD_SERIFED

Standard serifed midline.


### -field DWRITE_PANOSE_MIDLINE_HIGH_TRIMMED

High trimmed midline.


### -field DWRITE_PANOSE_MIDLINE_HIGH_POINTED

High pointed midline.


### -field DWRITE_PANOSE_MIDLINE_HIGH_SERIFED

High serifed midline.


### -field DWRITE_PANOSE_MIDLINE_CONSTANT_TRIMMED

Constant trimmed midline.


### -field DWRITE_PANOSE_MIDLINE_CONSTANT_POINTED

Constant pointed midline.


### -field DWRITE_PANOSE_MIDLINE_CONSTANT_SERIFED

Constant serifed midline.


### -field DWRITE_PANOSE_MIDLINE_LOW_TRIMMED

Low trimmed midline.


### -field DWRITE_PANOSE_MIDLINE_LOW_POINTED

Low pointed midline.


### -field DWRITE_PANOSE_MIDLINE_LOW_SERIFED

Low serifed midline.


## -see-also




<a href="/windows/win32/api/dwrite_1/ns-dwrite_1-dwrite_panose">DWRITE_PANOSE</a>
 

 

