---
UID: NE:dwrite_1.DWRITE_PANOSE_SCRIPT_TOPOLOGY
title: DWRITE_PANOSE_SCRIPT_TOPOLOGY (dwrite_1.h)
description: The DWRITE_PANOSE_SCRIPT_TOPOLOGY enumeration contains values that specify the topology of letterforms.
old-location: directwrite\dwrite_panose_script_topology.htm
tech.root: DirectWrite
ms.assetid: 6D546DCF-3812-495C-AAF3-A7C2E14CACA2
ms.date: 12/05/2018
ms.keywords: DWRITE_PANOSE_SCRIPT_TOPOLOGY, DWRITE_PANOSE_SCRIPT_TOPOLOGY enumeration [Direct Write], DWRITE_PANOSE_SCRIPT_TOPOLOGY_ANY, DWRITE_PANOSE_SCRIPT_TOPOLOGY_BLACKLETTER_CONNECTED, DWRITE_PANOSE_SCRIPT_TOPOLOGY_BLACKLETTER_DISCONNECTED, DWRITE_PANOSE_SCRIPT_TOPOLOGY_BLACKLETTER_TRAILING, DWRITE_PANOSE_SCRIPT_TOPOLOGY_CURSIVE_CONNECTED, DWRITE_PANOSE_SCRIPT_TOPOLOGY_CURSIVE_DISCONNECTED, DWRITE_PANOSE_SCRIPT_TOPOLOGY_CURSIVE_TRAILING, DWRITE_PANOSE_SCRIPT_TOPOLOGY_NO_FIT, DWRITE_PANOSE_SCRIPT_TOPOLOGY_ROMAN_CONNECTED, DWRITE_PANOSE_SCRIPT_TOPOLOGY_ROMAN_DISCONNECTED, DWRITE_PANOSE_SCRIPT_TOPOLOGY_ROMAN_TRAILING, directwrite.dwrite_panose_script_topology, dwrite_1/DWRITE_PANOSE_SCRIPT_TOPOLOGY, dwrite_1/DWRITE_PANOSE_SCRIPT_TOPOLOGY_ANY, dwrite_1/DWRITE_PANOSE_SCRIPT_TOPOLOGY_BLACKLETTER_CONNECTED, dwrite_1/DWRITE_PANOSE_SCRIPT_TOPOLOGY_BLACKLETTER_DISCONNECTED, dwrite_1/DWRITE_PANOSE_SCRIPT_TOPOLOGY_BLACKLETTER_TRAILING, dwrite_1/DWRITE_PANOSE_SCRIPT_TOPOLOGY_CURSIVE_CONNECTED, dwrite_1/DWRITE_PANOSE_SCRIPT_TOPOLOGY_CURSIVE_DISCONNECTED, dwrite_1/DWRITE_PANOSE_SCRIPT_TOPOLOGY_CURSIVE_TRAILING, dwrite_1/DWRITE_PANOSE_SCRIPT_TOPOLOGY_NO_FIT, dwrite_1/DWRITE_PANOSE_SCRIPT_TOPOLOGY_ROMAN_CONNECTED, dwrite_1/DWRITE_PANOSE_SCRIPT_TOPOLOGY_ROMAN_DISCONNECTED, dwrite_1/DWRITE_PANOSE_SCRIPT_TOPOLOGY_ROMAN_TRAILING
f1_keywords:
- dwrite_1/DWRITE_PANOSE_SCRIPT_TOPOLOGY
dev_langs:
- c++
req.header: dwrite_1.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8 and Platform Update for Windows 7 [desktop apps only]
req.target-min-winversvr: Windows Server 2012 and Platform Update for Windows Server 2008 R2 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Dwrite_1.h
api_name:
- DWRITE_PANOSE_SCRIPT_TOPOLOGY
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# DWRITE_PANOSE_SCRIPT_TOPOLOGY enumeration


## -description


The <b>DWRITE_PANOSE_SCRIPT_TOPOLOGY</b> enumeration contains values that specify the topology of letterforms.


## -enum-fields




### -field DWRITE_PANOSE_SCRIPT_TOPOLOGY_ANY

Any script topology.


### -field DWRITE_PANOSE_SCRIPT_TOPOLOGY_NO_FIT

No fit for script topology.


### -field DWRITE_PANOSE_SCRIPT_TOPOLOGY_ROMAN_DISCONNECTED

Script topology is roman disconnected.


### -field DWRITE_PANOSE_SCRIPT_TOPOLOGY_ROMAN_TRAILING

Script topology is roman trailing.


### -field DWRITE_PANOSE_SCRIPT_TOPOLOGY_ROMAN_CONNECTED

Script topology is roman connected.


### -field DWRITE_PANOSE_SCRIPT_TOPOLOGY_CURSIVE_DISCONNECTED

Script topology is cursive disconnected.


### -field DWRITE_PANOSE_SCRIPT_TOPOLOGY_CURSIVE_TRAILING

Script topology is cursive trailing.


### -field DWRITE_PANOSE_SCRIPT_TOPOLOGY_CURSIVE_CONNECTED

Script topology is cursive connected.


### -field DWRITE_PANOSE_SCRIPT_TOPOLOGY_BLACKLETTER_DISCONNECTED

Script topology is black-letter disconnected.


### -field DWRITE_PANOSE_SCRIPT_TOPOLOGY_BLACKLETTER_TRAILING

Script topology is black-letter trailing.


### -field DWRITE_PANOSE_SCRIPT_TOPOLOGY_BLACKLETTER_CONNECTED

Script topology is black-letter connected.


## -see-also




<a href="/windows/win32/api/dwrite_1/ns-dwrite_1-dwrite_panose">DWRITE_PANOSE</a>
 

 

