---
UID: NE:dwrite_1.DWRITE_PANOSE_STROKE_VARIATION
title: DWRITE_PANOSE_STROKE_VARIATION (dwrite_1.h)
description: The DWRITE_PANOSE_STROKE_VARIATION enumeration contains values that specify the relationship between thin and thick stems of text characters.
old-location: directwrite\dwrite_panose_stroke_variation.htm
tech.root: DirectWrite
ms.assetid: 3E30D318-1A88-4563-93D7-7E84893D04CE
ms.date: 12/05/2018
ms.keywords: DWRITE_PANOSE_STROKE_VARIATION, DWRITE_PANOSE_STROKE_VARIATION enumeration [Direct Write], DWRITE_PANOSE_STROKE_VARIATION_ANY, DWRITE_PANOSE_STROKE_VARIATION_GRADUAL_DIAGONAL, DWRITE_PANOSE_STROKE_VARIATION_GRADUAL_HORIZONTAL, DWRITE_PANOSE_STROKE_VARIATION_GRADUAL_TRANSITIONAL, DWRITE_PANOSE_STROKE_VARIATION_GRADUAL_VERTICAL, DWRITE_PANOSE_STROKE_VARIATION_INSTANT_HORIZONTAL, DWRITE_PANOSE_STROKE_VARIATION_INSTANT_VERTICAL, DWRITE_PANOSE_STROKE_VARIATION_NO_FIT, DWRITE_PANOSE_STROKE_VARIATION_NO_VARIATION, DWRITE_PANOSE_STROKE_VARIATION_RAPID_HORIZONTAL, DWRITE_PANOSE_STROKE_VARIATION_RAPID_VERTICAL, directwrite.dwrite_panose_stroke_variation, dwrite_1/DWRITE_PANOSE_STROKE_VARIATION, dwrite_1/DWRITE_PANOSE_STROKE_VARIATION_ANY, dwrite_1/DWRITE_PANOSE_STROKE_VARIATION_GRADUAL_DIAGONAL, dwrite_1/DWRITE_PANOSE_STROKE_VARIATION_GRADUAL_HORIZONTAL, dwrite_1/DWRITE_PANOSE_STROKE_VARIATION_GRADUAL_TRANSITIONAL, dwrite_1/DWRITE_PANOSE_STROKE_VARIATION_GRADUAL_VERTICAL, dwrite_1/DWRITE_PANOSE_STROKE_VARIATION_INSTANT_HORIZONTAL, dwrite_1/DWRITE_PANOSE_STROKE_VARIATION_INSTANT_VERTICAL, dwrite_1/DWRITE_PANOSE_STROKE_VARIATION_NO_FIT, dwrite_1/DWRITE_PANOSE_STROKE_VARIATION_NO_VARIATION, dwrite_1/DWRITE_PANOSE_STROKE_VARIATION_RAPID_HORIZONTAL, dwrite_1/DWRITE_PANOSE_STROKE_VARIATION_RAPID_VERTICAL
f1_keywords:
- dwrite_1/DWRITE_PANOSE_STROKE_VARIATION
dev_langs:
- c++
req.header: dwrite_1.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8 and Platform Update for Windows 7 [desktop apps only]
req.target-min-winversvr: Windows Server 2012 and Platform Update for Windows Server 2008 R2 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Dwrite_1.h
api_name:
- DWRITE_PANOSE_STROKE_VARIATION
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# DWRITE_PANOSE_STROKE_VARIATION enumeration


## -description


The <b>DWRITE_PANOSE_STROKE_VARIATION</b> enumeration contains values that specify the relationship between thin and thick stems of text characters.


## -enum-fields




### -field DWRITE_PANOSE_STROKE_VARIATION_ANY

Any stroke variation for text characters.


### -field DWRITE_PANOSE_STROKE_VARIATION_NO_FIT

No fit stroke variation for text characters.


### -field DWRITE_PANOSE_STROKE_VARIATION_NO_VARIATION

No stroke variation for text characters.


### -field DWRITE_PANOSE_STROKE_VARIATION_GRADUAL_DIAGONAL

The stroke variation for text characters is gradual diagonal.


### -field DWRITE_PANOSE_STROKE_VARIATION_GRADUAL_TRANSITIONAL

The stroke variation for text characters is gradual transitional.


### -field DWRITE_PANOSE_STROKE_VARIATION_GRADUAL_VERTICAL

The stroke variation for text characters is gradual vertical.


### -field DWRITE_PANOSE_STROKE_VARIATION_GRADUAL_HORIZONTAL

The stroke variation for text characters is gradual horizontal.


### -field DWRITE_PANOSE_STROKE_VARIATION_RAPID_VERTICAL

The stroke variation for text characters is rapid vertical.


### -field DWRITE_PANOSE_STROKE_VARIATION_RAPID_HORIZONTAL

The stroke variation for text characters is rapid horizontal.


### -field DWRITE_PANOSE_STROKE_VARIATION_INSTANT_VERTICAL

The stroke variation for text characters is instant vertical.


### -field DWRITE_PANOSE_STROKE_VARIATION_INSTANT_HORIZONTAL

The stroke variation for text characters is instant horizontal.


## -see-also




<a href="/windows/win32/api/dwrite_1/ns-dwrite_1-dwrite_panose">DWRITE_PANOSE</a>
 

 

