---
UID: NF:dwrite_1.IDWriteFontFace1.IsMonospacedFont
title: IDWriteFontFace1::IsMonospacedFont (dwrite_1.h)
description: Determines whether the font of a text range is monospaced, that is, the font characters are the same fixed-pitch width.
old-location: directwrite\idwritefontface1_ismonospacedfont.htm
tech.root: DirectWrite
ms.assetid: 5A83F330-FADA-4307-BCCE-DDCCF5D1D429
ms.date: 12/05/2018
ms.keywords: IDWriteFontFace1 interface [Direct Write],IsMonospacedFont method, IDWriteFontFace1.IsMonospacedFont, IDWriteFontFace1::IsMonospacedFont, IsMonospacedFont, IsMonospacedFont method [Direct Write], IsMonospacedFont method [Direct Write],IDWriteFontFace1 interface, directwrite.idwritefontface1_ismonospacedfont, dwrite_1/IDWriteFontFace1::IsMonospacedFont
f1_keywords:
- dwrite_1/IDWriteFontFace1.IsMonospacedFont
dev_langs:
- c++
req.header: dwrite_1.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8 and Platform Update for Windows 7 [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2012 and Platform Update for Windows Server 2008 R2 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Dwrite_1.lib
req.dll: Dwrite_1.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- dwrite_1.dll
api_name:
- IDWriteFontFace1.IsMonospacedFont
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IDWriteFontFace1::IsMonospacedFont


## -description


Determines whether the font of a text range is monospaced, that is, the font characters are the
    same fixed-pitch width.


## -parameters






## -returns



Type: <b>BOOL</b>

Returns TRUE if the font is monospaced, otherwise it returns FALSE.




## -see-also




<a href="/windows/win32/api/dwrite/nf-dwrite-idwritefont-issymbolfont">IDWriteFont::IsSymbolFont</a>



<a href="/windows/win32/api/dwrite_1/nn-dwrite_1-idwritefontface1">IDWriteFontFace1</a>



<a href="/windows/win32/api/dwrite/nf-dwrite-idwritefontface-issymbolfont">IDWriteFontFace::IsSymbolFont</a>
 

 

