---
UID: NS:dwrite_1.DWRITE_UNICODE_RANGE
title: DWRITE_UNICODE_RANGE (dwrite_1.h)
description: The DWRITE_UNICODE_RANGE structure specifies the range of Unicode code points.
old-location: directwrite\dwrite_unicode_range.htm
tech.root: DirectWrite
ms.assetid: 93DC235F-7E61-44CE-A949-8ABBD1D62CFF
ms.date: 12/05/2018
ms.keywords: DWRITE_UNICODE_RANGE, DWRITE_UNICODE_RANGE structure [Direct Write], directwrite.dwrite_unicode_range, dwrite_1/DWRITE_UNICODE_RANGE
f1_keywords:
- dwrite_1/DWRITE_UNICODE_RANGE
dev_langs:
- c++
req.header: dwrite_1.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8 and Platform Update for Windows 7 [desktop apps only]
req.target-min-winversvr: Windows Server 2012 and Platform Update for Windows Server 2008 R2 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Dwrite_1.h
api_name:
- DWRITE_UNICODE_RANGE
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# DWRITE_UNICODE_RANGE structure


## -description


The <b>DWRITE_UNICODE_RANGE</b> structure specifies the range of Unicode code points.


## -struct-fields




### -field first

The first code point in the Unicode range.


### -field last

The last code point in the Unicode range.


## -see-also




<a href="/windows/win32/api/dwrite_1/nf-dwrite_1-idwritefont1-getunicoderanges">IDWriteFont1::GetUnicodeRanges</a>



<a href="/windows/win32/api/dwrite_1/nf-dwrite_1-idwritefontface1-getunicoderanges">IDWriteFontFace1::GetUnicodeRanges</a>
 

 

