---
UID: NF:dwrite_3.IDWriteFontResource.GetFontAxisAttributes
title: IDWriteFontResource::GetFontAxisAttributes
description: Retrieves attributes describing the given axis, such as whether the font author recommends to hide the axis in user interfaces.
tech.root: DirectWrite
ms.date: 09/16/2019
ms.keywords: IDWriteFontResource interface [Direct Write],GetFontAxisAttributes method, IDWriteFontResource.GetFontAxisAttributes, IDWriteFontResource::GetFontAxisAttributes, GetFontAxisAttributes, GetFontAxisAttributes method [Direct Write], GetFontAxisAttributes method [Direct Write],IDWriteFontResource interface, directwrite.idwritefontresource_getfontaxisattributes, dwrite_3/IDWriteFontResource::GetFontAxisAttributes
f1_keywords:
- dwrite_3/IDWriteFontResource.GetFontAxisAttributes
dev_langs:
- c++
req.construct-type: function
req.header: dwrite_3.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Dwrite.lib
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Dwrite.lib
- Dwrite.dll
api_name:
- IDWriteFontResource::GetFontAxisAttributes
targetos: Windows
req.typenames: 
req.redist: 
---

## -description

Retrieves attributes describing the given axis, such as whether the font author recommends to hide the axis in user interfaces.

## -parameters

### -param axisIndex

Type: **[UINT32](/windows/win32/winprog/windows-data-types)**

Font axis, from 0 to [GetFontAxisCount](/windows/win32/api/dwrite/nf-dwrite_3-idwritefontresource-getfontaxiscount) minus 1.

## -returns

Type: **[DWRITE_FONT_AXIS_ATTRIBUTES](/windows/win32/api/dwrite_3/ne-dwrite_3-dwrite_font_axis_attributes)**

The attributes for the given axis, or **DWRITE_FONT_AXIS_ATTRIBUTES_NONE** if *axisIndex* is beyond the font count.

## -remarks

## -see-also
