---
UID: NF:dxva2api.DXVA2_Fixed32OpaqueAlpha
title: DXVA2_Fixed32OpaqueAlpha function (dxva2api.h)
description: Returns a DXVA2_Fixed32 structure that contains an opaque alpha value.
old-location: mf\dxva2_fixed32opaquealpha.htm
tech.root: medfound
ms.assetid: de2f8aa8-0e06-4f47-9d69-dfff07bc4c0f
ms.date: 12/05/2018
ms.keywords: DXVA2_Fixed32OpaqueAlpha, DXVA2_Fixed32OpaqueAlpha function [Media Foundation], de2f8aa8-0e06-4f47-9d69-dfff07bc4c0f, dxva2api/DXVA2_Fixed32OpaqueAlpha, mf.dxva2_fixed32opaquealpha
f1_keywords:
- dxva2api/DXVA2_Fixed32OpaqueAlpha
dev_langs:
- c++
req.header: dxva2api.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- dxva2api.h
api_name:
- DXVA2_Fixed32OpaqueAlpha
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# DXVA2_Fixed32OpaqueAlpha function


## -description


Returns a <a href="https://docs.microsoft.com/windows/desktop/api/dxva2api/ns-dxva2api-dxva2_fixed32">DXVA2_Fixed32</a> structure that contains an opaque alpha value.

You can use this function for DirectX Video Acceleration (DXVA) operations that require alpha values expressed as fixed-point numbers.


## -parameters






## -returns



The function returns a <a href="https://docs.microsoft.com/windows/desktop/api/dxva2api/ns-dxva2api-dxva2_fixed32">DXVA2_Fixed32</a> structure that contains an opaque alpha value.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/dxva2api/ns-dxva2api-dxva2_videoprocessbltparams">DXVA2_VideoProcessBltParams</a>



<a href="https://docs.microsoft.com/windows/desktop/api/dxva2api/ns-dxva2api-dxva2_videosample">DXVA2_VideoSample</a>



<a href="https://docs.microsoft.com/windows/desktop/medfound/media-foundation-functions">Media Foundation Functions</a>
 

 

