---
UID: NF:dxva2api.DXVA2FixedToFloat
title: DXVA2FixedToFloat function (dxva2api.h)
description: Converts a DXVA2_Fixed32 value to a floating-point number.
old-location: mf\dxva2fixedtofloat.htm
tech.root: medfound
ms.assetid: f92c1d78-a2a7-469e-926a-7ba5ad8221e1
ms.date: 12/05/2018
ms.keywords: DXVA2FixedToFloat, DXVA2FixedToFloat function [Media Foundation], dxva2api/DXVA2FixedToFloat, f92c1d78-a2a7-469e-926a-7ba5ad8221e1, mf.dxva2fixedtofloat
f1_keywords:
- dxva2api/DXVA2FixedToFloat
dev_langs:
- c++
req.header: dxva2api.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- dxva2api.h
api_name:
- DXVA2FixedToFloat
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# DXVA2FixedToFloat function


## -description



Converts a <a href="https://docs.microsoft.com/windows/desktop/api/dxva2api/ns-dxva2api-dxva2_fixed32">DXVA2_Fixed32</a> value to a floating-point number.




## -parameters




### -param _fixed_ [in]


<a href="https://docs.microsoft.com/windows/desktop/api/dxva2api/ns-dxva2api-dxva2_fixed32">DXVA2_Fixed32</a> structure that contains a fixed-point value.


## -returns



The function returns the converted floating-point number.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/medfound/media-foundation-functions">Media Foundation Functions</a>
 

 

